/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BlockScope;
import freemarker.core.Environment;
import freemarker.core.Scope;
import freemarker.core.ast.IteratorBlock;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateNode;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;

public class LoopContext
extends BlockScope {
    private boolean hasNext;
    private TemplateModel loopVar;
    private int index;
    private TemplateModel list;

    public LoopContext(IteratorBlock iteratorBlock, Scope enclosingScope, TemplateModel list) {
        super(iteratorBlock, enclosingScope);
        this.list = list;
    }

    public void runLoop() throws TemplateException, IOException {
        IteratorBlock iteratorBlock = (IteratorBlock)this.block;
        Environment env = this.getEnvironment();
        if (this.list instanceof TemplateCollectionModel) {
            TemplateCollectionModel baseListModel = (TemplateCollectionModel)this.list;
            TemplateModelIterator it = baseListModel.iterator();
            this.hasNext = it.hasNext();
            while (this.hasNext) {
                this.clear();
                this.loopVar = it.next();
                this.hasNext = it.hasNext();
                this.put(iteratorBlock.getIndexName(), this.loopVar);
                TemplateBooleanModel hasNextModel = this.hasNext ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                this.put(iteratorBlock.getIndexName() + "_has_next", hasNextModel);
                this.put(iteratorBlock.getIndexName() + "_index", new SimpleNumber(this.index));
                TemplateElement nestedBlock = iteratorBlock.getNestedBlock();
                if (nestedBlock != null) {
                    env.render(nestedBlock);
                }
                ++this.index;
            }
        } else if (this.list instanceof TemplateSequenceModel) {
            TemplateSequenceModel tsm = (TemplateSequenceModel)this.list;
            int size = tsm.size();
            this.index = 0;
            while (this.index < size) {
                this.clear();
                this.loopVar = tsm.get(this.index);
                this.put(iteratorBlock.getIndexName(), this.loopVar);
                this.hasNext = size > this.index + 1;
                TemplateBooleanModel hasNextModel = size > this.index + 1 ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                this.put(iteratorBlock.getIndexName() + "_has_next", hasNextModel);
                this.put(iteratorBlock.getIndexName() + "_index", new SimpleNumber(this.index));
                TemplateElement nestedBlock = iteratorBlock.getNestedBlock();
                if (nestedBlock != null) {
                    env.render(nestedBlock);
                }
                ++this.index;
            }
        } else {
            throw TemplateNode.invalidTypeException(this.list, iteratorBlock.getListExpression(), env, "collection or sequence");
        }
    }
}

