/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class FileTemplateLoader
implements TemplateLoader {
    private static final boolean SEP_IS_SLASH = File.separatorChar == '/';
    public final File baseDir;
    private String canonicalPath;

    public FileTemplateLoader() throws IOException {
        this(new File(System.getProperty("user.dir")));
    }

    public FileTemplateLoader(File baseDir) throws IOException {
        this(baseDir, false);
    }

    public FileTemplateLoader(File baseDir, boolean allowLinking) throws IOException {
        this(baseDir, allowLinking, true);
    }

    public FileTemplateLoader(File baseDir, boolean allowLinking, boolean useBaseDirCodeSource) throws IOException {
        if (!baseDir.exists()) {
            throw new FileNotFoundException(baseDir + " does not exist.");
        }
        if (!baseDir.isDirectory()) {
            throw new IOException(baseDir + " is not a directory.");
        }
        if (!allowLinking) {
            baseDir = baseDir.getCanonicalFile();
            this.canonicalPath = baseDir.getPath();
            if (!this.canonicalPath.endsWith(File.separator)) {
                this.canonicalPath = this.canonicalPath + File.separatorChar;
            }
        }
        this.baseDir = baseDir;
    }

    @Override
    public Object findTemplateSource(String name) throws IOException {
        String normalized;
        File source = new File(this.baseDir, SEP_IS_SLASH ? name : name.replace('/', File.separatorChar));
        if (!source.isFile()) {
            return null;
        }
        if (this.canonicalPath != null && !(normalized = source.getCanonicalPath()).startsWith(this.canonicalPath)) {
            throw new SecurityException(source.getAbsolutePath() + " resolves to " + normalized + " which  doesn't start with " + this.canonicalPath);
        }
        return source;
    }

    @Override
    public long getLastModified(Object templateSource) {
        return ((File)templateSource).lastModified();
    }

    @Override
    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding);
    }

    @Override
    public void closeTemplateSource(Object templateSource) {
    }
}

