/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.metadata;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.internal.ExceptionUtils;
import com.clickhouse.jdbc.internal.JdbcUtils;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class ResultSetMetaDataImpl
implements ResultSetMetaData,
JdbcV2Wrapper {
    private final List<ClickHouseColumn> columns;
    private final String schema;
    private final String catalog;
    private final String tableName;
    private final Map<ClickHouseDataType, Class<?>> typeClassMap;

    public ResultSetMetaDataImpl(List<ClickHouseColumn> columns, String schema, String catalog, String tableName, Map<ClickHouseDataType, Class<?>> typeClassMap) {
        this.columns = ImmutableList.copyOf(columns);
        this.schema = schema;
        this.catalog = catalog;
        this.tableName = tableName;
        this.typeClassMap = typeClassMap;
    }

    private void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.columns.size()) {
            throw new SQLException("Column index out of range: " + column, "HY000");
        }
    }

    private ClickHouseColumn getColumn(int column) throws SQLException {
        try {
            return this.columns.get(column - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("Column index out of range: " + column, "HY000");
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumn(column).getDataType().isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumn(column).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumn(column).getDataType().isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumnIndex(column);
        return 80;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getColumnName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getColumnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.schema;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.catalog;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return JdbcUtils.convertToSqlType(this.getColumn(column).getDataType()).getVendorTypeNumber();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn(column).getOriginalTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumnIndex(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        try {
            Class<Object> columnClassType = this.typeClassMap.get(this.getColumn(column).getDataType());
            if (columnClassType == null) {
                columnClassType = Object.class;
            }
            return columnClassType.getName();
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(e);
        }
    }
}

