/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QueryResponse;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.StatementImpl;
import com.clickhouse.jdbc.internal.ExceptionUtils;
import com.clickhouse.jdbc.internal.JdbcUtils;
import com.clickhouse.jdbc.metadata.ResultSetMetaDataImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetImpl
implements ResultSet,
JdbcV2Wrapper {
    private static final Logger log = LoggerFactory.getLogger(ResultSetImpl.class);
    private ResultSetMetaData metaData;
    protected ClickHouseBinaryFormatReader reader;
    private QueryResponse response;
    private boolean closed;
    private final StatementImpl parentStatement;
    private boolean wasNull;
    private final Calendar defaultCalendar;

    public ResultSetImpl(StatementImpl parentStatement, QueryResponse response, ClickHouseBinaryFormatReader reader) {
        this.parentStatement = parentStatement;
        this.response = response;
        this.reader = reader;
        TableSchema tableMetadata = reader.getSchema();
        this.metaData = new ResultSetMetaDataImpl(tableMetadata.getColumns(), response.getSettings().getDatabase(), "", tableMetadata.getTableName(), JdbcUtils.DATA_TYPE_CLASS_MAP);
        this.closed = false;
        this.wasNull = false;
        this.defaultCalendar = parentStatement.connection.defaultCalendar;
    }

    protected ResultSetImpl(ResultSetImpl resultSet) {
        this.parentStatement = resultSet.parentStatement;
        this.response = resultSet.response;
        this.reader = resultSet.reader;
        this.metaData = resultSet.metaData;
        this.closed = false;
        this.wasNull = false;
        this.defaultCalendar = this.parentStatement.connection.defaultCalendar;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed.", "08000");
        }
    }

    public TableSchema getSchema() {
        return this.reader.getSchema();
    }

    private String columnIndexToName(int index) throws SQLException {
        try {
            return this.getSchema().columnIndexToName(index);
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: columnIndexToName(%s) encountered an exception.", index), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        try {
            return this.reader.next() != null;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Exception e;
        block19: {
            this.closed = true;
            e = null;
            try {
                if (this.reader == null) break block19;
                try {
                    this.reader.close();
                }
                catch (Exception re) {
                    log.debug("Error closing reader", (Throwable)re);
                    e = re;
                }
                finally {
                    this.reader = null;
                }
            }
            finally {
                if (this.response != null) {
                    try {
                        this.response.close();
                    }
                    catch (Exception re) {
                        log.debug("Error closing response", (Throwable)re);
                        e = re;
                    }
                    finally {
                        this.response = null;
                    }
                }
            }
        }
        if (e != null) {
            throw ExceptionUtils.toSqlState(e);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getString(this.columnIndexToName(columnIndex));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getBoolean(this.columnIndexToName(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getByte(this.columnIndexToName(columnIndex));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getShort(this.columnIndexToName(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getInt(this.columnIndexToName(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong(this.columnIndexToName(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getFloat(this.columnIndexToName(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDouble(this.columnIndexToName(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(this.columnIndexToName(columnIndex), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getBytes(this.columnIndexToName(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getAsciiStream(this.columnIndexToName(columnIndex));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getUnicodeStream(this.columnIndexToName(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(this.columnIndexToName(columnIndex));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getString(columnLabel);
            }
            this.wasNull = true;
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getString(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getBoolean(columnLabel);
            }
            this.wasNull = true;
            return false;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getBoolean(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getByte(columnLabel);
            }
            this.wasNull = true;
            return 0;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getByte(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getShort(columnLabel);
            }
            this.wasNull = true;
            return 0;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getShort(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getInteger(columnLabel);
            }
            this.wasNull = true;
            return 0;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getInt(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getLong(columnLabel);
            }
            this.wasNull = true;
            return 0L;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getLong(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getFloat(columnLabel);
            }
            this.wasNull = true;
            return 0.0f;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getFloat(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getDouble(columnLabel);
            }
            this.wasNull = true;
            return 0.0;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getDouble(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getBigDecimal(columnLabel);
            }
            this.wasNull = true;
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getBigDecimal(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getByteArray(columnLabel);
            }
            this.wasNull = true;
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getBytes(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(columnLabel, null);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(columnLabel, null);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(columnLabel, null);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("AsciiStream is not yet supported.", "0A000");
        }
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkClosed();
        return new ByteArrayInputStream(this.reader.getString(columnLabel).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("BinaryStream is not yet supported.", "0A000");
        }
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return "";
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.metaData;
    }

    protected void setMetaData(ResultSetMetaDataImpl metaData) {
        this.metaData = metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, JdbcUtils.convertToJavaClass(this.getSchema().getColumnByIndex(columnIndex).getDataType()));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, JdbcUtils.convertToJavaClass(this.getSchema().getColumnByName(columnLabel).getDataType()));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            return this.reader.getSchema().nameToColumnIndex(columnLabel);
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: findColumn(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("CharacterStream is not yet supported.", "0A000");
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("CharacterStream is not yet supported.", "0A000");
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.columnIndexToName(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                return this.reader.getBigDecimal(columnLabel);
            }
            this.wasNull = true;
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getBigDecimal(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("isBeforeFirst is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("isAfterLast is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("isFirst is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("isLast is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("first is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("last is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("getRow is not supported.", "0A000");
        }
        return 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("absolute is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("relative is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("previous is not supported.", "0A000");
        }
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("setFetchDirection is not supported.", "0A000");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.updateNull(this.columnIndexToName(columnIndex));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateBoolean(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateByte(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateShort(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateInt(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateLong(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateFloat(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateDouble(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.updateString(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateBytes(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateDate(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateTime(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateTimestamp(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.columnIndexToName(columnIndex), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.columnIndexToName(columnIndex), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.columnIndexToName(columnIndex), x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.columnIndexToName(columnIndex), x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateObject(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkClosed();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.parentStatement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        ClickHouseDataType type = this.getSchema().getColumnByIndex(columnIndex).getDataType();
        return this.getObject(columnIndex, map.get(JdbcUtils.convertToSqlType(type).getName()));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.getRef(this.columnIndexToName(columnIndex));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getBlob(this.columnIndexToName(columnIndex));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.getClob(this.columnIndexToName(columnIndex));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, Array.class);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        return this.getObject(columnLabel, map.get(JdbcUtils.convertToSqlType(this.getSchema().getColumnByName(columnLabel).getDataType()).getName()));
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Ref is not supported.", "0A000");
        }
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Blob is not supported.", "0A000");
        }
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Clob is not supported.", "0A000");
        }
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getObject(columnLabel, Array.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(this.columnIndexToName(columnIndex), cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        try {
            ZonedDateTime zdt = this.reader.getZonedDateTime(columnLabel);
            if (zdt == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
            c.clear();
            c.set(zdt.getYear(), zdt.getMonthValue() - 1, zdt.getDayOfMonth(), 0, 0, 0);
            return new Date(c.getTimeInMillis());
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getDate(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(this.columnIndexToName(columnIndex), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        try {
            ZonedDateTime zdt = this.reader.getZonedDateTime(columnLabel);
            if (zdt == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
            c.clear();
            c.set(1970, 0, 1, zdt.getHour(), zdt.getMinute(), zdt.getSecond());
            return new Time(c.getTimeInMillis());
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getTime(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(this.columnIndexToName(columnIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        try {
            ZonedDateTime zdt = this.reader.getZonedDateTime(columnLabel);
            if (zdt == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
            c.set(zdt.getYear(), zdt.getMonthValue() - 1, zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), zdt.getSecond());
            Timestamp timestamp = new Timestamp(c.getTimeInMillis());
            timestamp.setNanos(zdt.getNano());
            return timestamp;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getTimestamp(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getURL(this.columnIndexToName(columnIndex));
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            return new URL(this.reader.getString(columnLabel));
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getURL(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.updateRef(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateBlob(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateClob(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateArray(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.getRowId(this.columnIndexToName(columnIndex));
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.updateRowId(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateNString(this.columnIndexToName(columnIndex), nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateNClob(this.columnIndexToName(columnIndex), nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.getNClob(this.columnIndexToName(columnIndex));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("NClob is not supported.", "0A000");
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.getSQLXML(this.columnIndexToName(columnIndex));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("SQLXML is not supported.", "0A000");
        }
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.columnIndexToName(columnIndex), xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getNString(this.columnIndexToName(columnIndex));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            return this.reader.getString(columnLabel);
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getNString(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getNCharacterStream(this.columnIndexToName(columnIndex));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            return new StringReader(this.reader.getString(columnLabel));
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getNCharacterStream(\"%s\") encountered an exception.", columnLabel), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.columnIndexToName(columnIndex), x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.columnIndexToName(columnIndex), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.columnIndexToName(columnIndex), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateCharacterStream(this.columnIndexToName(columnIndex), x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.columnIndexToName(columnIndex), inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(this.columnIndexToName(columnIndex), reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateNClob(this.columnIndexToName(columnIndex), reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateNCharacterStream(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateAsciiStream(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateCharacterStream(this.columnIndexToName(columnIndex), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBlob(this.columnIndexToName(columnIndex), inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(this.columnIndexToName(columnIndex), reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateNClob(this.columnIndexToName(columnIndex), reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.checkClosed();
        if (!this.parentStatement.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Writes are not supported.", "0A000");
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnIndex)) {
                this.wasNull = false;
                if (type == null) {
                    return (T)this.reader.readValue(columnIndex);
                }
                return (T)JdbcUtils.convert(this.reader.readValue(columnIndex), type, type == Array.class ? this.getSchema().getColumnByIndex(columnIndex) : null);
            }
            this.wasNull = true;
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getObject(\"%s\", %s) encountered an exception.", this.reader.getSchema().columnIndexToName(columnIndex), type), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkClosed();
        try {
            if (this.reader.hasValue(columnLabel)) {
                this.wasNull = false;
                if (type == null) {
                    return (T)this.reader.readValue(columnLabel);
                }
                return (T)JdbcUtils.convert(this.reader.readValue(columnLabel), type, type == Array.class ? this.getSchema().getColumnByName(columnLabel) : null);
            }
            this.wasNull = true;
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(String.format("Method: getObject(\"%s\", %s) encountered an exception.", columnLabel, type), String.format("SQL: [%s]", this.parentStatement.getLastStatementSql()), e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(this.columnIndexToName(columnIndex), x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        ResultSet.super.updateObject(columnLabel, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.updateObject(this.columnIndexToName(columnIndex), x, targetSqlType);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        this.checkClosed();
        ResultSet.super.updateObject(columnLabel, x, targetSqlType);
    }
}

