/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.jdbc.ConnectionImpl;
import com.clickhouse.jdbc.DataSourceImpl;
import com.clickhouse.jdbc.internal.JdbcConfiguration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements java.sql.Driver {
    private static final Logger log;
    public static final String driverVersion;
    public static final int majorVersion;
    public static final int minorVersion;
    private final DataSourceImpl dataSource;
    public static String frameworksDetected;
    public static final String DRIVER_CLIENT_NAME = "jdbc-v2/";
    private static final Driver INSTANCE;

    public Driver() {
        this.dataSource = null;
    }

    public Driver(DataSourceImpl dataSourceImpl) {
        this.dataSource = dataSourceImpl;
    }

    public static void load() {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            log.error("Failed to register ClickHouse JDBC driver", (Throwable)e);
        }
    }

    public static void unload() {
        try {
            DriverManager.deregisterDriver(INSTANCE);
        }
        catch (SQLException e) {
            log.error("Failed to deregister ClickHouse JDBC driver", (Throwable)e);
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        return new ConnectionImpl(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return JdbcConfiguration.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new JdbcConfiguration(url, info).getDriverPropertyInfo().toArray(new DriverPropertyInfo[0]);
    }

    public static int getDriverMajorVersion() {
        return majorVersion;
    }

    @Override
    public int getMajorVersion() {
        return majorVersion;
    }

    public static int getDriverMinorVersion() {
        return minorVersion;
    }

    @Override
    public int getMinorVersion() {
        return minorVersion;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static String chSettingKey(String key) {
        return ClientConfigProperties.serverSetting(key);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported", "0A000");
    }

    static {
        int tmpMinorVersion;
        int tmpMajorVersion;
        log = LoggerFactory.getLogger(Driver.class);
        frameworksDetected = null;
        log.debug("Initializing ClickHouse JDBC driver V2");
        driverVersion = ClickHouseClientOption.readVersionFromResource((String)"jdbc-v2-version.properties");
        log.info("ClickHouse JDBC driver version: {}", (Object)driverVersion);
        try {
            Matcher m = Pattern.compile("(\\d+)(\\.\\d+)(\\.\\d+)").matcher(driverVersion);
            if (m.find()) {
                tmpMajorVersion = Integer.parseInt(m.group(1));
                tmpMinorVersion = Integer.parseInt(m.group(2).substring(1));
            } else {
                tmpMajorVersion = 0;
                tmpMinorVersion = 0;
            }
        }
        catch (Exception e) {
            tmpMajorVersion = 0;
            tmpMinorVersion = 0;
        }
        majorVersion = tmpMajorVersion;
        minorVersion = tmpMinorVersion;
        INSTANCE = new Driver();
    }

    public static class FrameworksDetection {
        private static final List<String> FRAMEWORKS_TO_DETECT = Arrays.asList("apache.spark", "apache.flink", "apache.nifi");
        static volatile String frameworksDetected = null;

        private FrameworksDetection() {
        }

        public static String getFrameworksDetected() {
            if (frameworksDetected == null) {
                LinkedHashSet<String> inferredFrameworks = new LinkedHashSet<String>();
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    for (String framework : FRAMEWORKS_TO_DETECT) {
                        if (!ste.toString().contains(framework)) continue;
                        inferredFrameworks.add(String.format("(%s)", framework));
                    }
                }
                frameworksDetected = String.join((CharSequence)"; ", inferredFrameworks);
            }
            return frameworksDetected;
        }
    }
}

