/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.data.ClickHouseByteUtils;
import com.clickhouse.data.ClickHouseCityHash;
import com.clickhouse.data.ClickHouseUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseLZ4InputStream
extends InputStream {
    private static Logger LOG = LoggerFactory.getLogger(ClickHouseLZ4InputStream.class);
    private final LZ4FastDecompressor decompressor;
    private final InputStream in;
    private ByteBuffer buffer;
    private byte[] tmpBuffer = new byte[1];
    static final byte MAGIC = -126;
    static final int HEADER_LENGTH = 25;
    final byte[] headerBuff = new byte[25];

    public ClickHouseLZ4InputStream(InputStream in, LZ4FastDecompressor decompressor, int bufferSize) {
        LOG.debug("Using decompressor {}", (Object)decompressor);
        this.decompressor = decompressor;
        this.in = in;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.tmpBuffer, 0, 1);
        return n == -1 ? -1 : this.tmpBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int remaining;
        if (b == null) {
            throw new NullPointerException("b is null");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("off + len is greater than b.length");
        }
        if (len == 0) {
            return 0;
        }
        int readBytes = 0;
        do {
            remaining = Math.min(len - readBytes, this.buffer.remaining());
            this.buffer.get(b, off + readBytes, remaining);
        } while ((readBytes += remaining) < len && this.refill() != -1);
        return readBytes == 0 ? -1 : readBytes;
    }

    private boolean readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            if (n == 0) {
                return false;
            }
            throw new IOException(ClickHouseUtils.format("Incomplete read: {0} of {1}", n, len));
        }
        return true;
    }

    private int refill() throws IOException {
        boolean readFully = this.readFully(this.headerBuff, 0, 25);
        if (!readFully) {
            return -1;
        }
        if (this.headerBuff[16] != -126) {
            throw new ClientException("Invalid LZ4 magic byte: '" + this.headerBuff[16] + "'");
        }
        int compressedSizeWithHeader = ClickHouseLZ4InputStream.getInt32(this.headerBuff, 17);
        int uncompressedSize = ClickHouseLZ4InputStream.getInt32(this.headerBuff, 21);
        int offset = 9;
        byte[] block = new byte[compressedSizeWithHeader];
        block[0] = -126;
        ClickHouseLZ4InputStream.setInt32(block, 1, compressedSizeWithHeader);
        ClickHouseLZ4InputStream.setInt32(block, 5, uncompressedSize);
        int remaining = compressedSizeWithHeader - offset;
        readFully = this.readFully(block, offset, remaining);
        if (!readFully) {
            throw new EOFException("Unexpected end of stream");
        }
        long[] real = ClickHouseCityHash.cityHash128(block, 0, compressedSizeWithHeader);
        if (real[0] != ClickHouseLZ4InputStream.getInt64(this.headerBuff, 0) || real[1] != ClickHouseByteUtils.getInt64(this.headerBuff, 8)) {
            throw new ClientException("Corrupted stream: checksum mismatch");
        }
        if (this.buffer.capacity() < uncompressedSize) {
            this.buffer = ByteBuffer.allocate(uncompressedSize);
            LOG.warn("Buffer size is too small, reallocate buffer with size: " + uncompressedSize);
        }
        this.decompressor.decompress(ByteBuffer.wrap(block), offset, this.buffer, 0, uncompressedSize);
        this.buffer.position(0);
        this.buffer.limit(uncompressedSize);
        return uncompressedSize;
    }

    static int getInt32(byte[] bytes, int offset) {
        return 0xFF & bytes[offset] | (0xFF & bytes[offset + 1]) << 8 | (0xFF & bytes[offset + 2]) << 16 | (0xFF & bytes[offset + 3]) << 24;
    }

    static long getInt64(byte[] bytes, int offset) {
        return 0xFFL & (long)bytes[offset] | (0xFFL & (long)bytes[offset + 1]) << 8 | (0xFFL & (long)bytes[offset + 2]) << 16 | (0xFFL & (long)bytes[offset + 3]) << 24 | (0xFFL & (long)bytes[offset + 4]) << 32 | (0xFFL & (long)bytes[offset + 5]) << 40 | (0xFFL & (long)bytes[offset + 6]) << 48 | (0xFFL & (long)bytes[offset + 7]) << 56;
    }

    static void setInt32(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)(0xFF & value);
        bytes[offset + 1] = (byte)(0xFF & value >> 8);
        bytes[offset + 2] = (byte)(0xFF & value >> 16);
        bytes[offset + 3] = (byte)(0xFF & value >> 24);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

