/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatReader;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.metrics.ServerMetrics;
import com.clickhouse.client.api.query.QueryResponse;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.jdbc.ConnectionImpl;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.ResultSetImpl;
import com.clickhouse.jdbc.internal.ExceptionUtils;
import com.clickhouse.jdbc.internal.JdbcUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementImpl
implements Statement,
JdbcV2Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(StatementImpl.class);
    ConnectionImpl connection;
    private int queryTimeout;
    protected boolean closed;
    private ResultSetImpl currentResultSet;
    private OperationMetrics metrics;
    private List<String> batch;
    private String lastSql;
    private volatile String lastQueryId;
    private String schema;
    private int maxRows;

    public StatementImpl(ConnectionImpl connection) throws SQLException {
        this.connection = connection;
        this.queryTimeout = 0;
        this.closed = false;
        this.currentResultSet = null;
        this.metrics = null;
        this.batch = new ArrayList<String>();
        this.schema = connection.getSchema();
        LOG.info("Statement schema " + this.schema);
        this.maxRows = 0;
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Statement is closed", "08000");
        }
    }

    protected static StatementType parseStatementType(String sql) {
        String[] lines;
        if (sql == null) {
            return StatementType.OTHER;
        }
        String trimmedSql = sql.trim();
        if (trimmedSql.isEmpty()) {
            return StatementType.OTHER;
        }
        trimmedSql = trimmedSql.replaceAll("/\\*.*?\\*/", "").trim();
        for (String line : lines = trimmedSql.split("\n")) {
            String[] tokens;
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("--") || trimmedLine.startsWith("#!") || trimmedLine.startsWith("#") || (tokens = trimmedLine.split("\\s+")).length == 0) continue;
            switch (tokens[0].toUpperCase()) {
                case "SELECT": {
                    return StatementType.SELECT;
                }
                case "INSERT": {
                    return StatementType.INSERT;
                }
                case "DELETE": {
                    return StatementType.DELETE;
                }
                case "UPDATE": {
                    return StatementType.UPDATE;
                }
                case "CREATE": {
                    return StatementType.CREATE;
                }
                case "DROP": {
                    return StatementType.DROP;
                }
                case "ALTER": {
                    return StatementType.ALTER;
                }
                case "TRUNCATE": {
                    return StatementType.TRUNCATE;
                }
                case "USE": {
                    return StatementType.USE;
                }
                case "SHOW": {
                    return StatementType.SHOW;
                }
                case "DESCRIBE": {
                    return StatementType.DESCRIBE;
                }
                case "EXPLAIN": {
                    return StatementType.EXPLAIN;
                }
                case "SET": {
                    return StatementType.SET;
                }
                case "KILL": {
                    return StatementType.KILL;
                }
            }
            return StatementType.OTHER;
        }
        return StatementType.OTHER;
    }

    protected static String parseTableName(String sql) {
        String[] tokens = sql.trim().split("\\s+");
        if (tokens.length < 3) {
            return null;
        }
        return tokens[2];
    }

    protected static String parseJdbcEscapeSyntax(String sql) {
        LOG.trace("Original SQL: {}", (Object)sql);
        sql = sql.replaceAll("\\{d '([^']*)'\\}", "toDate('$1')");
        sql = sql.replaceAll("\\{ts '([^']*)'\\}", "timestamp('$1')");
        sql = sql.replaceAll("\\{fn ([^\\}]*)\\}", "$1");
        LOG.trace("Parsed SQL: {}", (Object)sql);
        return sql;
    }

    protected String getLastSql() {
        return this.lastSql;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        return this.executeQuery(sql, new QuerySettings().setDatabase(this.schema));
    }

    private void closePreviousResultSet() {
        if (this.currentResultSet != null) {
            LOG.debug("Previous result set is open [resultSet = " + this.currentResultSet + "]");
            try {
                this.currentResultSet.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close previous result set", (Throwable)e);
            }
            finally {
                this.currentResultSet = null;
            }
        }
    }

    public ResultSetImpl executeQuery(String sql, QuerySettings settings) throws SQLException {
        this.checkClosed();
        this.closePreviousResultSet();
        QuerySettings mergedSettings = QuerySettings.merge(this.connection.getDefaultQuerySettings(), settings);
        if (mergedSettings.getQueryId() != null) {
            this.lastQueryId = mergedSettings.getQueryId();
        } else {
            this.lastQueryId = UUID.randomUUID().toString();
            mergedSettings.setQueryId(this.lastQueryId);
        }
        LOG.debug("Query ID: {}", (Object)this.lastQueryId);
        try {
            this.lastSql = StatementImpl.parseJdbcEscapeSyntax(sql);
            QueryResponse response = this.queryTimeout == 0 ? this.connection.client.query(this.lastSql, mergedSettings).get() : this.connection.client.query(this.lastSql, mergedSettings).get(this.queryTimeout, TimeUnit.SECONDS);
            ClickHouseBinaryFormatReader reader = this.connection.client.newBinaryFormatReader(response);
            this.currentResultSet = new ResultSetImpl(this, response, reader);
            this.metrics = response.getMetrics();
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(e);
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        return this.executeUpdate(sql, new QuerySettings().setDatabase(this.schema));
    }

    public int executeUpdate(String sql, QuerySettings settings) throws SQLException {
        this.checkClosed();
        StatementType type = StatementImpl.parseStatementType(sql);
        if (type == StatementType.SELECT || type == StatementType.SHOW || type == StatementType.DESCRIBE || type == StatementType.EXPLAIN) {
            throw new SQLException("executeUpdate() cannot be called with a SELECT/SHOW/DESCRIBE/EXPLAIN statement", "07000");
        }
        this.closePreviousResultSet();
        QuerySettings mergedSettings = QuerySettings.merge(this.connection.getDefaultQuerySettings(), settings);
        if (mergedSettings.getQueryId() != null) {
            this.lastQueryId = mergedSettings.getQueryId();
        } else {
            this.lastQueryId = UUID.randomUUID().toString();
            mergedSettings.setQueryId(this.lastQueryId);
        }
        this.lastSql = StatementImpl.parseJdbcEscapeSyntax(sql);
        int updateCount = 0;
        try (QueryResponse response = this.queryTimeout == 0 ? this.connection.client.query(this.lastSql, mergedSettings).get() : this.connection.client.query(this.lastSql, mergedSettings).get(this.queryTimeout, TimeUnit.SECONDS);){
            this.currentResultSet = null;
            updateCount = (int)response.getWrittenRows();
            this.metrics = response.getMetrics();
            this.lastQueryId = response.getQueryId();
        }
        catch (Exception e) {
            throw ExceptionUtils.toSqlState(e);
        }
        return updateCount;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        if (this.currentResultSet != null) {
            try {
                this.currentResultSet.close();
            }
            catch (Exception e) {
                LOG.debug("Failed to close current result set", (Throwable)e);
            }
            finally {
                this.currentResultSet = null;
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (!this.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Set max field size is not supported.", "0A000");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.closed) {
            return;
        }
        try (QueryResponse response = this.connection.client.query(String.format("KILL QUERY%sWHERE query_id = '%s'", this.connection.onCluster ? " ON CLUSTER " + this.connection.cluster + " " : " ", this.lastQueryId), this.connection.getDefaultQuerySettings()).get();){
            LOG.debug("Query {} was killed by {}", (Object)this.lastQueryId, (Object)response.getQueryId());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        return this.execute(sql, new QuerySettings().setDatabase(this.schema));
    }

    public boolean execute(String sql, QuerySettings settings) throws SQLException {
        this.checkClosed();
        StatementType type = StatementImpl.parseStatementType(sql);
        if (type == StatementType.SELECT || type == StatementType.SHOW || type == StatementType.DESCRIBE || type == StatementType.EXPLAIN) {
            this.executeQuery(sql, settings);
            return true;
        }
        if (type == StatementType.SET) {
            this.executeUpdate(sql, settings);
            List<String> tokens = JdbcUtils.tokenizeSQL(sql);
            if (JdbcUtils.containsIgnoresCase(tokens, "ROLE")) {
                ArrayList<String> roles = new ArrayList<String>();
                int roleIndex = JdbcUtils.indexOfIgnoresCase(tokens, "ROLE");
                if (roleIndex == 1) {
                    for (int i = 2; i < tokens.size(); ++i) {
                        String[] roleTokens;
                        String token = tokens.get(i);
                        for (String roleToken : roleTokens = token.split(",")) {
                            roles.add(roleToken.replace("\"", ""));
                        }
                    }
                    if (JdbcUtils.containsIgnoresCase(roles, "NONE")) {
                        this.connection.client.setDBRoles(Collections.emptyList());
                    } else {
                        this.connection.client.setDBRoles(roles);
                    }
                }
            }
            return false;
        }
        this.executeUpdate(sql, settings);
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        ResultSetImpl resultSet = this.currentResultSet;
        this.currentResultSet = null;
        return resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.currentResultSet == null && this.metrics != null) {
            int updateCount = (int)this.metrics.getMetric(ServerMetrics.NUM_ROWS_WRITTEN).getLong();
            this.metrics = null;
            return updateCount;
        }
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (!this.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Set fetch direction is not supported.", "0A000");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.batch.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String sql : this.batch) {
            results.add(this.executeUpdate(sql));
        }
        return results.stream().mapToInt(i -> i).toArray();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        return Statement.super.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkClosed();
        Statement.super.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkClosed();
        return Statement.super.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        return Statement.super.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkClosed();
        return Statement.super.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return Statement.super.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return Statement.super.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return Statement.super.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        this.checkClosed();
        return Statement.super.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        this.checkClosed();
        return Statement.super.enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        this.checkClosed();
        return Statement.super.isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        this.checkClosed();
        return Statement.super.enquoteNCharLiteral(val);
    }

    protected static enum StatementType {
        SELECT,
        INSERT,
        DELETE,
        UPDATE,
        CREATE,
        DROP,
        ALTER,
        TRUNCATE,
        USE,
        SHOW,
        DESCRIBE,
        EXPLAIN,
        SET,
        KILL,
        OTHER;

    }
}

