/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import io.grpc.ExperimentalApi;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.okhttp.Utils;
import io.grpc.okhttp.internal.ConnectionSpec;
import javax.net.ssl.SSLSocketFactory;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class SslSocketFactoryServerCredentials {
    private SslSocketFactoryServerCredentials() {
    }

    public static io.grpc.ServerCredentials create(SSLSocketFactory factory) {
        return new ServerCredentials(factory);
    }

    public static io.grpc.ServerCredentials create(SSLSocketFactory factory, com.squareup.okhttp.ConnectionSpec connectionSpec) {
        return new ServerCredentials(factory, Utils.convertSpec(connectionSpec));
    }

    static final class ServerCredentials
    extends io.grpc.ServerCredentials {
        private final SSLSocketFactory factory;
        private final ConnectionSpec connectionSpec;

        ServerCredentials(SSLSocketFactory factory) {
            this(factory, OkHttpChannelBuilder.INTERNAL_DEFAULT_CONNECTION_SPEC);
        }

        ServerCredentials(SSLSocketFactory factory, ConnectionSpec connectionSpec) {
            this.factory = Preconditions.checkNotNull(factory, "factory");
            this.connectionSpec = Preconditions.checkNotNull(connectionSpec, "connectionSpec");
        }

        public SSLSocketFactory getFactory() {
            return this.factory;
        }

        public ConnectionSpec getConnectionSpec() {
            return this.connectionSpec;
        }
    }
}

