/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.Header;
import io.grpc.okhttp.internal.framed.Settings;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;
import okio.ByteString;

class OkHttpFrameLogger {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final Logger logger;
    private final Level level;

    OkHttpFrameLogger(Level level, Class<?> clazz) {
        this(level, Logger.getLogger(clazz.getName()));
    }

    @VisibleForTesting
    OkHttpFrameLogger(Level level, Logger logger) {
        this.level = Preconditions.checkNotNull(level, "level");
        this.logger = Preconditions.checkNotNull(logger, "logger");
    }

    private static String toString(Settings settings) {
        EnumMap<SettingParams, Integer> map = new EnumMap<SettingParams, Integer>(SettingParams.class);
        for (SettingParams p : SettingParams.values()) {
            if (!settings.isSet(p.getBit())) continue;
            map.put(p, settings.get(p.getBit()));
        }
        return map.toString();
    }

    private static String toString(Buffer buf) {
        if (buf.size() <= 64L) {
            return buf.snapshot().hex();
        }
        int length = (int)Math.min(buf.size(), 64L);
        return buf.snapshot(length).hex() + "...";
    }

    private boolean isEnabled() {
        return this.logger.isLoggable(this.level);
    }

    void logData(Direction direction, int streamId, Buffer data, int length, boolean endStream) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " DATA: streamId=" + streamId + " endStream=" + endStream + " length=" + length + " bytes=" + OkHttpFrameLogger.toString(data));
        }
    }

    void logHeaders(Direction direction, int streamId, List<Header> headers, boolean endStream) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " HEADERS: streamId=" + streamId + " headers=" + headers + " endStream=" + endStream);
        }
    }

    public void logPriority(Direction direction, int streamId, int streamDependency, int weight, boolean exclusive) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " PRIORITY: streamId=" + streamId + " streamDependency=" + streamDependency + " weight=" + weight + " exclusive=" + exclusive);
        }
    }

    void logRstStream(Direction direction, int streamId, ErrorCode errorCode) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " RST_STREAM: streamId=" + streamId + " errorCode=" + (Object)((Object)errorCode));
        }
    }

    void logSettingsAck(Direction direction) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " SETTINGS: ack=true");
        }
    }

    void logSettings(Direction direction, Settings settings) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " SETTINGS: ack=false settings=" + OkHttpFrameLogger.toString(settings));
        }
    }

    void logPing(Direction direction, long data) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " PING: ack=false bytes=" + data);
        }
    }

    void logPingAck(Direction direction, long data) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " PING: ack=true bytes=" + data);
        }
    }

    void logPushPromise(Direction direction, int streamId, int promisedStreamId, List<Header> headers) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " PUSH_PROMISE: streamId=" + streamId + " promisedStreamId=" + promisedStreamId + " headers=" + headers);
        }
    }

    void logGoAway(Direction direction, int lastStreamId, ErrorCode errorCode, ByteString debugData) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " GO_AWAY: lastStreamId=" + lastStreamId + " errorCode=" + (Object)((Object)errorCode) + " length=" + debugData.size() + " bytes=" + OkHttpFrameLogger.toString(new Buffer().write(debugData)));
        }
    }

    void logWindowsUpdate(Direction direction, int streamId, long windowSizeIncrement) {
        if (this.isEnabled()) {
            this.logger.log(this.level, (Object)((Object)direction) + " WINDOW_UPDATE: streamId=" + streamId + " windowSizeIncrement=" + windowSizeIncrement);
        }
    }

    private static enum SettingParams {
        HEADER_TABLE_SIZE(1),
        ENABLE_PUSH(2),
        MAX_CONCURRENT_STREAMS(4),
        MAX_FRAME_SIZE(5),
        MAX_HEADER_LIST_SIZE(6),
        INITIAL_WINDOW_SIZE(7);

        private final int bit;

        private SettingParams(int bit) {
            this.bit = bit;
        }

        public int getBit() {
            return this.bit;
        }
    }

    static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

