/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;

public class CompressedEntity
implements HttpEntity {
    private HttpEntity httpEntity;
    private final boolean isResponse;
    private final CompressorStreamFactory compressorStreamFactory;
    private final String compressionAlgo;

    CompressedEntity(HttpEntity httpEntity, boolean isResponse, CompressorStreamFactory compressorStreamFactory) {
        this.httpEntity = httpEntity;
        this.isResponse = isResponse;
        this.compressorStreamFactory = compressorStreamFactory;
        this.compressionAlgo = this.getCompressionAlgoName(httpEntity.getContentEncoding());
    }

    public boolean isRepeatable() {
        return this.httpEntity.isRepeatable();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        if (!this.isResponse) {
            throw new UnsupportedOperationException("Unsupported: getting compressed content of request");
        }
        try {
            return this.compressorStreamFactory.createCompressorInputStream(this.compressionAlgo, this.httpEntity.getContent());
        }
        catch (CompressorException e) {
            throw new IOException("Failed to create decompressing input stream", e);
        }
    }

    public void writeTo(OutputStream outStream) throws IOException {
        if (this.isResponse) {
            throw new UnsupportedOperationException("Unsupported: writing compressed response to elsewhere");
        }
        try {
            this.httpEntity.writeTo((OutputStream)this.compressorStreamFactory.createCompressorOutputStream(this.compressionAlgo, outStream));
        }
        catch (CompressorException e) {
            throw new IOException("Failed to create compressing output stream", e);
        }
    }

    public boolean isStreaming() {
        return this.httpEntity.isStreaming();
    }

    public Supplier<List<? extends Header>> getTrailers() {
        return this.httpEntity.getTrailers();
    }

    public void close() throws IOException {
        this.httpEntity.close();
    }

    public long getContentLength() {
        return this.httpEntity.getContentLength();
    }

    public String getContentType() {
        return this.httpEntity.getContentType();
    }

    public String getContentEncoding() {
        return this.httpEntity.getContentEncoding();
    }

    public boolean isChunked() {
        return this.httpEntity.isChunked();
    }

    public Set<String> getTrailerNames() {
        return this.httpEntity.getTrailerNames();
    }

    private String getCompressionAlgoName(String contentEncoding) {
        String algo = contentEncoding;
        if (algo.equalsIgnoreCase("gzip")) {
            algo = "gz";
        } else if (algo.equalsIgnoreCase("lz4")) {
            algo = "lz4-framed";
        }
        return algo;
    }
}

