/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.insert;

import com.clickhouse.client.api.ClientSettings;
import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class InsertSettings {
    private static final int DEFAULT_INPUT_STREAM_BATCH_SIZE = 8196;
    private int inputStreamCopyBufferSize;
    private String operationId;
    Map<String, Object> rawSettings = new HashMap<String, Object>();
    private String logComment = null;

    public InsertSettings() {
        this.setDefaults();
    }

    public InsertSettings(Map<String, Object> settings) {
        this.setDefaults();
        this.rawSettings.putAll(settings);
    }

    private void setDefaults() {
        this.setInputStreamCopyBufferSize(8196);
    }

    public Object getOption(String option) {
        return this.rawSettings.get(option);
    }

    public void setOption(String option, Object value) {
        this.rawSettings.put(option, value);
    }

    public Map<String, Object> getAllSettings() {
        return this.rawSettings;
    }

    public InsertSettings setDeduplicationToken(String token) {
        this.serverSetting("insert_deduplication_token", token);
        return this;
    }

    public String getQueryId() {
        return (String)this.rawSettings.get(ClickHouseClientOption.QUERY_ID.getKey());
    }

    public InsertSettings setQueryId(String queryId) {
        this.rawSettings.put(ClickHouseClientOption.QUERY_ID.getKey(), queryId);
        return this;
    }

    public int getInputStreamCopyBufferSize() {
        return this.inputStreamCopyBufferSize;
    }

    public InsertSettings setInputStreamCopyBufferSize(int size) {
        this.inputStreamCopyBufferSize = size;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public InsertSettings setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public InsertSettings setDatabase(String database) {
        ValidationUtils.checkNonBlank(database, "database");
        this.rawSettings.put("database", database);
        return this;
    }

    public String getDatabase() {
        return (String)this.rawSettings.get("database");
    }

    public InsertSettings compressClientRequest(boolean enabled) {
        this.rawSettings.put("decompress", enabled);
        return this;
    }

    public boolean isClientRequestEnabled() {
        return (Boolean)this.rawSettings.get("decompress");
    }

    public InsertSettings httpHeader(String key, String value) {
        this.rawSettings.put("http_header_" + key, value);
        return this;
    }

    public InsertSettings httpHeader(String key, Collection<String> values) {
        this.rawSettings.put("http_header_" + key, ClientSettings.commaSeparated(values));
        return this;
    }

    public InsertSettings httpHeaders(Map<String, String> headers) {
        headers.forEach(this::httpHeader);
        return this;
    }

    public InsertSettings serverSetting(String name, String value) {
        this.rawSettings.put("clickhouse_setting_" + name, value);
        return this;
    }

    public InsertSettings serverSetting(String name, Collection<String> values) {
        this.rawSettings.put("clickhouse_setting_" + name, ClientSettings.commaSeparated(values));
        return this;
    }

    public InsertSettings setDBRoles(Collection<String> dbRoles) {
        this.rawSettings.put("session_db_roles", dbRoles);
        return this;
    }

    public Collection<String> getDBRoles() {
        return (Collection)this.rawSettings.get("session_db_roles");
    }

    public InsertSettings logComment(String logComment) {
        this.logComment = logComment;
        if (logComment != null && !logComment.isEmpty()) {
            this.rawSettings.put("clickhouse_setting_log_comment", logComment);
        }
        return this;
    }

    public String getLogComment() {
        return this.logComment;
    }
}

