/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metrics;

import com.clickhouse.client.api.internal.ClientStatisticsHolder;
import com.clickhouse.client.api.internal.Gauge;
import com.clickhouse.client.api.internal.StopWatch;
import com.clickhouse.client.api.metrics.ClientMetrics;
import com.clickhouse.client.api.metrics.Metric;
import com.clickhouse.client.api.metrics.ServerMetrics;
import java.util.HashMap;
import java.util.Map;

public class OperationMetrics {
    public Map<String, Metric> metrics = new HashMap<String, Metric>();
    private String queryId;
    private final ClientStatisticsHolder clientStatistics;

    public OperationMetrics(ClientStatisticsHolder clientStatisticsHolder) {
        this.clientStatistics = clientStatisticsHolder;
    }

    public Metric getMetric(ServerMetrics metric) {
        return this.metrics.get(metric.getKey());
    }

    public Metric getMetric(ClientMetrics metric) {
        return this.metrics.get(metric.getKey());
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void operationComplete() {
        for (Map.Entry<String, StopWatch> sw : this.clientStatistics.getStopWatches().entrySet()) {
            sw.getValue().stop();
            this.metrics.put(sw.getKey(), sw.getValue());
        }
    }

    public void updateMetric(ServerMetrics metric, long value) {
        this.metrics.put(metric.getKey(), new Gauge(value));
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String toString() {
        return "OperationStatistics{\"queryId\"=\"" + this.queryId + "\", \"metrics\"=" + this.metrics + '}';
    }
}

