/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.metrics;

import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.api.internal.ClientStatisticsHolder;
import com.clickhouse.client.api.internal.Gauge;
import com.clickhouse.client.api.internal.StopWatch;
import com.clickhouse.client.api.metrics.ClientMetrics;
import com.clickhouse.client.api.metrics.Metric;
import com.clickhouse.client.api.metrics.ServerMetrics;
import java.util.HashMap;
import java.util.Map;

public class OperationMetrics {
    public Map<String, Metric> metrics = new HashMap<String, Metric>();
    private String queryId;
    private final ClientStatisticsHolder clientStatistics;

    public OperationMetrics(ClientStatisticsHolder clientStatisticsHolder) {
        this.clientStatistics = clientStatisticsHolder;
    }

    public Metric getMetric(ServerMetrics metric) {
        return this.metrics.get(metric.getKey());
    }

    public Metric getMetric(ClientMetrics metric) {
        return this.metrics.get(metric.getKey());
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void operationComplete(ClickHouseResponseSummary serverStats) {
        for (Map.Entry<String, StopWatch> sw : this.clientStatistics.getStopWatches().entrySet()) {
            sw.getValue().stop();
            this.metrics.put(sw.getKey(), sw.getValue());
        }
        this.metrics.put(ServerMetrics.NUM_ROWS_READ.getKey(), new Gauge(serverStats.getReadRows()));
        this.metrics.put(ServerMetrics.NUM_ROWS_WRITTEN.getKey(), new Gauge(serverStats.getWrittenRows()));
        this.metrics.put(ServerMetrics.TOTAL_ROWS_TO_READ.getKey(), new Gauge(serverStats.getTotalRowsToRead()));
        this.metrics.put(ServerMetrics.NUM_BYTES_READ.getKey(), new Gauge(serverStats.getReadBytes()));
        this.metrics.put(ServerMetrics.NUM_BYTES_WRITTEN.getKey(), new Gauge(serverStats.getWrittenBytes()));
        this.metrics.put(ServerMetrics.RESULT_ROWS.getKey(), new Gauge(serverStats.getResultRows()));
        this.metrics.put(ServerMetrics.ELAPSED_TIME.getKey(), new Gauge(serverStats.getElapsedTime()));
        this.queryId = serverStats.getQueryId();
    }

    public String toString() {
        return "OperationStatistics{\"queryId\"=\"" + this.queryId + "\", \"metrics\"=" + this.metrics + '}';
    }
}

