/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.insert;

import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseFormat;
import java.util.HashMap;
import java.util.Map;

public class InsertSettings {
    Map<String, Object> rawSettings = new HashMap<String, Object>();

    public InsertSettings() {
        this.setDefaults();
    }

    public InsertSettings(Map<String, Object> settings) {
        this.setDefaults();
        this.rawSettings.putAll(settings);
    }

    private void setDefaults() {
        this.setInputStreamBatchSize(8196);
    }

    public Object getSetting(String option) {
        return this.rawSettings.get(option);
    }

    public void setSetting(String option, Object value) {
        this.rawSettings.put(option, value);
    }

    public ClickHouseFormat getFormat() {
        return (ClickHouseFormat)this.rawSettings.get(ClickHouseClientOption.FORMAT.getKey());
    }

    public InsertSettings setFormat(ClickHouseFormat format) {
        this.rawSettings.put(ClickHouseClientOption.FORMAT.getKey(), format);
        return this;
    }

    public String getDeduplicationToken() {
        return (String)this.rawSettings.get("insert_deduplication_token");
    }

    public InsertSettings setDeduplicationToken(String deduplicationToken) {
        this.rawSettings.put("insert_deduplication_token", deduplicationToken);
        return this;
    }

    public String getQueryId() {
        return (String)this.rawSettings.get("query_id");
    }

    public InsertSettings setQueryId(String queryId) {
        this.rawSettings.put("query_id", queryId);
        return this;
    }

    public int getInputStreamBatchSize() {
        return (Integer)this.rawSettings.get("input_stream_batch_size");
    }

    public InsertSettings setInputStreamBatchSize(int inputStreamBatchSize) {
        this.rawSettings.put("input_stream_batch_size", inputStreamBatchSize);
        return this;
    }
}

