/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.api.InsertResponse;
import com.clickhouse.client.api.InsertSettings;
import com.clickhouse.client.api.Protocol;
import com.clickhouse.client.api.internal.SettingsConverter;
import com.clickhouse.client.api.internal.TableSchemaParser;
import com.clickhouse.client.api.internal.ValidationUtils;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QueryResponse;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseFormat;
import java.io.InputStream;
import java.net.SocketException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Client {
    public static final int TIMEOUT = 30000;
    private Set<String> endpoints;
    private Map<String, String> configuration;
    private List<ClickHouseNode> serverNodes = new ArrayList<ClickHouseNode>();
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private static final Set<String> COMPRESS_ALGORITHMS = ValidationUtils.whiteList("LZ4", "LZ4HC", "ZSTD", "ZSTDHC", "NONE");
    private static final Set<String> OUTPUT_FORMATS = Client.createFormatWhitelist("output");
    private static final Set<String> INPUT_FORMATS = Client.createFormatWhitelist("input");

    private Client(Set<String> endpoints, Map<String, String> configuration) {
        this.endpoints = endpoints;
        this.configuration = configuration;
        this.endpoints.forEach(endpoint -> this.serverNodes.add(ClickHouseNode.of((String)endpoint, this.configuration)));
    }

    private ClickHouseNode getServerNode() {
        return this.serverNodes.get(0);
    }

    public boolean ping() {
        return this.ping(30000);
    }

    public boolean ping(int timeout) {
        ClickHouseClient clientPing = ClickHouseClient.newInstance((ClickHouseProtocol[])new ClickHouseProtocol[]{ClickHouseProtocol.HTTP});
        return clientPing.ping(this.getServerNode(), timeout);
    }

    public void register(Class<?> clazz, TableSchema schema) {
    }

    public Future<InsertResponse> insert(String tableName, List<Object> data, InsertSettings settings, List<ClickHouseColumn> columns) throws ClickHouseException, SocketException {
        return null;
    }

    public Future<InsertResponse> insert(String tableName, InputStream data, InsertSettings settings) throws ClickHouseException, SocketException {
        return null;
    }

    public Future<QueryResponse> query(String sqlQuery, Map<String, Object> qparams, QuerySettings settings) {
        ClickHouseClient client = this.createClient();
        ClickHouseRequest request = client.read(this.getServerNode());
        request.options(SettingsConverter.toRequestOptions(settings.getAllSettings()));
        request.settings(SettingsConverter.toRequestSettings(settings.getAllSettings()));
        request.query(sqlQuery, settings.getQueryID());
        request.format(ClickHouseFormat.valueOf((String)settings.getFormat()));
        if (qparams != null && !qparams.isEmpty()) {
            request.params(qparams, new Object[0]);
        }
        MDC.put((String)"queryId", (String)settings.getQueryID());
        LOG.debug("Executing request: {}", (Object)request);
        return CompletableFuture.completedFuture(new QueryResponse(client, request.execute()));
    }

    public TableSchema getTableSchema(String table, String database) {
        try (ClickHouseClient clientQuery = this.createClient();){
            ClickHouseRequest request = clientQuery.read(this.getServerNode());
            request.query("DESCRIBE TABLE " + table + " FORMAT " + ClickHouseFormat.TSKV.name());
            TableSchema tableSchema = new TableSchema();
            try {
                TableSchema tableSchema2 = new TableSchemaParser().createFromBinaryResponse((ClickHouseResponse)clientQuery.execute(request).get(), table, database);
                return tableSchema2;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get table schema", e);
            }
        }
    }

    private ClickHouseClient createClient() {
        ClickHouseConfig clientConfig = new ClickHouseConfig(new ClickHouseConfig[0]);
        return ClickHouseClient.builder().config(clientConfig).nodeSelector(ClickHouseNodeSelector.of((ClickHouseProtocol)ClickHouseProtocol.HTTP, (ClickHouseProtocol[])new ClickHouseProtocol[0])).build();
    }

    public static Set<String> getCompressAlgorithms() {
        return COMPRESS_ALGORITHMS;
    }

    public static Set<String> getOutputFormats() {
        return OUTPUT_FORMATS;
    }

    private static Set<String> createFormatWhitelist(String shouldSupport) {
        HashSet<String> formats = new HashSet<String>();
        boolean supportOutput = "output".equals(shouldSupport);
        boolean supportInput = "input".equals(shouldSupport);
        boolean supportBoth = "both".equals(shouldSupport);
        for (ClickHouseFormat format : ClickHouseFormat.values()) {
            if (!(supportOutput && format.supportsOutput() || supportInput && format.supportsInput()) && !supportBoth) continue;
            formats.add(format.name());
        }
        return Collections.unmodifiableSet(formats);
    }

    public static class Builder {
        private Set<String> endpoints = new HashSet<String>();
        private Map<String, String> configuration = new HashMap<String, String>();

        public Builder() {
            this.setConnectTimeout(30L, ChronoUnit.SECONDS).setSocketTimeout(2L, ChronoUnit.SECONDS).setSocketRcvbuf(804800L).setSocketSndbuf(804800L);
        }

        public Builder addEndpoint(String endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder addEndpoint(Protocol protocol, String host, int port) {
            String endpoint = String.format("%s://%s:%d", protocol.toString().toLowerCase(), host, port);
            this.addEndpoint(endpoint);
            return this;
        }

        public Builder addConfiguration(String key, String value) {
            this.configuration.put(key, value);
            return this;
        }

        public Builder addUsername(String username) {
            this.configuration.put("user", username);
            return this;
        }

        public Builder addPassword(String password) {
            this.configuration.put("password", password);
            return this;
        }

        public Builder setConnectTimeout(long size) {
            this.configuration.put("connect_timeout", String.valueOf(size));
            return this;
        }

        public Builder setConnectTimeout(long amount, ChronoUnit unit) {
            this.setConnectTimeout(Duration.of(amount, unit).toMillis());
            return this;
        }

        public Builder setSocketTimeout(long size) {
            this.configuration.put("socket_timeout", String.valueOf(size));
            return this;
        }

        public Builder setSocketTimeout(long amount, ChronoUnit unit) {
            this.setSocketTimeout(Duration.of(amount, unit).toMillis());
            return this;
        }

        public Builder setSocketRcvbuf(long size) {
            this.configuration.put("socket_rcvbuf", String.valueOf(size));
            return this;
        }

        public Builder setSocketSndbuf(long size) {
            this.configuration.put("socket_sndbuf", String.valueOf(size));
            return this;
        }

        public Builder setSocketReuseaddr(boolean value) {
            this.configuration.put("socket_reuseaddr", String.valueOf(value));
            return this;
        }

        public Builder setSocketKeepalive(boolean value) {
            this.configuration.put("socket_keepalive", String.valueOf(value));
            return this;
        }

        public Builder setSocketTcpNodelay(boolean value) {
            this.configuration.put("socket_tcp_nodelay", String.valueOf(value));
            return this;
        }

        public Builder setSocketLinger(int secondsToWait) {
            this.configuration.put("socket_linger", String.valueOf(secondsToWait));
            return this;
        }

        public Client build() {
            if (this.endpoints.isEmpty()) {
                throw new IllegalArgumentException("At least one endpoint is required");
            }
            return new Client(this.endpoints, this.configuration);
        }
    }
}

