/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.api.Protocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Client {
    public static final int TIMEOUT = 30000;
    private Set<String> endpoints;
    private Map<String, String> configuration;
    private List<ClickHouseNode> serverNodes = new ArrayList<ClickHouseNode>();

    private Client(Set<String> endpoints, Map<String, String> configuration) {
        this.endpoints = endpoints;
        this.configuration = configuration;
        this.endpoints.forEach(endpoint -> this.serverNodes.add(ClickHouseNode.of((String)endpoint, this.configuration)));
    }

    private ClickHouseNode getServerNode() {
        return this.serverNodes.get(0);
    }

    public boolean ping() {
        return this.ping(30000);
    }

    public boolean ping(int timeout) {
        ClickHouseClient clientPing = ClickHouseClient.newInstance((ClickHouseProtocol[])new ClickHouseProtocol[]{ClickHouseProtocol.HTTP});
        return clientPing.ping(this.getServerNode(), timeout);
    }

    public static class Builder {
        private Set<String> endpoints = new HashSet<String>();
        private Map<String, String> configuration = new HashMap<String, String>();

        public Builder addEndpoint(String endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder addEndpoint(Protocol protocol, String host, int port) {
            String endpoint = String.format("%s://%s:%d", protocol.toString().toLowerCase(), host, port);
            this.addEndpoint(endpoint);
            return this;
        }

        public Builder addConfiguration(String key, String value) {
            this.configuration.put(key, value);
            return this;
        }

        public Builder addUsername(String username) {
            this.configuration.put("user", username);
            return this;
        }

        public Builder addPassword(String password) {
            this.configuration.put("password", password);
            return this;
        }

        public Client build() {
            if (this.endpoints.isEmpty()) {
                throw new IllegalArgumentException("At least one endpoint is required");
            }
            return new Client(this.endpoints, this.configuration);
        }
    }
}

