/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseSimpleResponse;
import com.clickhouse.client.ClickHouseTransaction;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseVersion;
import com.clickhouse.jdbc.ClickHouseArray;
import com.clickhouse.jdbc.ClickHouseBlob;
import com.clickhouse.jdbc.ClickHouseClob;
import com.clickhouse.jdbc.ClickHouseResultSet;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.ClickHouseStruct;
import com.clickhouse.jdbc.ClickHouseXml;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.JdbcTypeMapping;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import java.io.Serializable;
import java.net.URI;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;

@Deprecated
public interface ClickHouseConnection
extends Connection {
    public static final String COLUMN_ELEMENT = "element";
    public static final String COLUMN_ARRAY = "array";
    public static final String PROP_APPLICATION_NAME = "ApplicationName";
    public static final String PROP_CUSTOM_HTTP_HEADERS = "CustomHttpHeaders";
    public static final String PROP_CUSTOM_HTTP_PARAMS = "CustomHttpParameters";

    @Override
    default public ClickHouseArray createArrayOf(String typeName, Object[] elements) throws SQLException {
        ClickHouseConfig config = this.getConfig();
        ClickHouseColumn col = ClickHouseColumn.of((String)COLUMN_ELEMENT, (String)typeName);
        ClickHouseColumn arrCol = ClickHouseColumn.of((String)COLUMN_ARRAY, (ClickHouseDataType)ClickHouseDataType.Array, (boolean)false, (ClickHouseColumn[])new ClickHouseColumn[]{col});
        ClickHouseValue val = arrCol.newValue((ClickHouseDataConfig)config);
        if (elements == null && !col.isNestedType() && !col.isNullable()) {
            int nullAsDefault = this.getJdbcConfig().getNullAsDefault();
            if (nullAsDefault > 1) {
                val.resetToDefault();
            } else if (nullAsDefault < 1) {
                throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Cannot set null to non-nullable column [%s]", (Object[])new Object[]{col}));
            }
        } else {
            val.update(elements);
        }
        ClickHouseResultSet rs = new ClickHouseResultSet(this.getCurrentDatabase(), "unknown", this.createStatement(), ClickHouseSimpleResponse.of((ClickHouseConfig)config, Collections.singletonList(arrCol), (Object[][])new Object[][]{{val.asObject()}}));
        rs.next();
        return new ClickHouseArray(rs, 1);
    }

    @Override
    default public ClickHouseBlob createBlob() throws SQLException {
        return new ClickHouseBlob();
    }

    @Override
    default public ClickHouseClob createClob() throws SQLException {
        return new ClickHouseClob();
    }

    @Override
    default public ClickHouseStruct createStruct(String typeName, Object[] attributes) throws SQLException {
        return new ClickHouseStruct(typeName, attributes);
    }

    @Override
    default public ClickHouseXml createSQLXML() throws SQLException {
        return new ClickHouseXml();
    }

    @Override
    default public ClickHouseStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    default public ClickHouseStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public ClickHouseStatement createStatement(int var1, int var2, int var3) throws SQLException;

    @Override
    default public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, 1);
    }

    @Override
    default public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    default public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("prepareCall not implemented");
    }

    @Override
    default public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw SqlExceptionUtils.unsupportedError("Only NO_GENERATED_KEYS is supported");
        }
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("ClickHouse does not support auto generated keys");
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("ClickHouse does not support auto generated keys");
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    public void begin() throws SQLException;

    public ClickHouseConfig getConfig();

    public boolean allowCustomSetting();

    public String getCurrentDatabase();

    public void setCurrentDatabase(String var1, boolean var2) throws SQLException;

    public String getCurrentUser();

    public Calendar getDefaultCalendar();

    public Optional<TimeZone> getEffectiveTimeZone();

    public TimeZone getJvmTimeZone();

    public TimeZone getServerTimeZone();

    public ClickHouseVersion getServerVersion();

    public ClickHouseTransaction getTransaction();

    public URI getUri();

    public JdbcConfig getJdbcConfig();

    default public JdbcTypeMapping getJdbcTypeMapping() {
        return this.getJdbcConfig().getDialect();
    }

    public long getMaxInsertBlockSize();

    public boolean isTransactionSupported();

    public boolean isImplicitTransactionSupported();

    public String newQueryId();

    @Deprecated
    default public ClickHouseSqlStatement[] parse(String sql, ClickHouseConfig config) {
        return this.parse(sql, config, null);
    }

    public ClickHouseSqlStatement[] parse(String var1, ClickHouseConfig var2, Map<String, Serializable> var3);
}

