/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseNode;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClickHouseException
extends Exception {
    private static final long serialVersionUID = -2417038200885554382L;
    public static final int ERROR_UNKNOWN_SETTING = 115;
    public static final int ERROR_ABORTED = 236;
    public static final int ERROR_CANCELLED = 394;
    public static final int ERROR_NETWORK = 210;
    public static final int ERROR_SESSION_NOT_FOUND = 372;
    public static final int ERROR_SESSION_IS_LOCKED = 373;
    public static final int ERROR_POCO = 1000;
    public static final int ERROR_TIMEOUT = 159;
    public static final int ERROR_UNKNOWN = 1002;
    public static final int ERROR_SUSPICIOUS_TYPE_FOR_LOW_CARDINALITY = 455;
    static final String MSG_CODE = "Code: ";
    static final String MSG_CONNECT_TIMED_OUT = "connect timed out";
    static final Pattern ERROR_CODE_PATTERN = Pattern.compile("Code:[ ]*(\\d+)");
    private final int errorCode;
    private final ClickHouseNode server;

    private static String buildErrorMessageImpl(int code, Throwable cause) {
        return ClickHouseException.buildErrorMessageImpl(code, cause != null ? cause.getMessage() : null);
    }

    private static String buildErrorMessageImpl(int code, String message) {
        StringBuilder builder = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            builder.append(message);
        } else if (code == 236) {
            builder.append(MSG_CODE).append(code).append(". Execution aborted");
        } else if (code == 394) {
            builder.append(MSG_CODE).append(code).append(". Execution cancelled");
        } else if (code == 159) {
            builder.append(MSG_CODE).append(code).append(". Execution timed out");
        } else {
            builder.append("Unknown error ").append(code);
        }
        return builder.toString();
    }

    private static int extractErrorCode(String errorMessage) {
        if (errorMessage == null || errorMessage.isEmpty()) {
            return 1002;
        }
        Matcher matcher = ERROR_CODE_PATTERN.matcher(errorMessage);
        return matcher.find() ? Integer.parseInt(matcher.group(1)) : 1002;
    }

    static Throwable getRootCause(Throwable t) {
        Throwable rootCause;
        if (t == null) {
            return t;
        }
        for (rootCause = t; !(rootCause instanceof ClickHouseException) && rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    public static String buildErrorMessage(int code, String detail) {
        return MSG_CODE + code + ", " + detail;
    }

    public static ClickHouseException forCancellation(Exception e, ClickHouseNode server) {
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        return new ClickHouseException(236, cause, server);
    }

    public static boolean isConnectTimedOut(Throwable t) {
        if (t instanceof SocketTimeoutException || t instanceof TimeoutException) {
            String msg = t.getMessage();
            return msg != null && msg.toLowerCase().contains(MSG_CONNECT_TIMED_OUT);
        }
        return false;
    }

    public static ClickHouseException of(Throwable e, ClickHouseNode server) {
        if (e instanceof ClickHouseException) {
            return (ClickHouseException)e;
        }
        Throwable cause = ClickHouseException.getRootCause(e);
        ClickHouseException exp = cause instanceof ClickHouseException ? (ClickHouseException)cause : (cause instanceof SocketTimeoutException || cause instanceof TimeoutException ? new ClickHouseException(159, cause, server) : (cause instanceof ConnectException || cause instanceof UnknownHostException ? new ClickHouseException(210, cause, server) : new ClickHouseException(ClickHouseException.extractErrorCode(cause != null ? cause.getMessage() : null), cause, server)));
        return exp;
    }

    public static ClickHouseException of(String message, ClickHouseNode server) {
        return new ClickHouseException(ClickHouseException.extractErrorCode(message), message, server);
    }

    public ClickHouseException(int code, Throwable cause, ClickHouseNode server) {
        super(ClickHouseException.buildErrorMessageImpl(code, cause), cause);
        this.server = server;
        this.errorCode = code;
    }

    public ClickHouseException(int code, String message, ClickHouseNode server) {
        super(ClickHouseException.buildErrorMessageImpl(code, message), null);
        this.server = server;
        this.errorCode = code;
    }

    protected ClickHouseException(int code, String message, Throwable cause) {
        super(message, cause);
        this.server = null;
        this.errorCode = code;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public ClickHouseNode getServer() {
        return this.server;
    }
}

