/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseDateValueParser;

final class ClickHouseLocalDateTimeParser
extends ClickHouseDateValueParser<LocalDateTime> {
    private static ClickHouseLocalDateTimeParser instance;

    static ClickHouseLocalDateTimeParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseLocalDateTimeParser();
        }
        return instance;
    }

    private ClickHouseLocalDateTimeParser() {
        super(LocalDateTime.class);
    }

    @Override
    LocalDateTime parseDate(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.parseAsLocalDate(value).atStartOfDay();
    }

    @Override
    LocalDateTime parseDateTime(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateTimeToLocalDateTime(value, columnInfo, timeZone);
    }

    @Override
    LocalDateTime parseNumber(long value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.parseAsInstant(value).atZone(timeZone.toZoneId()).toLocalDateTime();
    }

    @Override
    LocalDateTime parseOther(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        try {
            return this.parseAsLocalDate(value).atStartOfDay();
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return this.parseAsLocalDateTime(value);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                Instant i = this.parseAsInstant(value);
                return i.atZone(timeZone.toZoneId()).toLocalDateTime();
            }
        }
    }
}

