/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseDateTimeValue;
import com.clickhouse.client.data.ClickHouseDateValue;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.JdbcTypeMapping;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public class SqlBasedPreparedStatement
extends ClickHouseStatementImpl
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(SqlBasedPreparedStatement.class);
    private final Calendar defaultCalendar;
    private final ZoneId jvmZoneId;
    private final ClickHouseSqlStatement parsedStmt;
    private final ClickHouseParameterizedQuery preparedQuery;
    private final ClickHouseValue[] templates;
    private final String[] values;
    private final List<String[]> batch;

    protected SqlBasedPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, ClickHouseSqlStatement parsedStmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.defaultCalendar = connection.getDefaultCalendar();
        this.jvmZoneId = connection.getJvmTimeZone().toZoneId();
        this.parsedStmt = parsedStmt;
        this.preparedQuery = request.getPreparedQuery();
        this.templates = this.preparedQuery.getParameterTemplates();
        this.values = new String[this.templates.length];
        this.batch = new LinkedList<String[]>();
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            columns.add(String.valueOf(i + 1));
        }
        if (!columns.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing parameter(s): %s", (Object[])new Object[]{columns}));
        }
    }

    protected int toArrayIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.templates.length) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Parameter index must between 1 and %d but we got %d", (Object[])new Object[]{this.templates.length, parameterIndex}));
        }
        return parameterIndex - 1;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        return this.executeQuery(this.preparedQuery.apply(this.values));
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.ensureParams();
        return this.executeUpdate(this.preparedQuery.apply(this.values));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = ClickHouseValues.convertToQuotedString((Object)x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = new String(x, StandardCharsets.UTF_8);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else if (x instanceof ClickHouseValue) {
            this.templates[idx] = value = (ClickHouseValue)x;
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = ClickHouseValues.convertToSqlExpression((Object)x);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        return this.execute(this.preparedQuery.apply(this.values));
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        String[] newValues = new String[len];
        for (int i = 0; i < len; ++i) {
            String v = this.values[i];
            if (v == null) {
                throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing value for parameter #%d", (Object[])new Object[]{i + 1}));
            }
            newValues[i] = v;
        }
        this.batch.add(newValues);
        this.clearParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureOpen();
        int len = this.batch.size();
        int[] results = new int[len];
        int counter = 0;
        for (String[] params : this.batch) {
            try (ClickHouseResponse r = this.executeStatement(this.preparedQuery.apply(params), null, null, null);){
                results[counter] = (int)r.getSummary().getWrittenRows();
            }
            catch (Exception e) {
                results[counter] = -3;
                log.error((Object)"Failed to execute task %d of %d", new Object[]{counter + 1, len, e});
            }
            ++counter;
        }
        this.clearBatch();
        return results;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        Object array = x != null ? x.getArray() : x;
        this.values[idx] = array != null ? ClickHouseValues.convertToSqlExpression((Object)array) : "[]";
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x == null) {
            this.values[idx] = "NULL";
            return;
        }
        LocalDate d = null;
        d = cal != null ? x.toLocalDate().atStartOfDay(this.jvmZoneId).withZoneSameInstant(cal.getTimeZone().toZoneId()).toLocalDate() : x.toLocalDate();
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            value = ClickHouseDateValue.ofNull();
        }
        this.values[idx] = value.update(d).toSqlExpression();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw SqlExceptionUtils.clientError("setTime not implemented");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x == null) {
            this.values[idx] = "NULL";
            return;
        }
        LocalDateTime dt = null;
        dt = cal != null ? x.toLocalDateTime().atZone(this.jvmZoneId).withZoneSameInstant(cal.getTimeZone().toZoneId()).toLocalDateTime() : x.toLocalDateTime();
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            value = ClickHouseDateTimeValue.ofNull((int)(dt.getNano() > 0 ? 9 : 0));
        }
        this.values[idx] = value.update(dt).toSqlExpression();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.resetToNullOrEmpty();
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = "NULL";
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            this.templates[idx] = value = ClickHouseValues.newValue((ClickHouseColumn)JdbcTypeMapping.fromJdbcType(targetSqlType, scaleOrLength));
        }
        value.update(x);
        this.values[idx] = value.toSqlExpression();
    }
}

