/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseDataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

public final class JdbcTypeMapping {
    public static int toJdbcType(Class<?> javaClass) {
        int sqlType = 1111;
        if (javaClass == Boolean.TYPE || javaClass == Boolean.class) {
            sqlType = 16;
        } else if (javaClass == Byte.TYPE || javaClass == Byte.class) {
            sqlType = -6;
        } else if (javaClass == Short.TYPE || javaClass == Short.class) {
            sqlType = 5;
        } else if (javaClass == Integer.TYPE || javaClass == Integer.class) {
            sqlType = 4;
        } else if (javaClass == Long.TYPE || javaClass == Long.class) {
            sqlType = -5;
        } else if (javaClass == Float.TYPE || javaClass == Float.class) {
            sqlType = 6;
        } else if (javaClass == Double.TYPE || javaClass == Double.class) {
            sqlType = 8;
        } else if (javaClass == BigInteger.class) {
            sqlType = 2;
        } else if (javaClass == BigDecimal.class) {
            sqlType = 3;
        } else if (javaClass == Date.class || javaClass == LocalDate.class) {
            sqlType = 91;
        } else if (javaClass == Time.class || javaClass == LocalTime.class) {
            sqlType = 92;
        } else if (javaClass == Timestamp.class || javaClass == LocalDateTime.class) {
            sqlType = 93;
        } else if (javaClass == OffsetDateTime.class || javaClass == ZonedDateTime.class) {
            sqlType = 2014;
        } else if (javaClass == String.class || javaClass == byte[].class || Enum.class.isAssignableFrom(javaClass)) {
            sqlType = 12;
        } else if (javaClass.isArray()) {
            sqlType = 2003;
        }
        return sqlType;
    }

    public static int toJdbcType(Map<String, Class<?>> typeMap, ClickHouseColumn column) {
        if (typeMap != null && !typeMap.isEmpty()) {
            Class<?> javaClass = typeMap.get(column.getOriginalTypeName());
            if (javaClass == null) {
                javaClass = typeMap.get(column.getDataType().name());
            }
            if (javaClass != null) {
                return JdbcTypeMapping.toJdbcType(javaClass);
            }
        }
        int sqlType = 1111;
        switch (column.getDataType()) {
            case Bool: {
                sqlType = 16;
                break;
            }
            case Int8: {
                sqlType = -6;
                break;
            }
            case UInt8: 
            case Int16: {
                sqlType = 5;
                break;
            }
            case UInt16: 
            case Int32: {
                sqlType = 4;
                break;
            }
            case UInt32: 
            case IntervalYear: 
            case IntervalQuarter: 
            case IntervalMonth: 
            case IntervalWeek: 
            case IntervalDay: 
            case IntervalHour: 
            case IntervalMinute: 
            case IntervalSecond: 
            case Int64: {
                sqlType = -5;
                break;
            }
            case UInt64: 
            case Int128: 
            case UInt128: 
            case Int256: 
            case UInt256: {
                sqlType = 2;
                break;
            }
            case Float32: {
                sqlType = 6;
                break;
            }
            case Float64: {
                sqlType = 8;
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                sqlType = 3;
                break;
            }
            case Date: 
            case Date32: {
                sqlType = 91;
                break;
            }
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                sqlType = column.getTimeZone() != null ? 2014 : 93;
                break;
            }
            case Enum: 
            case Enum8: 
            case Enum16: 
            case IPv4: 
            case IPv6: 
            case FixedString: 
            case String: 
            case UUID: {
                sqlType = 12;
                break;
            }
            case Point: 
            case Ring: 
            case Polygon: 
            case MultiPolygon: 
            case Array: {
                sqlType = 2003;
                break;
            }
            case Tuple: 
            case Nested: {
                sqlType = 2002;
                break;
            }
            case Nothing: {
                sqlType = 0;
                break;
            }
        }
        return sqlType;
    }

    public static Class<?> toJavaClass(ClickHouseColumn column) {
        Class clazz;
        ClickHouseDataType type = column.getDataType();
        switch (type) {
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                clazz = column.getTimeZone() != null ? OffsetDateTime.class : LocalDateTime.class;
                break;
            }
            default: {
                clazz = type.getObjectClass();
            }
        }
        return clazz;
    }

    public static ClickHouseColumn fromJdbcType(int jdbcType, int scaleOrLength) {
        ClickHouseDataType dataType = JdbcTypeMapping.fromJdbcType(jdbcType);
        ClickHouseColumn column = null;
        if (scaleOrLength > 0) {
            if (jdbcType == 2 || jdbcType == 3) {
                for (ClickHouseDataType t : new ClickHouseDataType[]{}) {
                    if (scaleOrLength > t.getMaxScale() / 2) continue;
                    column = ClickHouseColumn.of((String)"", (ClickHouseDataType)t, (boolean)false, (int)(t.getMaxPrecision() - t.getMaxScale()), (int)scaleOrLength);
                    break;
                }
            } else if (dataType == ClickHouseDataType.Date) {
                if (scaleOrLength > 2) {
                    dataType = ClickHouseDataType.Date32;
                }
            } else if (dataType == ClickHouseDataType.DateTime) {
                column = ClickHouseColumn.of((String)"", (ClickHouseDataType)ClickHouseDataType.DateTime64, (boolean)false, (int)0, (int)scaleOrLength);
            } else if (dataType == ClickHouseDataType.String) {
                column = ClickHouseColumn.of((String)"", (ClickHouseDataType)ClickHouseDataType.FixedString, (boolean)false, (int)scaleOrLength, (int)0);
            }
        }
        return column == null ? ClickHouseColumn.of((String)"", (ClickHouseDataType)dataType, (boolean)false, (boolean)false, (String[])new String[0]) : column;
    }

    public static ClickHouseDataType fromJdbcType(int jdbcType) {
        ClickHouseDataType dataType;
        switch (jdbcType) {
            case -7: 
            case 16: {
                dataType = ClickHouseDataType.UInt8;
                break;
            }
            case -6: {
                dataType = ClickHouseDataType.Int8;
                break;
            }
            case 5: {
                dataType = ClickHouseDataType.Int16;
                break;
            }
            case 4: {
                dataType = ClickHouseDataType.Int32;
                break;
            }
            case -5: {
                dataType = ClickHouseDataType.Int64;
                break;
            }
            case 2: {
                dataType = ClickHouseDataType.Int256;
                break;
            }
            case 6: 
            case 7: {
                dataType = ClickHouseDataType.Float32;
                break;
            }
            case 8: {
                dataType = ClickHouseDataType.Float64;
                break;
            }
            case 3: {
                dataType = ClickHouseDataType.Decimal;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2000: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 2011: {
                dataType = ClickHouseDataType.String;
                break;
            }
            case 91: {
                dataType = ClickHouseDataType.Date;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                dataType = ClickHouseDataType.DateTime;
                break;
            }
            case 2003: {
                dataType = ClickHouseDataType.Array;
                break;
            }
            case 2002: {
                dataType = ClickHouseDataType.Nested;
                break;
            }
            default: {
                dataType = ClickHouseDataType.Nothing;
            }
        }
        return dataType;
    }

    private JdbcTypeMapping() {
    }
}

