/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseUtils;
import java.util.Collection;
import java.util.Iterator;

public final class JdbcParameterizedQuery
extends ClickHouseParameterizedQuery {
    public static JdbcParameterizedQuery of(String query) {
        return new JdbcParameterizedQuery(query);
    }

    private JdbcParameterizedQuery(String query) {
        super(query);
    }

    protected String parse() {
        int paramIndex = 0;
        int partIndex = 0;
        int len = this.originalQuery.length();
        for (int i = 0; i < len; ++i) {
            char ch = this.originalQuery.charAt(i);
            if (ClickHouseUtils.isQuote((char)ch)) {
                i = ClickHouseUtils.skipQuotedString((String)this.originalQuery, (int)i, (int)len, (char)ch) - 1;
                continue;
            }
            if (ch == '?') {
                int idx = ClickHouseUtils.skipContentsUntil((String)this.originalQuery, (int)(i + 2), (int)len, (char[])new char[]{'?', ':'});
                if (idx < len && this.originalQuery.charAt(idx - 1) == ':' && this.originalQuery.charAt(idx) != ':' && this.originalQuery.charAt(idx - 2) != ':') {
                    i = idx - 1;
                    continue;
                }
                this.addPart(this.originalQuery.substring(partIndex, i), paramIndex++, null);
                partIndex = i + 1;
                continue;
            }
            if (ch == ';') {
                throw new IllegalArgumentException(ClickHouseUtils.format((String)"Multi-statement query cannot be used in prepared statement. Please remove semicolon at %d and everything after it.", (Object[])new Object[]{i}));
            }
            if (i + 1 >= len) continue;
            char nextCh = this.originalQuery.charAt(i + 1);
            if (ch == '-' && nextCh == ch) {
                i = ClickHouseUtils.skipSingleLineComment((String)this.originalQuery, (int)(i + 2), (int)len) - 1;
                continue;
            }
            if (ch != '/' || nextCh != '*') continue;
            i = ClickHouseUtils.skipMultiLineComment((String)this.originalQuery, (int)(i + 2), (int)len) - 1;
        }
        return partIndex < len ? this.originalQuery.substring(partIndex, len) : null;
    }

    public String apply(Collection<String> params) {
        if (!this.hasParameter()) {
            return this.originalQuery;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = params == null ? null : params.iterator();
        boolean hasMore = it != null && it.hasNext();
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            builder.append(hasMore ? it.next() : "NULL");
            hasMore = hasMore && it.hasNext();
        }
        return this.appendLastPartIfExists(builder).toString();
    }

    public String apply(Object param, Object ... more) {
        if (!this.hasParameter()) {
            return this.originalQuery;
        }
        int len = more == null ? 0 : more.length + 1;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            if (index > 0) {
                param = index < len ? more[index - 1] : null;
            }
            builder.append(this.toSqlExpression(p.paramName, param));
            ++index;
        }
        return this.appendLastPartIfExists(builder).toString();
    }

    public String apply(Object[] values) {
        if (!this.hasParameter()) {
            return this.originalQuery;
        }
        int len = values == null ? 0 : values.length;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            builder.append(index < len ? this.toSqlExpression(p.paramName, values[index]) : "NULL");
            ++index;
        }
        return this.appendLastPartIfExists(builder).toString();
    }

    public String apply(String param, String ... more) {
        if (!this.hasParameter()) {
            return this.originalQuery;
        }
        int len = more == null ? 0 : more.length + 1;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            if (index > 0) {
                param = index < len ? more[index - 1] : "NULL";
            }
            builder.append(param);
            ++index;
        }
        return this.appendLastPartIfExists(builder).toString();
    }

    public String apply(String[] values) {
        if (!this.hasParameter()) {
            return this.originalQuery;
        }
        int len = values == null ? 0 : values.length;
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (ClickHouseParameterizedQuery.QueryPart p : this.getParts()) {
            builder.append(p.part);
            builder.append(index < len ? values[index] : "NULL");
            ++index;
        }
        return this.appendLastPartIfExists(builder).toString();
    }
}

