/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ClickHouseDataSource
extends JdbcWrapper
implements DataSource {
    private final String url;
    protected final ClickHouseDriver driver;
    protected final ClickHouseJdbcUrlParser.ConnectionInfo connInfo;
    protected PrintWriter printWriter;
    protected int loginTimeoutSeconds = 0;

    public ClickHouseDataSource(String url) throws SQLException {
        this(url, new Properties());
    }

    public ClickHouseDataSource(String url, Properties properties) throws SQLException {
        if (url == null) {
            throw new IllegalArgumentException("Incorrect ClickHouse jdbc url. It must be not null");
        }
        this.url = url;
        this.driver = new ClickHouseDriver();
        this.connInfo = ClickHouseJdbcUrlParser.parse(url, properties);
    }

    @Override
    public ClickHouseConnection getConnection() throws SQLException {
        return new ClickHouseConnectionImpl(this.connInfo);
    }

    @Override
    public ClickHouseConnection getConnection(String username, String password) throws SQLException {
        if (username == null || username.isEmpty()) {
            throw SqlExceptionUtils.clientError("Non-empty user name is required");
        }
        if (password == null) {
            password = "";
        }
        Properties props = new Properties(this.connInfo.getProperties());
        props.setProperty(ClickHouseDefaults.USER.getKey(), username);
        props.setProperty(ClickHouseDefaults.PASSWORD.getKey(), password);
        return this.driver.connect(this.url, props);
    }

    public String getHost() {
        return this.connInfo.getServer().getHost();
    }

    public int getPort() {
        return this.connInfo.getServer().getPort();
    }

    public String getDatabase() {
        return this.connInfo.getServer().getDatabase().orElse((String)((Object)ClickHouseDefaults.DATABASE.getEffectiveDefaultValue()));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeoutSeconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return ClickHouseDriver.parentLogger;
    }
}

