/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.http.ApacheHttpConnectionImpl;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.HttpClientConnectionImpl;
import com.clickhouse.client.http.HttpUrlConnectionImpl;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.http.config.HttpConnectionProvider;
import com.clickhouse.config.ClickHouseOption;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ClickHouseHttpConnectionFactory {
    public static ClickHouseHttpConnection createConnection(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        HttpConnectionProvider provider = (HttpConnectionProvider)((Object)request.getConfig().getOption((ClickHouseOption)ClickHouseHttpOption.CONNECTION_PROVIDER, HttpConnectionProvider.class));
        try {
            return provider == null || provider == HttpConnectionProvider.HTTP_URL_CONNECTION ? new HttpUrlConnectionImpl(server, request, executor) : (provider == HttpConnectionProvider.HTTP_CLIENT ? new HttpClientConnectionImpl(server, request, executor) : new ApacheHttpConnectionImpl(server, request, executor));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            return new HttpUrlConnectionImpl(server, request, executor);
        }
    }

    private ClickHouseHttpConnectionFactory() {
    }
}

