/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpUrlConnectionImpl
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpUrlConnectionImpl.class);
    private final HttpURLConnection conn;

    private ClickHouseHttpResponse buildResponse() throws IOException {
        String displayName = this.getResponseHeader("X-ClickHouse-Server-Display-Name", this.server.getHost());
        String queryId = this.getResponseHeader("X-ClickHouse-Query-Id", "");
        String summary = this.getResponseHeader("X-ClickHouse-Summary", "{}");
        ClickHouseFormat format = this.config.getFormat();
        TimeZone timeZone = this.config.getServerTimeZone();
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)queryId)) {
            String value = this.getResponseHeader("X-ClickHouse-Format", "");
            format = !ClickHouseChecker.isNullOrEmpty((CharSequence)value) ? ClickHouseFormat.valueOf((String)value) : format;
            value = this.getResponseHeader("X-ClickHouse-Timezone", "");
            timeZone = !ClickHouseChecker.isNullOrEmpty((CharSequence)value) ? TimeZone.getTimeZone(value) : timeZone;
        }
        return new ClickHouseHttpResponse(this, this.getResponseInputStream(this.conn.getInputStream()), displayName, queryId, summary, format, timeZone);
    }

    private HttpURLConnection newConnection(String url, boolean post) throws IOException {
        HttpURLConnection newConn = (HttpURLConnection)new URL(url).openConnection();
        if (newConn instanceof HttpsURLConnection && this.config.isSsl()) {
            HttpsURLConnection secureConn = (HttpsURLConnection)newConn;
            SSLContext sslContext = ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, this.config).orElse(null);
            HostnameVerifier verifier = this.config.getSslMode() == ClickHouseSslMode.STRICT ? HttpsURLConnection.getDefaultHostnameVerifier() : (hostname, session) -> true;
            secureConn.setHostnameVerifier(verifier);
            secureConn.setSSLSocketFactory(sslContext.getSocketFactory());
        }
        if (post) {
            newConn.setInstanceFollowRedirects(true);
            newConn.setRequestMethod("POST");
        }
        newConn.setUseCaches(false);
        newConn.setAllowUserInteraction(false);
        newConn.setDoInput(true);
        newConn.setDoOutput(true);
        newConn.setConnectTimeout(this.config.getConnectionTimeout());
        newConn.setReadTimeout(this.config.getSocketTimeout());
        return newConn;
    }

    private String getResponseHeader(String header, String defaultValue) {
        String value = this.conn.getHeaderField(header);
        return value != null ? value : defaultValue;
    }

    private void setHeaders(HttpURLConnection conn, Map<String, String> headers) {
        if ((headers = this.mergeHeaders(headers)) == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private void checkResponse(HttpURLConnection conn) throws IOException {
        if (conn.getResponseCode() != 200) {
            StringBuilder builder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.getResponseInputStream(conn.getErrorStream()), StandardCharsets.UTF_8));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    builder.append((char)c);
                }
            }
            catch (IOException e) {
                log.warn((Object)"Error while reading error message", (Throwable)e);
            }
            throw new IOException(builder.toString());
        }
    }

    protected HttpUrlConnectionImpl(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        super(server, request);
        this.conn = this.newConnection(this.url, true);
    }

    @Override
    protected boolean isReusable() {
        return false;
    }

    @Override
    protected ClickHouseHttpResponse post(String sql, InputStream data, List<ClickHouseExternalTable> tables, Map<String, String> headers) throws IOException {
        String boundary = null;
        if (tables != null && !tables.isEmpty()) {
            boundary = UUID.randomUUID().toString();
            this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        } else {
            this.conn.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        }
        this.setHeaders(this.conn, headers);
        try (OutputStream out = this.getRequestOutputStream(this.conn.getOutputStream());
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
            if (boundary != null) {
                String line = "\r\n--" + boundary + "\r\n";
                writer.write(line);
                writer.write("Content-Disposition: form-data; name=\"query\"\r\n\r\n");
                writer.write(sql);
                for (ClickHouseExternalTable t : tables) {
                    String tableName = t.getName();
                    StringBuilder builder = new StringBuilder();
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_format\"\r\n\r\n").append(t.getFormat().name());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_structure\"\r\n\r\n").append(t.getStructure());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("\"; filename=\"").append(tableName).append("\"\r\n").append("Content-Type: application/octet-stream\r\n").append("Content-Transfer-Encoding: binary\r\n\r\n");
                    writer.write(builder.toString());
                    writer.flush();
                    this.pipe(t.getContent(), out, 8192);
                }
                writer.write("\r\n--" + boundary + "--\r\n");
                writer.flush();
            } else {
                writer.write(sql);
                writer.flush();
                if (data != null && data.available() > 0) {
                    if (sql.charAt(sql.length() - 1) != '\n') {
                        out.write(10);
                    }
                    this.pipe(data, out, 8192);
                }
            }
        }
        this.checkResponse(this.conn);
        return this.buildResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping(int timeout) {
        block11: {
            String response = (String)((Object)this.config.getOption((ClickHouseOption)ClickHouseHttpOption.DEFAULT_RESPONSE));
            HttpURLConnection c = null;
            try {
                boolean bl;
                c = this.newConnection(this.getBaseUrl() + "ping", false);
                c.setConnectTimeout(timeout);
                c.setReadTimeout(timeout);
                this.checkResponse(c);
                int size = 12;
                ByteArrayOutputStream out = new ByteArrayOutputStream(size);
                try {
                    this.pipe(c.getInputStream(), out, size);
                    c.disconnect();
                    c = null;
                    bl = response.equals(new String(out.toByteArray(), StandardCharsets.UTF_8));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug((Object)"Failed to ping server: ", new Object[]{e.getMessage()});
                        break block11;
                    }
                }
                out.close();
                return bl;
            }
            finally {
                if (c != null) {
                    c.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.conn.disconnect();
    }
}

