/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.data.ClickHousePipedStream;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.ClickHouseResponseHandler;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultHttpConnection
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpConnection.class);
    private final HttpClient httpClient;

    private ClickHouseHttpResponse buildResponse(HttpResponse<InputStream> r) throws IOException {
        HttpHeaders headers = r.headers();
        String displayName = headers.firstValue("X-ClickHouse-Server-Display-Name").orElse(this.server.getHost());
        String queryId = headers.firstValue("X-ClickHouse-Query-Id").orElse("");
        String summary = headers.firstValue("X-ClickHouse-Summary").orElse("{}");
        ClickHouseFormat format = this.config.getFormat();
        TimeZone timeZone = this.config.getServerTimeZone();
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)queryId)) {
            String value = headers.firstValue("X-ClickHouse-Format").orElse("");
            format = !ClickHouseChecker.isNullOrEmpty((CharSequence)value) ? ClickHouseFormat.valueOf((String)value) : format;
            value = headers.firstValue("X-ClickHouse-Timezone").orElse("");
            timeZone = !ClickHouseChecker.isNullOrEmpty((CharSequence)value) ? TimeZone.getTimeZone(value) : timeZone;
        }
        return new ClickHouseHttpResponse(this, this.getResponseInputStream(this.checkResponse(r).body()), displayName, queryId, summary, format, timeZone);
    }

    private HttpResponse<InputStream> checkResponse(HttpResponse<InputStream> r) throws IOException {
        if (r.statusCode() != 200) {
            StringBuilder builder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.getResponseInputStream(r.body()), StandardCharsets.UTF_8));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    builder.append((char)c);
                }
            }
            catch (IOException e) {
                log.warn((Object)"Error while reading error message", (Throwable)e);
            }
            throw new IOException(builder.toString());
        }
        return r;
    }

    private HttpRequest newRequest(String url) {
        return HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofMillis(this.config.getSocketTimeout())).build();
    }

    protected DefaultHttpConnection(ClickHouseNode server, ClickHouseRequest<?> request) throws IOException {
        super(server, request);
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(this.config.getConnectionTimeout())).followRedirects(HttpClient.Redirect.ALWAYS).version(HttpClient.Version.HTTP_1_1);
        if (this.config.isAsync()) {
            builder.executor(ClickHouseClient.getExecutorService());
        }
        if (this.config.isSsl()) {
            builder.sslContext(ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, this.config).orElse(null));
        }
        this.httpClient = builder.build();
    }

    @Override
    protected boolean isReusable() {
        return true;
    }

    private ClickHouseHttpResponse postStream(HttpRequest.Builder reqBuilder, String boundary, String sql, InputStream data, List<ClickHouseExternalTable> tables) throws IOException {
        HttpResponse<InputStream> r;
        ClickHousePipedStream stream = new ClickHousePipedStream(this.config.getMaxBufferSize(), this.config.getMaxQueuedBuffers(), this.config.getSocketTimeout());
        reqBuilder.POST(HttpRequest.BodyPublishers.ofInputStream(() -> ((ClickHousePipedStream)stream).getInput()));
        CompletableFuture f = this.httpClient.sendAsync(reqBuilder.build(), responseInfo -> new ClickHouseResponseHandler(this.config.getMaxBufferSize(), this.config.getSocketTimeout()));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
            if (boundary != null) {
                String line = "\r\n--" + boundary + "\r\n";
                writer.write(line);
                writer.write("Content-Disposition: form-data; name=\"query\"\r\n\r\n");
                writer.write(sql);
                for (ClickHouseExternalTable t : tables) {
                    String tableName = t.getName();
                    StringBuilder builder = new StringBuilder();
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_format\"\r\n\r\n").append(t.getFormat().name());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_structure\"\r\n\r\n").append(t.getStructure());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("\"; filename=\"").append(tableName).append("\"\r\n").append("Content-Type: application/octet-stream\r\n").append("Content-Transfer-Encoding: binary\r\n\r\n");
                    writer.write(builder.toString());
                    writer.flush();
                    this.pipe(t.getContent(), (OutputStream)stream, 8192);
                }
                writer.write("\r\n--" + boundary + "--\r\n");
                writer.flush();
            } else {
                writer.write(sql);
                writer.flush();
                if (data.available() > 0) {
                    if (sql.charAt(sql.length() - 1) != '\n') {
                        stream.write(10);
                    }
                    this.pipe(data, (OutputStream)stream, 8192);
                }
            }
        }
        try {
            r = f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when posting request or receiving response", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to post request", e);
        }
        return this.buildResponse(r);
    }

    private ClickHouseHttpResponse postString(HttpRequest.Builder reqBuilder, String sql) throws IOException {
        HttpResponse<InputStream> r;
        reqBuilder.POST(HttpRequest.BodyPublishers.ofString(sql));
        try {
            CompletableFuture f = this.httpClient.sendAsync(reqBuilder.build(), responseInfo -> new ClickHouseResponseHandler(this.config.getMaxBufferSize(), this.config.getSocketTimeout()));
            r = f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when posting request or receiving response", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to post query", e);
        }
        return this.buildResponse(r);
    }

    @Override
    protected ClickHouseHttpResponse post(String sql, InputStream data, List<ClickHouseExternalTable> tables, Map<String, String> headers) throws IOException {
        HttpRequest.Builder reqBuilder = HttpRequest.newBuilder().uri(URI.create(this.url)).timeout(Duration.ofMillis(this.config.getSocketTimeout()));
        String boundary = null;
        if (tables != null && !tables.isEmpty()) {
            boundary = UUID.randomUUID().toString();
            reqBuilder.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        } else {
            reqBuilder.setHeader("Content-Type", "text/plain; charset=UTF-8");
        }
        headers = this.mergeHeaders(headers);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                reqBuilder.setHeader(header.getKey(), header.getValue());
            }
        }
        return boundary != null || data != null ? this.postStream(reqBuilder, boundary, sql, data, tables) : this.postString(reqBuilder, sql);
    }

    @Override
    public boolean ping(int timeout) {
        String response = (String)((Object)this.config.getOption((ClickHouseOption)ClickHouseHttpOption.DEFAULT_RESPONSE));
        try {
            HttpResponse<String> r = this.httpClient.send(this.newRequest(this.getBaseUrl() + "ping"), HttpResponse.BodyHandlers.ofString());
            if (r.statusCode() != 200) {
                throw new IOException(r.body());
            }
            return response.equals(r.body());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            log.debug((Object)"Failed to ping server: ", new Object[]{e.getMessage()});
        }
        return false;
    }

    @Override
    public void close() {
    }
}

