/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.data.ClickHousePipedStream;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.ClickHouseResponseHandler;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.net.ssl.SSLContext;

public class HttpClientConnectionImpl
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConnectionImpl.class);
    private static final int MAX_RETRIES = 1;
    private final HttpClient httpClient;
    private final HttpRequest pingRequest;

    private ClickHouseHttpResponse buildResponse(HttpResponse<InputStream> r) throws IOException {
        HttpHeaders headers = r.headers();
        String displayName = headers.firstValue("X-ClickHouse-Server-Display-Name").orElse(this.server.getHost());
        String queryId = headers.firstValue("X-ClickHouse-Query-Id").orElse("");
        String summary = headers.firstValue("X-ClickHouse-Summary").orElse("{}");
        ClickHouseFormat format = this.config.getFormat();
        TimeZone timeZone = this.config.getServerTimeZone();
        if (!ClickHouseChecker.isNullOrEmpty(queryId)) {
            String value = headers.firstValue("X-ClickHouse-Format").orElse("");
            format = !ClickHouseChecker.isNullOrEmpty(value) ? ClickHouseFormat.valueOf(value) : format;
            value = headers.firstValue("X-ClickHouse-Timezone").orElse("");
            timeZone = !ClickHouseChecker.isNullOrEmpty(value) ? TimeZone.getTimeZone(value) : timeZone;
        }
        return new ClickHouseHttpResponse((ClickHouseHttpConnection)this, this.getResponseInputStream((InputStream)this.checkResponse(r).body()), displayName, queryId, summary, format, timeZone);
    }

    private HttpResponse<InputStream> checkResponse(HttpResponse<InputStream> r) throws IOException {
        if (r.statusCode() != 200) {
            StringBuilder builder = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader((InputStream)this.getResponseInputStream(r.body()), StandardCharsets.UTF_8);){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    builder.append((char)c);
                }
            }
            catch (IOException e) {
                log.warn((Object)"Error while reading error message", e);
            }
            throw new IOException(builder.toString());
        }
        return r;
    }

    private HttpRequest newRequest(String url) {
        return HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofMillis(this.config.getSocketTimeout())).build();
    }

    protected HttpClientConnectionImpl(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        super(server, request);
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofMillis(this.config.getConnectionTimeout())).followRedirects(HttpClient.Redirect.NORMAL);
        if (executor != null) {
            builder.executor(executor);
        }
        if (this.config.isSsl()) {
            builder.sslContext(ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, this.config).orElse(null));
        }
        this.httpClient = builder.build();
        this.pingRequest = this.newRequest(this.getBaseUrl() + "ping");
    }

    protected boolean isReusable() {
        return true;
    }

    private CompletableFuture<HttpResponse<Void>> retry(Throwable firstError, int retry) {
        if (retry >= 1) {
            CompletableFuture<HttpResponse<Void>> failure = new CompletableFuture<HttpResponse<Void>>();
            failure.completeExceptionally(firstError);
            return failure;
        }
        return ((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(this.pingRequest, HttpResponse.BodyHandlers.discarding()).thenApply(CompletableFuture::completedFuture)).exceptionally(t -> {
            firstError.addSuppressed((Throwable)t);
            return this.retry(firstError, retry + 1);
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<HttpResponse<InputStream>> postRequest(HttpRequest request) {
        boolean retry = false;
        CompletionStage<HttpResponse<InputStream>> f = retry ? ((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(this.pingRequest, HttpResponse.BodyHandlers.discarding()).thenApply(CompletableFuture::completedFuture)).exceptionally(t -> this.retry(t, 0))).thenCompose(t -> this.httpClient.sendAsync(request, responseInfo -> new ClickHouseResponseHandler(this.config.getMaxQueuedBuffers(), this.config.getSocketTimeout()))) : this.httpClient.sendAsync(request, responseInfo -> new ClickHouseResponseHandler(this.config.getMaxQueuedBuffers(), this.config.getSocketTimeout()));
        return f;
    }

    private ClickHouseHttpResponse postStream(HttpRequest.Builder reqBuilder, String boundary, String sql, InputStream data, List<ClickHouseExternalTable> tables) throws IOException {
        HttpResponse r;
        ClickHousePipedStream stream = new ClickHousePipedStream(this.config.getMaxBufferSize(), this.config.getMaxQueuedBuffers(), this.config.getSocketTimeout());
        reqBuilder.POST(HttpRequest.BodyPublishers.ofInputStream(stream::getInput));
        CompletableFuture f = this.postRequest(reqBuilder.build());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
            if (boundary != null) {
                String line = "\r\n--" + boundary + "\r\n";
                writer.write(line);
                writer.write("Content-Disposition: form-data; name=\"query\"\r\n\r\n");
                writer.write(sql);
                for (ClickHouseExternalTable t : tables) {
                    String tableName = t.getName();
                    StringBuilder builder = new StringBuilder();
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_format\"\r\n\r\n").append(t.getFormat().name());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("_structure\"\r\n\r\n").append(t.getStructure());
                    builder.append(line).append("Content-Disposition: form-data; name=\"").append(tableName).append("\"; filename=\"").append(tableName).append("\"\r\n").append("Content-Type: application/octet-stream\r\n").append("Content-Transfer-Encoding: binary\r\n\r\n");
                    writer.write(builder.toString());
                    writer.flush();
                    this.pipe(t.getContent(), (OutputStream)stream, 8192);
                }
                writer.write("\r\n--" + boundary + "--\r\n");
                writer.flush();
            } else {
                writer.write(sql);
                writer.flush();
                if (data.available() > 0) {
                    if (sql.charAt(sql.length() - 1) != '\n') {
                        stream.write(10);
                    }
                    this.pipe(data, (OutputStream)stream, 8192);
                }
            }
        }
        try {
            r = (HttpResponse)f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when posting request or receiving response", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to post request", e);
        }
        return this.buildResponse(r);
    }

    private ClickHouseHttpResponse postString(HttpRequest.Builder reqBuilder, String sql) throws IOException {
        HttpResponse r;
        reqBuilder.POST(HttpRequest.BodyPublishers.ofString(sql));
        try {
            r = (HttpResponse)this.postRequest(reqBuilder.build()).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when posting request or receiving response", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to post query", e);
        }
        return this.buildResponse(r);
    }

    protected ClickHouseHttpResponse post(String sql, InputStream data, List<ClickHouseExternalTable> tables, Map<String, String> headers) throws IOException {
        HttpRequest.Builder reqBuilder = HttpRequest.newBuilder().uri(URI.create(this.url)).timeout(Duration.ofMillis(this.config.getSocketTimeout()));
        String boundary = null;
        if (tables != null && !tables.isEmpty()) {
            boundary = UUID.randomUUID().toString();
            reqBuilder.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        } else {
            reqBuilder.setHeader("Content-Type", "text/plain; charset=UTF-8");
        }
        headers = this.mergeHeaders(headers);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry header : headers.entrySet()) {
                reqBuilder.setHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        return boundary != null || data != null ? this.postStream(reqBuilder, boundary, sql, data, tables) : this.postString(reqBuilder, sql);
    }

    @Override
    public boolean ping(int timeout) {
        String response = (String)((Object)this.config.getOption(ClickHouseHttpOption.DEFAULT_RESPONSE));
        try {
            HttpResponse<String> r = this.httpClient.send(this.pingRequest, HttpResponse.BodyHandlers.ofString());
            return r.statusCode() == 200 && response.equals(r.body());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            log.debug((Object)"Failed to ping server: ", e.getMessage());
        }
        return false;
    }

    @Override
    public void close() {
    }
}

