/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseCityHash;
import com.clickhouse.client.internal.jpountz.lz4.LZ4Factory;
import com.clickhouse.client.internal.jpountz.lz4.LZ4FastDecompressor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ClickHouseLZ4InputStream
extends ClickHouseInputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    static final byte MAGIC = -126;
    static final int HEADER_LENGTH = 25;
    private final LZ4FastDecompressor decompressor = factory.fastDecompressor();
    private final InputStream stream;
    private final byte[] header;
    private byte[] currentBlock;
    private int position;

    private boolean checkNext() throws IOException {
        if (!this.closed && this.position >= this.currentBlock.length) {
            this.currentBlock = this.readNextBlock();
        }
        return this.currentBlock.length > 0;
    }

    private byte[] readNextBlock() throws IOException {
        this.position = 0;
        if (!this.readFully(this.header, 0, 25)) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        if (this.header[16] != -126) {
            throw new IOException(ClickHouseUtils.format("Magic is not correct - expect [%d] but got [%d]", (byte)-126, this.header[16]));
        }
        int compressedSizeWithHeader = BinaryStreamUtils.toInt32(this.header, 17);
        int uncompressedSize = BinaryStreamUtils.toInt32(this.header, 21);
        int offset = 9;
        byte[] block = new byte[compressedSizeWithHeader];
        block[0] = this.header[16];
        BinaryStreamUtils.setInt32(block, 1, compressedSizeWithHeader);
        BinaryStreamUtils.setInt32(block, 5, uncompressedSize);
        if (!this.readFully(block, offset, compressedSizeWithHeader - offset)) {
            throw new EOFException();
        }
        long[] real = ClickHouseCityHash.cityHash128(block, 0, block.length);
        if (real[0] != BinaryStreamUtils.toInt64(this.header, 0) || real[1] != BinaryStreamUtils.toInt64(this.header, 8)) {
            throw new IllegalArgumentException("Checksum doesn't match: corrupted data.");
        }
        byte[] decompressed = new byte[uncompressedSize];
        this.decompressor.decompress(block, offset, decompressed, 0, uncompressedSize);
        return decompressed;
    }

    private boolean readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            if (n == 0) {
                return false;
            }
            throw new EOFException();
        }
        return true;
    }

    public ClickHouseLZ4InputStream(InputStream stream) {
        this(stream, null);
    }

    public ClickHouseLZ4InputStream(InputStream stream, Runnable afterClose) {
        super(afterClose);
        this.stream = ClickHouseChecker.nonNull(stream, "InputStream");
        this.header = new byte[25];
        this.currentBlock = ClickHouseByteBuffer.EMPTY_BYTES;
        this.position = 0;
        this.closed = false;
    }

    @Override
    public int peek() throws IOException {
        return this.checkNext() ? 0xFF & this.currentBlock[this.position] : -1;
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        int remain = this.currentBlock.length - this.position;
        if (remain > 0) {
            output.write(this.currentBlock, this.position, remain);
            this.position = this.currentBlock.length;
            count += (long)remain;
        }
        while (this.checkNext()) {
            output.write(this.currentBlock);
            count += (long)this.currentBlock.length;
        }
        return count;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.checkNext()) {
            this.closeQuietly();
            throw new EOFException();
        }
        return this.currentBlock[this.position++];
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int estimated = this.currentBlock.length - this.position;
        if (estimated == 0 && this.checkNext()) {
            estimated = this.currentBlock.length - this.position;
        }
        return estimated;
    }

    @Override
    public int read() throws IOException {
        return this.checkNext() ? 0xFF & this.currentBlock[this.position++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copied;
        int toCopy;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.checkNext()) {
            return -1;
        }
        for (copied = 0; copied != len; copied += toCopy) {
            toCopy = Math.min(this.currentBlock.length - this.position, len - copied);
            System.arraycopy(this.currentBlock, this.position, b, off, toCopy);
            this.position += toCopy;
            off += toCopy;
            if (this.checkNext()) continue;
            break;
        }
        return copied;
    }

    @Override
    public ClickHouseByteBuffer read(int len) throws IOException {
        if (len <= 0) {
            this.byteBuffer.reset();
        } else {
            if (!this.checkNext()) {
                throw new EOFException();
            }
            int newLimit = this.position + len;
            if (this.currentBlock.length >= newLimit) {
                this.byteBuffer.update(this.currentBlock, this.position, len);
                this.position = newLimit;
            } else {
                this.byteBuffer.update(this.readBytes(len));
            }
        }
        return this.byteBuffer;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.stream.close();
            }
            finally {
                super.close();
            }
        }
    }
}

