/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ClickHouseHttpResponse
extends ClickHouseInputStream {
    private final ClickHouseHttpConnection connection;
    private final ClickHouseInputStream input;
    protected final String serverDisplayName;
    protected final String queryId;
    protected final ClickHouseFormat format;
    protected final TimeZone timeZone;
    protected final ClickHouseResponseSummary summary;
    private boolean closed;

    private static long getLongValue(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    protected ClickHouseConfig getConfig(ClickHouseRequest<?> request) {
        ClickHouseConfig config = request.getConfig();
        if (this.format != null && this.format != config.getFormat()) {
            HashMap<ClickHouseClientOption, ClickHouseFormat> options = new HashMap<ClickHouseClientOption, ClickHouseFormat>();
            options.putAll(config.getAllOptions());
            options.put(ClickHouseClientOption.FORMAT, this.format);
            config = new ClickHouseConfig(options, config.getDefaultCredentials(), config.getNodeSelector(), (Object)config.getMetricRegistry());
        }
        return config;
    }

    public ClickHouseHttpResponse(ClickHouseHttpConnection connection, ClickHouseInputStream input, String serverDisplayName, String queryId, String summary, ClickHouseFormat format, TimeZone timeZone) {
        if (connection == null || input == null) {
            throw new IllegalArgumentException("Non-null connection and input stream are required");
        }
        this.connection = connection;
        this.input = input;
        this.serverDisplayName = !ClickHouseChecker.isNullOrEmpty((CharSequence)serverDisplayName) ? serverDisplayName : connection.server.getHost();
        this.queryId = !ClickHouseChecker.isNullOrEmpty((CharSequence)queryId) ? queryId : "";
        Map map = (Map)ClickHouseUtils.parseJson((String)(!ClickHouseChecker.isNullOrEmpty((CharSequence)summary) ? summary : "{}"));
        this.summary = new ClickHouseResponseSummary(new ClickHouseResponseSummary.Progress(ClickHouseHttpResponse.getLongValue(map, "read_rows"), ClickHouseHttpResponse.getLongValue(map, "read_bytes"), ClickHouseHttpResponse.getLongValue(map, "total_rows_to_read"), ClickHouseHttpResponse.getLongValue(map, "written_rows"), ClickHouseHttpResponse.getLongValue(map, "written_bytes")), null);
        this.format = format != null ? format : connection.config.getFormat();
        this.timeZone = timeZone != null ? timeZone : connection.config.getServerTimeZone();
        this.closed = false;
    }

    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    public int read() throws IOException {
        return this.input.read();
    }

    public int available() throws IOException {
        return this.input.available();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        IOException error = null;
        try {
            this.input.close();
        }
        catch (IOException e) {
            error = e;
        }
        this.closed = true;
        if (!this.connection.isReusable()) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }

    public byte[] readBytes(int length) throws IOException {
        return this.input.readBytes(length);
    }

    public String readString(int byteLength, Charset charset) throws IOException {
        return this.input.readString(byteLength, charset);
    }
}

