/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.metrics.export;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.opencensus.metrics.export.MetricProducer;
import com.clickhouse.client.internal.opencensus.metrics.export.MetricProducerManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetricProducerManagerImpl
extends MetricProducerManager {
    private volatile Set<MetricProducer> metricProducers = Collections.unmodifiableSet(new LinkedHashSet());

    @Override
    public synchronized void add(MetricProducer metricProducer) {
        Preconditions.checkNotNull(metricProducer, "metricProducer");
        LinkedHashSet<MetricProducer> newMetricProducers = new LinkedHashSet<MetricProducer>(this.metricProducers);
        if (!newMetricProducers.add(metricProducer)) {
            return;
        }
        this.metricProducers = Collections.unmodifiableSet(newMetricProducers);
    }

    @Override
    public synchronized void remove(MetricProducer metricProducer) {
        Preconditions.checkNotNull(metricProducer, "metricProducer");
        LinkedHashSet<MetricProducer> newMetricProducers = new LinkedHashSet<MetricProducer>(this.metricProducers);
        if (!newMetricProducers.remove(metricProducer)) {
            return;
        }
        this.metricProducers = Collections.unmodifiableSet(newMetricProducers);
    }

    @Override
    public Set<MetricProducer> getAllMetricProducer() {
        return this.metricProducers;
    }
}

