/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseShortValue
implements ClickHouseValue {
    private boolean isNull;
    private short value;

    public static ClickHouseShortValue ofNull() {
        return ClickHouseShortValue.ofNull(null);
    }

    public static ClickHouseShortValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseShortValue ? ((ClickHouseShortValue)ref).set(true, (short)0) : new ClickHouseShortValue(true, 0);
    }

    public static ClickHouseShortValue of(short value) {
        return ClickHouseShortValue.of(null, value);
    }

    public static ClickHouseShortValue of(int value) {
        return ClickHouseShortValue.of(null, (short)value);
    }

    public static ClickHouseShortValue of(Number value) {
        return value == null ? ClickHouseShortValue.ofNull(null) : ClickHouseShortValue.of(null, value.shortValue());
    }

    public static ClickHouseShortValue of(ClickHouseValue ref, short value) {
        return ref instanceof ClickHouseShortValue ? ((ClickHouseShortValue)ref).set(false, value) : new ClickHouseShortValue(false, value);
    }

    protected ClickHouseShortValue(boolean isNull, short value) {
        this.set(isNull, value);
    }

    protected ClickHouseShortValue set(boolean isNull, short value) {
        this.isNull = isNull;
        this.value = isNull ? (short)0 : value;
        return this;
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public ClickHouseShortValue copy(boolean deep) {
        return new ClickHouseShortValue(this.isNull, this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInteger() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNull ? null : BigDecimal.valueOf(this.value, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Short.valueOf(this.getValue());
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNull) {
            return null;
        }
        String str = String.valueOf(this.value);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseShortValue resetToNullOrEmpty() {
        return this.set(true, (short)0);
    }

    @Override
    public String toSqlExpression() {
        return this.isNullOrEmpty() ? "NULL" : String.valueOf(this.value);
    }

    @Override
    public ClickHouseShortValue update(boolean value) {
        return this.set(false, value ? (short)1 : 0);
    }

    @Override
    public ClickHouseShortValue update(char value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseShortValue update(short value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseShortValue update(int value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(long value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(float value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(double value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.shortValueExact());
    }

    @Override
    public ClickHouseShortValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.shortValueExact());
    }

    @Override
    public ClickHouseShortValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, (short)value.ordinal());
    }

    @Override
    public ClickHouseShortValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, Short.parseShort(value));
    }

    @Override
    public ClickHouseShortValue update(ClickHouseValue value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.asShort());
    }

    @Override
    public ClickHouseShortValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).shortValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asShort());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseShortValue v = (ClickHouseShortValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + this.value;
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

