/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseGeoPolygonValue;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class ClickHouseGeoMultiPolygonValue
extends ClickHouseObjectValue<double[][][][]> {
    static final double[][][][] EMPTY_VALUE = new double[0][][][];

    public static ClickHouseGeoMultiPolygonValue ofEmpty() {
        return ClickHouseGeoMultiPolygonValue.of(null, EMPTY_VALUE);
    }

    public static ClickHouseGeoMultiPolygonValue of(double[][][][] value) {
        return ClickHouseGeoMultiPolygonValue.of(null, value);
    }

    public static ClickHouseGeoMultiPolygonValue of(ClickHouseValue ref, double[][][][] value) {
        return ref instanceof ClickHouseGeoMultiPolygonValue ? ((ClickHouseGeoMultiPolygonValue)ref).set(value) : new ClickHouseGeoMultiPolygonValue(value);
    }

    protected static double[][][][] check(double[][][][] value) {
        int len = ClickHouseChecker.nonNull(value, "multi-polygon").length;
        for (int i = 0; i < len; ++i) {
            ClickHouseGeoPolygonValue.check(value[i]);
        }
        return value;
    }

    protected static String convert(double[][][][] value, int length) {
        StringBuilder builder = new StringBuilder().append('[');
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            builder.append(ClickHouseGeoPolygonValue.convert(value[i], 0)).append(',');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        String str = builder.append(']').toString();
        return length > 0 ? ClickHouseChecker.notWithDifferentLength(str, length) : str;
    }

    protected ClickHouseGeoMultiPolygonValue(double[][][][] value) {
        super(value);
    }

    protected ClickHouseGeoMultiPolygonValue set(double[][][][] value) {
        return (ClickHouseGeoMultiPolygonValue)super.set(ClickHouseGeoMultiPolygonValue.check(value));
    }

    @Override
    public ClickHouseGeoMultiPolygonValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseGeoMultiPolygonValue((double[][][][])this.getValue());
        }
        double[][][][] value = (double[][][][])this.getValue();
        double[][][][] newValue = new double[value.length][][][];
        int index = 0;
        for (double[][][] v1 : value) {
            double[][][] nv1 = new double[v1.length][][];
            int i = 0;
            for (double[][] v2 : v1) {
                double[][] nv2 = new double[v2.length][];
                int j = 0;
                for (double[] v3 : v2) {
                    nv2[j++] = Arrays.copyOf(v3, v3.length);
                }
                nv1[i++] = nv2;
            }
            newValue[index++] = nv1;
        }
        return new ClickHouseGeoMultiPolygonValue(newValue);
    }

    @Override
    public Object[] asArray() {
        return (Object[])this.getValue();
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) {
        double[][][][] v = (double[][][][])this.getValue();
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), v.length);
        int index = 0;
        for (double[][][] d : v) {
            array[index++] = clazz.cast(d);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int index = 1;
        for (double[][][] d : (double[][][][])this.getValue()) {
            map.put(keyClass.cast(index++), valueClass.cast(d));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        return ClickHouseGeoMultiPolygonValue.convert((double[][][][])this.getValue(), length);
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((double[][][][])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue resetToNullOrEmpty() {
        this.set(EMPTY_VALUE);
        return this;
    }

    @Override
    public String toSqlExpression() {
        return ClickHouseGeoMultiPolygonValue.convert((double[][][][])this.getValue(), 0);
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(boolean value) {
        throw this.newUnsupportedException("boolean", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(boolean[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{{value[0] ? 1.0 : 0.0, value[1] ? 0.0 : 1.0}}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(char value) {
        throw this.newUnsupportedException("char", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(char[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{{value[0], value[1]}}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(byte value) {
        throw this.newUnsupportedException("byte", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(byte[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{{value[0], value[1]}}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(short value) {
        throw this.newUnsupportedException("short", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(short[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{{value[0], value[1]}}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(int value) {
        throw this.newUnsupportedException("int", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(int[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{{value[0], value[1]}}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(long value) {
        throw this.newUnsupportedException("long", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(long[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{{value[0], value[1]}}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(float value) {
        throw this.newUnsupportedException("float", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(float[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{{value[0], value[1]}}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(double value) {
        throw this.newUnsupportedException("double", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(double[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][][][]{new double[][][]{new double[][]{value}}});
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(BigInteger value) {
        throw this.newUnsupportedException("BigInteger", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(BigDecimal value) {
        throw this.newUnsupportedException("BigDecimal", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Enum<?> value) {
        throw this.newUnsupportedException("Enum", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Inet4Address value) {
        throw this.newUnsupportedException("Inet4Address", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Inet6Address value) {
        throw this.newUnsupportedException("Inet6Address", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(LocalDate value) {
        throw this.newUnsupportedException("Date", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(LocalTime value) {
        throw this.newUnsupportedException("Time", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(LocalDateTime value) {
        throw this.newUnsupportedException("DateTime", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Collection<?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[][][][]{new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}}});
        } else {
            this.set(new double[][][][]{new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Enumeration<?> value) {
        if (value == null || !value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value.nextElement();
        if (!value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v2 = value.nextElement();
        if (value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        if (v1 instanceof Number) {
            this.set(new double[][][][]{new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}}});
        } else {
            this.set(new double[][][][]{new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Map<?, ?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.values().iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[][][][]{new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}}});
        } else {
            this.set(new double[][][][]{new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(String value) {
        throw this.newUnsupportedException("String", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(UUID value) {
        throw this.newUnsupportedException("UUID", "MultiPolygon");
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value instanceof ClickHouseGeoMultiPolygonValue) {
            this.set((double[][][][])((ClickHouseGeoMultiPolygonValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Object[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value[0];
        Object v2 = value[1];
        if (v1 instanceof Number) {
            this.set(new double[][][][]{new double[][][]{new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}}}});
        } else {
            this.set(new double[][][][]{new double[][][]{new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}}}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoMultiPolygonValue update(Object value) {
        if (value instanceof double[][][][]) {
            this.update((double[])value);
        } else {
            super.update(value);
        }
        return this;
    }
}

