/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseByteValue
implements ClickHouseValue {
    private boolean isNull;
    private byte value;

    public static ClickHouseByteValue ofNull() {
        return ClickHouseByteValue.ofNull(null);
    }

    public static ClickHouseByteValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseByteValue ? ((ClickHouseByteValue)ref).set(true, (byte)0) : new ClickHouseByteValue(true, 0);
    }

    public static ClickHouseByteValue of(byte value) {
        return ClickHouseByteValue.of(null, value);
    }

    public static ClickHouseByteValue of(int value) {
        return ClickHouseByteValue.of(null, (byte)value);
    }

    public static ClickHouseByteValue of(Number value) {
        return value == null ? ClickHouseByteValue.ofNull(null) : ClickHouseByteValue.of(null, value.byteValue());
    }

    public static ClickHouseByteValue of(ClickHouseValue ref, byte value) {
        return ref instanceof ClickHouseByteValue ? ((ClickHouseByteValue)ref).set(false, value) : new ClickHouseByteValue(false, value);
    }

    protected ClickHouseByteValue(boolean isNull, byte value) {
        this.set(isNull, value);
    }

    protected ClickHouseByteValue set(boolean isNull, byte value) {
        this.isNull = isNull;
        this.value = isNull ? (byte)0 : value;
        return this;
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public ClickHouseByteValue copy(boolean deep) {
        return new ClickHouseByteValue(this.isNull, this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInteger() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNull ? null : BigDecimal.valueOf(this.value, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Byte.valueOf(this.value);
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNull) {
            return null;
        }
        String str = String.valueOf(this.value);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseByteValue resetToNullOrEmpty() {
        return this.set(true, (byte)0);
    }

    @Override
    public String toSqlExpression() {
        return this.isNull ? "NULL" : String.valueOf(this.value);
    }

    @Override
    public ClickHouseByteValue update(char value) {
        return this.set(false, (byte)value);
    }

    @Override
    public ClickHouseByteValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseByteValue update(short value) {
        return this.set(false, (byte)value);
    }

    @Override
    public ClickHouseByteValue update(int value) {
        return this.set(false, (byte)value);
    }

    @Override
    public ClickHouseByteValue update(long value) {
        return this.set(false, (byte)value);
    }

    @Override
    public ClickHouseByteValue update(float value) {
        return this.set(false, (byte)value);
    }

    @Override
    public ClickHouseByteValue update(double value) {
        return this.set(false, (byte)value);
    }

    @Override
    public ClickHouseByteValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.byteValueExact());
    }

    @Override
    public ClickHouseByteValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.byteValueExact());
    }

    @Override
    public ClickHouseByteValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, (byte)value.ordinal());
    }

    @Override
    public ClickHouseByteValue update(String value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, Byte.parseByte(value));
    }

    @Override
    public ClickHouseByteValue update(ClickHouseValue value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.asByte());
    }

    @Override
    public ClickHouseByteValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).byteValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asByte());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseByteValue v = (ClickHouseByteValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + this.value;
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

