/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class ClickHouseRequest<SelfT extends ClickHouseRequest<SelfT>>
implements Serializable {
    private static final String TYPE_EXTERNAL_TABLE = "ExternalTable";
    private static final long serialVersionUID = 4990313525960702287L;
    private final boolean sealed;
    private transient ClickHouseClient client;
    protected final ClickHouseConfig clientConfig;
    protected final Function<ClickHouseNodeSelector, ClickHouseNode> server;
    protected final transient List<ClickHouseExternalTable> externalTables;
    protected final Map<ClickHouseOption, Serializable> options;
    protected final Map<String, Serializable> settings;
    protected final Map<String, String> namedParameters;
    protected transient CompletableFuture<InputStream> input;
    protected String queryId;
    protected String sessionId;
    protected String sql;
    protected ClickHouseParameterizedQuery preparedQuery;
    protected transient ClickHouseConfig config;
    protected transient List<String> statements;

    protected ClickHouseRequest(ClickHouseClient client, Function<ClickHouseNodeSelector, ClickHouseNode> server, boolean sealed) {
        if (client == null || server == null) {
            throw new IllegalArgumentException("Non-null client and server are required");
        }
        this.client = client;
        this.clientConfig = client.getConfig();
        this.server = server::apply;
        this.sealed = sealed;
        this.externalTables = new LinkedList<ClickHouseExternalTable>();
        this.options = new HashMap<ClickHouseOption, Serializable>();
        this.settings = new LinkedHashMap<String, Serializable>();
        this.namedParameters = new HashMap<String, String>();
    }

    protected void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException("Sealed request is immutable");
        }
    }

    protected ClickHouseClient getClient() {
        if (this.client == null) {
            this.client = ClickHouseClient.builder().config(this.clientConfig).build();
        }
        return this.client;
    }

    protected String getQuery() {
        return this.sql;
    }

    protected void resetCache() {
        if (this.config != null) {
            this.config = null;
        }
        if (this.statements != null) {
            this.statements = null;
        }
    }

    public ClickHouseRequest<SelfT> copy() {
        ClickHouseRequest<SelfT> req = new ClickHouseRequest<SelfT>(this.getClient(), this.server, false);
        req.externalTables.addAll(this.externalTables);
        req.options.putAll(this.options);
        req.settings.putAll(this.settings);
        req.namedParameters.putAll(this.namedParameters);
        req.input = this.input;
        req.queryId = this.queryId;
        req.sessionId = this.sessionId;
        req.sql = this.sql;
        req.preparedQuery = this.preparedQuery;
        return req;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean hasInputStream() {
        return this.input != null || !this.externalTables.isEmpty();
    }

    public final ClickHouseNode getServer() {
        return this.server.apply(this.getConfig().getNodeSelector());
    }

    public ClickHouseConfig getConfig() {
        if (this.config == null) {
            if (this.options.isEmpty()) {
                this.config = this.clientConfig;
            } else {
                HashMap<ClickHouseOption, Serializable> merged = new HashMap<ClickHouseOption, Serializable>();
                merged.putAll(this.clientConfig.getAllOptions());
                merged.putAll(this.options);
                this.config = new ClickHouseConfig(merged, this.clientConfig.getDefaultCredentials(), this.clientConfig.getNodeSelector(), this.clientConfig.getMetricRegistry().orElse(null));
            }
        }
        return this.config;
    }

    public Optional<InputStream> getInputStream() {
        try {
            return Optional.ofNullable(this.input != null ? this.input.get() : null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
    }

    public List<ClickHouseExternalTable> getExternalTables() {
        return Collections.unmodifiableList(this.externalTables);
    }

    public ClickHouseFormat getFormat() {
        return this.getConfig().getFormat();
    }

    public Optional<String> getQueryId() {
        return ClickHouseChecker.isNullOrEmpty(this.queryId) ? Optional.empty() : Optional.of(this.queryId);
    }

    public ClickHouseParameterizedQuery getPreparedQuery() {
        if (this.preparedQuery == null) {
            this.preparedQuery = ClickHouseParameterizedQuery.of(this.getConfig(), this.getQuery());
        }
        return this.preparedQuery;
    }

    public Map<String, Object> getSettings() {
        return Collections.unmodifiableMap(this.settings);
    }

    public Optional<String> getSessionId() {
        return ClickHouseChecker.isNullOrEmpty(this.sessionId) ? Optional.empty() : Optional.of(this.sessionId);
    }

    public List<String> getStatements() {
        return this.getStatements(true);
    }

    public List<String> getStatements(boolean withSettings) {
        if (this.statements == null) {
            String stmt;
            this.statements = new ArrayList<String>();
            if (withSettings) {
                for (Map.Entry<String, Serializable> entry : this.settings.entrySet()) {
                    Serializable value = entry.getValue();
                    StringBuilder sb = new StringBuilder().append("SET ").append(entry.getKey()).append('=');
                    if (value instanceof String) {
                        sb.append('\'').append(value).append('\'');
                    } else if (value instanceof Boolean) {
                        sb.append((Boolean)value != false ? 1 : 0);
                    } else {
                        sb.append(value);
                    }
                    this.statements.add(sb.toString());
                }
            }
            if (!ClickHouseChecker.isNullOrEmpty(stmt = this.getQuery())) {
                StringBuilder builder = new StringBuilder();
                if (this.preparedQuery == null) {
                    ClickHouseParameterizedQuery.apply(builder, stmt, this.namedParameters);
                } else {
                    this.preparedQuery.apply(builder, this.namedParameters);
                }
                this.statements.add(builder.toString());
            }
        }
        return Collections.unmodifiableList(this.statements);
    }

    public SelfT compressServerResponse(boolean enable) {
        return this.compressServerResponse(enable, null, (Integer)ClickHouseClientOption.COMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT compressServerResponse(boolean enable, ClickHouseCompression compressAlgorithm) {
        return this.compressServerResponse(enable, compressAlgorithm, (Integer)ClickHouseClientOption.COMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT compressServerResponse(boolean enable, ClickHouseCompression compressAlgorithm, int compressLevel) {
        this.checkSealed();
        if (compressAlgorithm == null) {
            ClickHouseCompression clickHouseCompression = compressAlgorithm = enable ? (ClickHouseCompression)((Object)ClickHouseClientOption.COMPRESS_ALGORITHM.getEffectiveDefaultValue()) : ClickHouseCompression.NONE;
        }
        if (compressLevel < 0) {
            compressLevel = 0;
        } else if (compressLevel > 9) {
            compressLevel = 9;
        }
        Serializable oldSwitch = this.options.put(ClickHouseClientOption.COMPRESS, Boolean.valueOf(enable));
        Serializable oldAlgorithm = this.options.put(ClickHouseClientOption.COMPRESS_ALGORITHM, (Serializable)((Object)compressAlgorithm));
        Serializable oldLevel = this.options.put(ClickHouseClientOption.COMPRESS_LEVEL, Integer.valueOf(compressLevel));
        if (!(oldSwitch != null && oldSwitch.equals(enable) && oldAlgorithm != null && oldAlgorithm.equals((Object)compressAlgorithm) && oldLevel != null && oldLevel.equals(compressLevel))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT decompressClientRequest(boolean enable) {
        return this.decompressClientRequest(enable, null, (Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT decompressClientRequest(boolean enable, ClickHouseCompression compressAlgorithm) {
        return this.decompressClientRequest(enable, compressAlgorithm, (Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT decompressClientRequest(boolean enable, ClickHouseCompression compressAlgorithm, int compressLevel) {
        this.checkSealed();
        if (compressAlgorithm == null) {
            ClickHouseCompression clickHouseCompression = compressAlgorithm = enable ? (ClickHouseCompression)((Object)ClickHouseClientOption.DECOMPRESS_ALGORITHM.getEffectiveDefaultValue()) : ClickHouseCompression.NONE;
        }
        if (compressLevel < 0) {
            compressLevel = 0;
        } else if (compressLevel > 9) {
            compressLevel = 9;
        }
        Serializable oldSwitch = this.options.put(ClickHouseClientOption.DECOMPRESS, Boolean.valueOf(enable));
        Serializable oldAlgorithm = this.options.put(ClickHouseClientOption.DECOMPRESS_ALGORITHM, (Serializable)((Object)compressAlgorithm));
        Serializable oldLevel = this.options.put(ClickHouseClientOption.DECOMPRESS_LEVEL, Integer.valueOf(compressLevel));
        if (!(oldSwitch != null && oldSwitch.equals(enable) && oldAlgorithm != null && oldAlgorithm.equals((Object)compressAlgorithm) && oldLevel != null && oldLevel.equals(compressLevel))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT addExternal(ClickHouseExternalTable table) {
        this.checkSealed();
        if (this.externalTables.add(ClickHouseChecker.nonNull(table, TYPE_EXTERNAL_TABLE))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT external(ClickHouseExternalTable table, ClickHouseExternalTable ... more) {
        this.checkSealed();
        this.externalTables.clear();
        this.externalTables.add(ClickHouseChecker.nonNull(table, TYPE_EXTERNAL_TABLE));
        if (more != null) {
            for (ClickHouseExternalTable e : more) {
                this.externalTables.add(ClickHouseChecker.nonNull(e, TYPE_EXTERNAL_TABLE));
            }
        }
        return (SelfT)this;
    }

    public SelfT external(Collection<ClickHouseExternalTable> tables) {
        this.checkSealed();
        this.externalTables.clear();
        if (tables != null) {
            for (ClickHouseExternalTable e : tables) {
                this.externalTables.add(ClickHouseChecker.nonNull(e, TYPE_EXTERNAL_TABLE));
            }
        }
        return (SelfT)this;
    }

    public SelfT format(ClickHouseFormat format) {
        this.checkSealed();
        Serializable oldValue = this.options.put(ClickHouseClientOption.FORMAT, (Serializable)((Object)(format != null ? format : (ClickHouseFormat)((Object)ClickHouseDefaults.FORMAT.getEffectiveDefaultValue()))));
        if (oldValue == null || !oldValue.equals((Object)format)) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT option(ClickHouseOption option, Serializable value) {
        this.checkSealed();
        Serializable oldValue = this.options.put(ClickHouseChecker.nonNull(option, "option"), ClickHouseChecker.nonNull(value, "value"));
        if (oldValue == null || !oldValue.equals(value)) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT options(Map<ClickHouseOption, Serializable> options) {
        this.checkSealed();
        this.options.clear();
        if (options != null) {
            this.options.putAll(options);
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT options(Properties options) {
        this.checkSealed();
        this.options.clear();
        if (options != null) {
            for (Map.Entry<Object, Object> e : options.entrySet()) {
                ClickHouseClientOption o;
                Object key = e.getKey();
                Object value = e.getValue();
                if (key == null || value == null || (o = ClickHouseClientOption.fromKey(key.toString())) == null) continue;
                this.options.put(o, ClickHouseOption.fromString(value.toString(), o.getValueType()));
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Collection<String> values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && !values.isEmpty()) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (String v : values) {
                this.namedParameters.put(names.get(index), v);
                if (++index < size) continue;
                break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(ClickHouseValue value, ClickHouseValue ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        if (value != null) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            this.namedParameters.put(names.get(index++), value.toSqlExpression());
            if (more != null && more.length > 0) {
                for (ClickHouseValue v : more) {
                    if (index >= size) break;
                    this.namedParameters.put(names.get(index++), v != null ? v.toSqlExpression() : "NULL");
                }
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(ClickHouseValue[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (ClickHouseValue v : values) {
                this.namedParameters.put(names.get(index), v != null ? v.toSqlExpression() : "NULL");
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(String value, String ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        List<String> names = this.getPreparedQuery().getParameters();
        int size = names.size();
        int index = 0;
        this.namedParameters.put(names.get(index++), value);
        if (more != null && more.length > 0) {
            for (String v : more) {
                if (index >= size) break;
                this.namedParameters.put(names.get(index++), v);
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(String[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (String v : values) {
                this.namedParameters.put(names.get(index), v);
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Object value, Object ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        List<String> names = this.getPreparedQuery().getParameters();
        int size = names.size();
        int index = 0;
        this.namedParameters.put(names.get(index++), ClickHouseValues.convertToSqlExpression(value));
        if (more != null && more.length > 0) {
            for (Object v : more) {
                if (index >= size) break;
                this.namedParameters.put(names.get(index++), ClickHouseValues.convertToSqlExpression(v));
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Object[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (Object v : values) {
                this.namedParameters.put(names.get(index), ClickHouseValues.convertToSqlExpression(v));
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Map<String, String> namedParams) {
        this.checkSealed();
        this.namedParameters.clear();
        if (namedParams != null) {
            this.namedParameters.putAll(namedParams);
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT query(ClickHouseParameterizedQuery query) {
        return this.query(query, null);
    }

    public SelfT query(String sql) {
        return this.query(sql, null);
    }

    public SelfT query(ClickHouseParameterizedQuery query, String queryId) {
        this.checkSealed();
        if (!ClickHouseChecker.nonNull(query, "query").equals(this.preparedQuery)) {
            this.preparedQuery = query;
            this.sql = query.getOriginalQuery();
            this.resetCache();
        }
        this.queryId = queryId;
        return (SelfT)this;
    }

    public SelfT query(String sql, String queryId) {
        this.checkSealed();
        if (!ClickHouseChecker.nonBlank(sql, "sql").equals(this.sql)) {
            this.sql = sql;
            this.preparedQuery = null;
            this.resetCache();
        }
        this.queryId = queryId;
        return (SelfT)this;
    }

    public SelfT clearSession() {
        this.checkSealed();
        boolean changed = this.sessionId != null;
        this.sessionId = null;
        Serializable oldValue = null;
        oldValue = this.options.remove(ClickHouseClientOption.SESSION_CHECK);
        changed = changed || oldValue != null;
        oldValue = this.options.remove(ClickHouseClientOption.SESSION_TIMEOUT);
        boolean bl = changed = changed || oldValue != null;
        if (changed) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT session(String sessionId) {
        return this.session(sessionId, null, null);
    }

    public SelfT session(String sessionId, Boolean check) {
        return this.session(sessionId, check, null);
    }

    public SelfT session(String sessionId, Integer timeout) {
        return this.session(sessionId, null, timeout);
    }

    public SelfT session(String sessionId, Boolean check, Integer timeout) {
        this.checkSealed();
        boolean changed = !Objects.equals(this.sessionId, sessionId);
        this.sessionId = sessionId;
        Serializable oldValue = null;
        if (check != null) {
            oldValue = this.options.put(ClickHouseClientOption.SESSION_CHECK, check);
            boolean bl = changed = oldValue == null || !oldValue.equals(check);
        }
        if (timeout != null) {
            oldValue = this.options.put(ClickHouseClientOption.SESSION_TIMEOUT, timeout);
            boolean bl = changed = changed || oldValue == null || !oldValue.equals(timeout);
        }
        if (changed) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT set(String setting, Serializable value) {
        this.checkSealed();
        Serializable oldValue = this.settings.put(ClickHouseChecker.nonBlank(setting, "setting"), ClickHouseChecker.nonNull(value, "value"));
        if (oldValue == null || !oldValue.equals(value)) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT set(String setting, String value) {
        this.checkSealed();
        return this.set(setting, (Serializable)((Object)ClickHouseUtils.escape(value, '\'')));
    }

    public SelfT table(String table) {
        return this.table(table, null);
    }

    public SelfT table(String table, String queryId) {
        return this.query("SELECT * FROM " + ClickHouseChecker.nonBlank(table, "table"), queryId);
    }

    public SelfT use(String database) {
        this.checkSealed();
        Serializable oldValue = this.options.put(ClickHouseClientOption.DATABASE, (Serializable)((Object)ClickHouseChecker.nonBlank(database, "database")));
        if (oldValue == null || !oldValue.equals(database)) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT removeExternal(ClickHouseExternalTable external) {
        this.checkSealed();
        if (this.externalTables.remove(ClickHouseChecker.nonNull(external, TYPE_EXTERNAL_TABLE))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT removeExternal(String name) {
        this.checkSealed();
        if (!ClickHouseChecker.isNullOrEmpty(name)) {
            boolean removed = false;
            Iterator<ClickHouseExternalTable> i = this.externalTables.iterator();
            while (i.hasNext()) {
                ClickHouseExternalTable e = i.next();
                if (!name.equals(e.getName())) continue;
                i.remove();
                removed = true;
            }
            if (removed) {
                this.resetCache();
            }
        }
        return (SelfT)this;
    }

    public SelfT removeOption(ClickHouseOption option) {
        this.checkSealed();
        if (this.options.remove(ClickHouseChecker.nonNull(option, "option")) != null) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT removeSetting(String setting) {
        this.checkSealed();
        if (this.settings.remove(ClickHouseChecker.nonBlank(setting, "setting")) != null) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT reset() {
        this.checkSealed();
        this.externalTables.clear();
        this.options.clear();
        this.settings.clear();
        this.namedParameters.clear();
        this.input = null;
        this.sql = null;
        this.preparedQuery = null;
        this.queryId = null;
        this.sessionId = null;
        this.resetCache();
        return (SelfT)this;
    }

    public ClickHouseRequest<SelfT> seal() {
        ClickHouseRequest<SelfT> req = this;
        if (!this.isSealed()) {
            req = new ClickHouseRequest<SelfT>(this.client, this.getServer(), true);
            req.externalTables.addAll(this.externalTables);
            req.options.putAll(this.options);
            req.settings.putAll(this.settings);
            req.namedParameters.putAll(this.namedParameters);
            req.input = this.input;
            req.queryId = this.queryId;
            req.sessionId = this.sessionId;
            req.sql = this.sql;
            req.preparedQuery = this.preparedQuery;
        }
        return req;
    }

    public Mutation write() {
        this.checkSealed();
        return new Mutation(this, false);
    }

    public CompletableFuture<ClickHouseResponse> execute() {
        return this.getClient().execute(this.isSealed() ? this : this.seal());
    }

    public static class Mutation
    extends ClickHouseRequest<Mutation> {
        protected Mutation(ClickHouseRequest<?> request, boolean sealed) {
            super(request.getClient(), request.server, sealed);
            this.options.putAll(request.options);
            this.settings.putAll(request.settings);
            this.sessionId = request.sessionId;
        }

        @Override
        protected String getQuery() {
            if (this.input != null && this.sql != null) {
                return this.sql + " FORMAT " + this.getFormat().name();
            }
            return super.getQuery();
        }

        @Override
        public Mutation format(ClickHouseFormat format) {
            if (!ClickHouseChecker.nonNull(format, "format").supportsInput()) {
                throw new IllegalArgumentException("Only input format is allowed for mutation.");
            }
            return (Mutation)super.format(format);
        }

        public Mutation data(String file) {
            return this.data(file, ClickHouseCompression.fromFileName(file));
        }

        public Mutation data(String file, ClickHouseCompression compression) {
            this.checkSealed();
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            if (compression == null || compression == ClickHouseCompression.NONE) {
                this.input = CompletableFuture.completedFuture(fileInput);
            }
            return this;
        }

        public Mutation data(InputStream input) {
            this.checkSealed();
            this.input = CompletableFuture.completedFuture(input);
            return this;
        }

        public CompletableFuture<ClickHouseResponse> send() {
            return this.getClient().execute(this.isSealed() ? this : this.seal());
        }

        @Override
        public Mutation table(String table, String queryId) {
            this.checkSealed();
            this.queryId = queryId;
            String sql = "INSERT INTO " + ClickHouseChecker.nonBlank(table, "table");
            if (!sql.equals(this.sql)) {
                this.sql = sql;
                this.preparedQuery = null;
                this.resetCache();
            }
            return this;
        }

        public Mutation seal() {
            Mutation req = this;
            if (!this.isSealed()) {
                req = new Mutation(this, true);
                req.externalTables.addAll(this.externalTables);
                req.options.putAll(this.options);
                req.settings.putAll(this.settings);
                req.namedParameters.putAll(this.namedParameters);
                req.input = this.input;
                req.queryId = this.queryId;
                req.sessionId = this.sessionId;
                req.sql = this.sql;
                req.preparedQuery = this.preparedQuery;
            }
            return req;
        }
    }
}

