/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseCompression;
import java.util.Locale;

public enum ClickHouseFormat {
    RowBinary(true, true, true, false, true),
    RowBinaryWithNames(true, true, true, true, true, RowBinary),
    RowBinaryWithNamesAndTypes(true, true, true, true, true, RowBinary),
    RowBinaryWithDefaults(true, true, true, true, true, RowBinary),
    TabSeparated(true, true, false, false, true),
    TabSeparatedRaw(true, true, false, false, true),
    TabSeparatedRawWithNames(true, true, false, true, true, TabSeparatedRaw),
    TabSeparatedRawWithNamesAndTypes(true, true, false, true, true, TabSeparatedRaw),
    TabSeparatedWithNames(true, true, false, true, true, TabSeparated),
    TabSeparatedWithNamesAndTypes(true, true, false, true, true, TabSeparated),
    Arrow(true, true, true, true, false),
    ArrowStream(true, true, true, true, false),
    Avro(true, true, true, true, false),
    AvroConfluent(true, false, true, false, false),
    CSV(true, true, false, false, true),
    CSVWithNames(true, true, false, true, true, CSV),
    CSVWithNamesAndTypes(true, true, false, true, true, CSV),
    CapnProto(true, false, true, false, false),
    CustomSeparated(true, true, false, false, true),
    CustomSeparatedWithNames(true, true, false, true, true, CustomSeparated),
    CustomSeparatedWithNamesAndTypes(true, true, false, true, true, CustomSeparated),
    CustomSeparatedIgnoreSpaces(true, false, false, false, true),
    CustomSeparatedIgnoreSpacesWithNames(true, false, false, true, true, CustomSeparatedIgnoreSpaces),
    CustomSeparatedIgnoreSpacesWithNamesAndTypes(true, false, false, true, true, CustomSeparatedIgnoreSpaces),
    HiveText(true, false, false, false, true),
    JSONCompactEachRow(true, true, false, false, true),
    JSONCompactEachRowWithNames(true, true, false, true, true),
    JSONCompactEachRowWithNamesAndTypes(true, true, false, true, true),
    JSON(false, true, false, false, false, JSONCompactEachRow),
    JSONAsObject(true, false, false, false, false),
    JSONAsString(true, false, false, false, false),
    JSONColumns(true, true, false, false, false),
    JSONColumnsWithMetadata(true, true, false, false, false),
    JSONCompact(false, true, false, false, false, JSONCompactEachRow),
    JSONCompactColumns(true, true, false, false, false),
    JSONCompactStringsEachRow(true, true, false, false, true),
    JSONCompactStringsEachRowWithNames(true, true, false, true, true, JSONCompactStringsEachRow),
    JSONCompactStringsEachRowWithNamesAndTypes(true, true, false, true, true, JSONCompactStringsEachRow),
    JSONCompactStrings(false, true, false, false, false, JSONCompactStringsEachRow),
    JSONEachRow(true, true, false, false, true),
    JSONEachRowWithProgress(false, true, false, false, true, JSONEachRow),
    JSONLines(true, true, false, false, true),
    NDJSON(true, true, true, true, true),
    JSONObjectEachRow(true, false, false, false, false),
    JSONStringsEachRow(true, true, false, false, true),
    JSONStringsEachRowWithProgress(false, true, false, false, true, JSONStringsEachRow),
    JSONStringEachRow(false, false, false, false, true, JSONStringsEachRow),
    JSONStrings(false, true, false, false, false, JSONStringsEachRow),
    LineAsString(true, false, false, false, true),
    LineAsStringWithNames(false, true, false, false, true, LineAsString),
    LineAsStringWithNamesAndTypes(false, true, false, false, true, LineAsString),
    Markdown(false, true, false, false, true),
    MsgPack(true, true, true, false, false),
    MySQLDump(true, false, false, false, true),
    MySQLWire(false, true, true, false, false),
    Native(true, true, true, true, false),
    Null(false, true, false, false, false),
    ODBCDriver2(false, true, true, false, false),
    ORC(true, true, true, true, false),
    Parquet(true, true, true, true, false),
    PostgreSQLWire(false, true, true, false, false),
    Pretty(false, true, false, false, false),
    PrettyCompact(false, true, false, false, false),
    PrettyCompactMonoBlock(false, true, false, false, false),
    PrettyCompactNoEscapes(false, true, false, false, false),
    PrettyMonoBlock(false, true, false, false, false),
    PrettyNoEscapes(false, true, false, false, false),
    PrettyNoEscapesMonoBlock(false, true, false, false, false),
    PrettySpace(false, true, false, false, false),
    PrettySpaceMonoBlock(false, true, false, false, false),
    PrettySpaceNoEscapes(false, true, false, false, false),
    PrettySpaceNoEscapesMonoBlock(false, true, false, false, false),
    Prometheus(false, true, false, false, true),
    Protobuf(true, true, true, true, false),
    ProtobufList(true, true, true, true, false),
    ProtobufSingle(true, true, true, true, false),
    RawBLOB(true, true, true, false, false),
    Regexp(true, false, false, false, false),
    SQLInsert(false, true, false, false, false),
    TSKV(true, true, false, false, false),
    TSV(true, true, false, false, true),
    TSVRaw(true, true, false, false, true),
    TSVRawWithNames(true, true, false, true, true, TSV),
    TSVRawWithNamesAndTypes(true, true, false, true, true, TSV),
    TSVWithNames(true, true, false, true, true, TSV),
    TSVWithNamesAndTypes(true, true, false, true, true, TSV),
    Template(true, true, false, true, true),
    TemplateIgnoreSpaces(true, false, false, true, true),
    Values(true, true, false, false, true),
    Vertical(false, true, false, false, false),
    XML(false, true, false, false, false);

    private final boolean input;
    private final boolean output;
    private final boolean binary;
    private final boolean header;
    private final boolean rowBased;
    private final ClickHouseFormat defaultInput;

    public static ClickHouseFormat fromFileName(String file) {
        ClickHouseCompression compression = ClickHouseCompression.fromFileName(file);
        if (compression != null) {
            file = file.substring(0, file.lastIndexOf(46));
        }
        ClickHouseFormat format = null;
        int index = 0;
        if (file != null && (index = file.lastIndexOf(46)) > 0) {
            String ext;
            switch (ext = file.substring(index + 1).toLowerCase(Locale.ROOT)) {
                case "arrow": {
                    format = Arrow;
                    break;
                }
                case "avro": {
                    format = Avro;
                    break;
                }
                case "capnp": {
                    format = CapnProto;
                    break;
                }
                case "csv": {
                    format = CSV;
                    break;
                }
                case "json": {
                    format = JSONEachRow;
                    break;
                }
                case "msgpack": {
                    format = MsgPack;
                    break;
                }
                case "orc": {
                    format = ORC;
                    break;
                }
                case "parquet": {
                    format = Parquet;
                    break;
                }
                case "pb": 
                case "proto": {
                    format = Protobuf;
                    break;
                }
                case "sql": {
                    format = MySQLDump;
                    break;
                }
                case "tsv": {
                    format = TSV;
                    break;
                }
                case "xml": {
                    format = XML;
                    break;
                }
            }
        }
        return format;
    }

    private ClickHouseFormat(boolean input, boolean output, boolean binary, boolean header, boolean rowBased) {
        this(input, output, binary, header, rowBased, null);
    }

    private ClickHouseFormat(boolean input, boolean output, boolean binary, boolean header, boolean rowBased, ClickHouseFormat defaultInputFormat) {
        this.input = input;
        this.output = output;
        this.binary = binary;
        this.header = output && header;
        this.rowBased = rowBased;
        if (defaultInputFormat != null) {
            this.defaultInput = defaultInputFormat;
        } else if (input) {
            this.defaultInput = this;
        } else {
            String typeName = binary ? "RowBinary" : "TabSeparated";
            try {
                this.defaultInput = (ClickHouseFormat)((Object)((Object)((Object)this)).getClass().getField(typeName).get(null));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to initialize format", e);
            }
        }
    }

    public boolean supportsInput() {
        return this.input;
    }

    public boolean supportsOutput() {
        return this.output;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isText() {
        return !this.binary;
    }

    public boolean hasHeader() {
        return this.header;
    }

    public boolean isRowBased() {
        return this.rowBased;
    }

    public ClickHouseFormat defaultInputFormat() {
        return this.defaultInput;
    }
}

