/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.IIOException;

public class DelegatedInputStream
extends ClickHouseInputStream {
    private final ClickHouseInputStream input;
    private final int timeout;
    private final CompletableFuture<Boolean> future;

    public DelegatedInputStream(ClickHousePassThruStream stream, ClickHouseInputStream input, OutputStream copyTo, Runnable postCloseAction) {
        super(stream, copyTo, postCloseAction);
        this.input = ClickHouseChecker.nonNull(input, "InputStream");
        this.timeout = 30000;
        this.future = CompletableFuture.completedFuture(true);
    }

    public DelegatedInputStream(ClickHouseDataConfig config, ClickHouseWriter writer) {
        super(null, null, null);
        if (writer == null) {
            throw new IllegalArgumentException("Non-null writer is required");
        }
        this.timeout = config != null ? config.getReadTimeout() : 30000;
        ClickHousePipedOutputStream stream = config != null ? ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config, null) : ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(4096, 0, this.timeout, null);
        this.input = stream.getInputStream();
        this.future = CompletableFuture.supplyAsync(() -> {
            try (ClickHousePipedOutputStream out = stream;){
                writer.write(out);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
            return true;
        });
    }

    @Override
    public int peek() throws IOException {
        return this.input.peek();
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        return this.input.pipe(output);
    }

    @Override
    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        return this.input.readCustom(reader);
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            try {
                this.future.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Custom writer was interrupted", e);
            }
            catch (TimeoutException e) {
                throw new IIOException(ClickHouseUtils.format("Custom writing timed out after %d milliseconds", this.timeout), e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof UncheckedIOException) {
                    throw ((UncheckedIOException)cause).getCause();
                }
                throw new IOException("Custom writing failure", cause);
            }
        }
        finally {
            try {
                super.close();
            }
            finally {
                this.input.close();
            }
        }
    }

    @Override
    public ClickHouseFile getUnderlyingFile() {
        return this.input.getUnderlyingFile();
    }

    @Override
    public ClickHousePassThruStream getUnderlyingStream() {
        return this.input.getUnderlyingStream();
    }

    @Override
    public boolean isClosed() {
        return this.input.isClosed();
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }
}

