/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseLoadBalancingPolicy;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeManager;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClickHouseNodes
implements ClickHouseNodeManager {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseNodes.class);
    private static final long serialVersionUID = 4931904980127690349L;
    private static final Map<String, ClickHouseNodes> cache = Collections.synchronizedMap(new WeakHashMap());
    private static final char[] separators = new char[]{'/', '?', '#'};
    protected final AtomicBoolean checking = new AtomicBoolean(false);
    protected final AtomicInteger index = new AtomicInteger(0);
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final int groupSize;
    protected final LinkedList<ClickHouseNode> nodes = new LinkedList();
    protected final LinkedList<ClickHouseNode> faultyNodes = new LinkedList();
    protected final AtomicReference<ScheduledFuture<?>> discoveryFuture = new AtomicReference<Object>(null);
    protected final AtomicReference<ScheduledFuture<?>> healthCheckFuture = new AtomicReference<Object>(null);
    protected final ClickHouseLoadBalancingPolicy policy;
    protected final ClickHouseNodeSelector selector;
    protected final boolean singleNode;
    protected final ClickHouseNode template;

    static ClickHouseNodes create(String endpoints, Map<?, ?> defaultOptions) {
        int index = endpoints.indexOf("://");
        String defaultProtocol = ((ClickHouseProtocol)((Object)ClickHouseDefaults.PROTOCOL.getEffectiveDefaultValue())).name();
        if (index > 0) {
            defaultProtocol = endpoints.substring(0, index);
            if (ClickHouseProtocol.fromUriScheme(defaultProtocol) == ClickHouseProtocol.ANY) {
                defaultProtocol = ClickHouseProtocol.ANY.name();
                index = 0;
            } else {
                index += 3;
            }
        } else {
            index = 0;
        }
        String defaultParams = "";
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        int stopChar = 44;
        int len = endpoints.length();
        for (int i = index; i < len; ++i) {
            char spec;
            int ch = endpoints.charAt(i);
            if (ch == 44 || Character.isWhitespace((char)ch)) {
                ++index;
                continue;
            }
            if (ch == 47 || ch == 63 || ch == 35) {
                defaultParams = endpoints.substring(i);
                break;
            }
            switch (ch) {
                case 40: {
                    stopChar = 41;
                    ++index;
                    break;
                }
                case 123: {
                    stopChar = 125;
                    ++index;
                    break;
                }
            }
            int endIndex = i;
            for (int j = i + 1; j < len; ++j) {
                ch = endpoints.charAt(j);
                if (ch != stopChar && !Character.isWhitespace((char)ch)) continue;
                endIndex = j;
                break;
            }
            if (endIndex > i) {
                list.add(endpoints.substring(index, endIndex).trim());
                i = endIndex;
                index = endIndex + 1;
                stopChar = 44;
                continue;
            }
            String last = endpoints.substring(index);
            int sepIndex = last.indexOf("://");
            int startIndex = sepIndex < 0 ? 0 : sepIndex + 3;
            char[] cArray = separators;
            int n = cArray.length;
            for (int j = 0; j < n && (sepIndex = last.indexOf(spec = cArray[j], startIndex)) <= 0; ++j) {
            }
            if (sepIndex > 0) {
                defaultParams = last.substring(sepIndex);
                list.add(last.substring(0, sepIndex).trim());
                break;
            }
            list.add(last.trim());
            break;
        }
        list.remove("");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No valid URI found, please try 'http://localhost:8123' or simply 'localhost:8123' if you don't know protocol");
        }
        if (list.size() == 1 && defaultParams.isEmpty()) {
            endpoints = defaultProtocol + "://" + (String)list.iterator().next();
            return new ClickHouseNodes(Collections.singletonList(ClickHouseNode.of(endpoints, defaultOptions)));
        }
        ClickHouseNode defaultNode = ClickHouseNode.of(defaultProtocol + "://localhost" + defaultParams, defaultOptions);
        LinkedList<ClickHouseNode> nodes = new LinkedList<ClickHouseNode>();
        for (String uri : list) {
            nodes.add(ClickHouseNode.of(uri, defaultNode));
        }
        return new ClickHouseNodes(nodes, defaultNode);
    }

    static List<ClickHouseNode> pickNodes(Collection<ClickHouseNode> source, ClickHouseNodeSelector selector, int groupSize) {
        ArrayList<ClickHouseNode> list;
        boolean hasSelector;
        boolean bl = hasSelector = selector != null && selector != ClickHouseNodeSelector.EMPTY;
        if (groupSize < 1) {
            if (hasSelector) {
                list = new LinkedList();
                for (ClickHouseNode node : source) {
                    if (!selector.match(node)) continue;
                    list.add(node);
                }
            } else {
                list = new ArrayList<ClickHouseNode>(source);
            }
        } else {
            list = new ArrayList(groupSize);
            int count = 0;
            for (ClickHouseNode node : source) {
                if (!hasSelector || selector.match(node)) {
                    list.add(node);
                    ++count;
                }
                if (count < groupSize) continue;
                break;
            }
        }
        return list;
    }

    static void pickNodes(Collection<ClickHouseNode> source, ClickHouseNodeSelector selector, Set<ClickHouseNode> target, int groupSize, long currentTime) {
        boolean hasSelector = selector != null && selector != ClickHouseNodeSelector.EMPTY;
        int count = target.size();
        for (ClickHouseNode node : source) {
            int interval;
            if (!(hasSelector && !selector.match(node) || (interval = node.config.getNodeCheckInterval()) >= 1 && currentTime - node.lastUpdateTime.get() < (long)interval)) {
                target.add(node);
                ++count;
            }
            if (groupSize <= 0 || count < groupSize) continue;
            break;
        }
    }

    public static String buildCacheKey(String uri, Map<?, ?> options) {
        TreeMap sorted;
        if (uri == null) {
            throw new IllegalArgumentException("Non-null URI required");
        }
        if ((uri = uri.trim()).isEmpty()) {
            throw new IllegalArgumentException("Non-blank URI required");
        }
        if (options == null || options.isEmpty()) {
            return uri;
        }
        if (options instanceof SortedMap) {
            sorted = (TreeMap)options;
        } else {
            sorted = new TreeMap();
            for (Map.Entry<?, ?> entry : options.entrySet()) {
                if (entry.getKey() == null) continue;
                sorted.put(entry.getKey(), entry.getValue());
            }
        }
        StringBuilder builder = new StringBuilder(uri).append('|');
        for (Map.Entry entry : sorted.entrySet()) {
            if (entry.getKey() == null) continue;
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append(',');
        }
        return builder.toString();
    }

    public static ClickHouseNodes of(String endpoints) {
        return ClickHouseNodes.of(endpoints, Collections.emptyMap());
    }

    public static ClickHouseNodes of(String endpoints, Map<?, ?> options) {
        return cache.computeIfAbsent(ClickHouseNodes.buildCacheKey(ClickHouseChecker.nonEmpty((String)endpoints, (String)"Endpoints"), options), k -> ClickHouseNodes.create(endpoints, options));
    }

    public static ClickHouseNodes of(String cacheKey, String endpoints, Map<?, ?> options) {
        if (ClickHouseChecker.isNullOrEmpty((CharSequence)cacheKey) || ClickHouseChecker.isNullOrEmpty((CharSequence)endpoints)) {
            throw new IllegalArgumentException("Non-empty cache key and endpoints are required");
        }
        return cache.computeIfAbsent(cacheKey, k -> ClickHouseNodes.create(endpoints, options));
    }

    ClickHouseNodes(Collection<ClickHouseNode> nodes) {
        this(nodes, nodes.iterator().next());
    }

    protected ClickHouseNodes(Collection<ClickHouseNode> nodes, ClickHouseNode template) {
        this.template = template;
        this.groupSize = template.config.getIntOption(ClickHouseClientOption.NODE_GROUP_SIZE);
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        ClickHouseNode.parseTags(template.config.getStrOption(ClickHouseClientOption.LOAD_BALANCING_TAGS), tags);
        this.policy = ClickHouseLoadBalancingPolicy.of(template.config.getStrOption(ClickHouseClientOption.LOAD_BALANCING_POLICY));
        this.selector = tags.isEmpty() ? ClickHouseNodeSelector.EMPTY : ClickHouseNodeSelector.of(null, tags);
        boolean autoDiscovery = false;
        for (ClickHouseNode n : nodes) {
            autoDiscovery = autoDiscovery || n.config.isAutoDiscovery();
            n.setManager(this);
        }
        if (autoDiscovery) {
            this.singleNode = false;
            this.discoveryFuture.getAndUpdate(current -> this.policy.schedule((ScheduledFuture<?>)current, this::discover, template.config.getIntOption(ClickHouseClientOption.NODE_DISCOVERY_INTERVAL)));
        } else {
            this.singleNode = nodes.size() == 1;
        }
        this.healthCheckFuture.getAndUpdate(current -> this.policy.schedule((ScheduledFuture<?>)current, this::check, template.config.getIntOption(ClickHouseClientOption.HEALTH_CHECK_INTERVAL)));
    }

    protected void queryClusterNodes(Collection<ClickHouseNode> seeds, Collection<ClickHouseNode> allNodes, Collection<ClickHouseNode> newHealthyNodes, Collection<ClickHouseNode> newFaultyNodes, Collection<ClickHouseNode> useless) {
        for (ClickHouseNode node : seeds) {
            boolean proceed;
            boolean isAddress;
            LinkedHashSet<String> clusters;
            Object request;
            ClickHouseClient client;
            ClickHouseNode server;
            block33: {
                server = null;
                try {
                    server = node.probe();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (server == null) {
                    newFaultyNodes.add(node);
                    continue;
                }
                if (!server.equals(node)) {
                    allNodes.add(server);
                    useless.add(node);
                }
                client = ClickHouseClient.builder().agent(false).nodeSelector(ClickHouseNodeSelector.of(server.getProtocol(), new ClickHouseProtocol[0])).build();
                request = client.read(server).format(ClickHouseFormat.RowBinaryWithNamesAndTypes);
                String clusterName = server.getCluster();
                clusters = new LinkedHashSet<String>();
                if (!ClickHouseChecker.isNullOrEmpty((CharSequence)clusterName)) {
                    clusters.add(clusterName);
                }
                isAddress = true;
                proceed = false;
                try (ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)request).query(clusters.isEmpty() ? this.policy.getQueryForAllLocalNodes() : this.policy.getQueryForClusterLocalNodes())).params(ClickHouseValues.convertToQuotedString((Object)clusterName), new String[0])).executeAndWait();){
                    for (ClickHouseRecord r : response.records()) {
                        ClickHouseNode discovered;
                        int idx = 0;
                        String cluster = r.getValue(idx++).asString();
                        clusters.add(cluster);
                        String addr = r.getValue(idx++).asString();
                        String name = r.getValue(idx++).asString();
                        isAddress = server.getHost().equals(addr);
                        if (!isAddress && !server.getHost().equals(name)) {
                            log.warn((Object)"Auto discovery may not work as no host_name and host_address in system.clusters matched with %s", new Object[]{server});
                            isAddress = true;
                        }
                        if (!(discovered = ClickHouseNode.builder(server).cluster(cluster).replica(r.getValue(idx++).asInteger()).shard(r.getValue(idx++).asInteger(), r.getValue(idx++).asInteger()).build()).equals(server)) {
                            allNodes.remove(server);
                            allNodes.add(discovered);
                            newHealthyNodes.add(discovered);
                            useless.add(server);
                        }
                        proceed = true;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to query system.clusters using %s, due to: %s", new Object[]{server, e.getMessage()});
                    if (!(e.getCause() instanceof IOException)) break block33;
                    useless.add(server);
                    if (client == null) continue;
                    client.close();
                    continue;
                }
            }
            try {
                if (!proceed) continue;
                String query = this.policy.getQueryForNonLocalNodes();
                int limit = this.template.config.getIntOption(ClickHouseClientOption.NODE_DISCOVERY_LIMIT);
                if (limit > 0) {
                    query = query + " limit " + limit;
                }
                try {
                    ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)request).query(query)).params(isAddress ? "host_address" : "host_name", ClickHouseValues.convertToSqlExpression(clusters))).executeAndWait();
                    try {
                        for (ClickHouseRecord r : response.records()) {
                            int idx = 0;
                            ClickHouseNode n = ClickHouseNode.builder(server).cluster(r.getValue(idx++).asString()).addOption(ClickHouseClientOption.AUTO_DISCOVERY.getKey(), "false").host(r.getValue(idx++).asString()).replica(r.getValue(idx++).asInteger()).shard(r.getValue(idx++).asInteger(), r.getValue(idx++).asInteger()).build();
                            allNodes.add(n);
                            newFaultyNodes.add(n);
                        }
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to query system.clusters using %s", new Object[]{server, e});
                    newHealthyNodes.remove(server);
                    newFaultyNodes.add(server);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (client == null) continue;
                client.close();
            }
        }
    }

    protected ClickHouseNode get() {
        return this.apply(this.selector);
    }

    public boolean isSingleNode() {
        return this.singleNode;
    }

    @Override
    public ClickHouseNode apply(ClickHouseNodeSelector t) {
        this.lock.readLock().lock();
        try {
            ClickHouseNode clickHouseNode = this.policy.get(this, t);
            return clickHouseNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClickHouseNode suggestNode(ClickHouseNode server, Throwable failure) {
        this.lock.readLock().lock();
        try {
            ClickHouseNode clickHouseNode = this.policy.suggest(this, server, failure);
            return clickHouseNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void update(ClickHouseNode node, ClickHouseNode.Status status) {
        this.lock.writeLock().lock();
        try {
            if (node.config.getNodeCheckInterval() > 0) {
                node.lastUpdateTime.set(System.currentTimeMillis());
            }
            this.policy.update(this, node, status);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        if (!this.checking.compareAndSet(false, true)) {
            return;
        }
        LinkedHashSet<ClickHouseNode> list = new LinkedHashSet<ClickHouseNode>();
        long currentTime = System.currentTimeMillis();
        boolean checkAll = this.template.config.getBoolOption(ClickHouseClientOption.CHECK_ALL_NODES);
        int numberOfFaultyNodes = -1;
        this.lock.readLock().lock();
        try {
            ClickHouseNodes.pickNodes(this.faultyNodes, this.selector, list, this.groupSize, currentTime);
            numberOfFaultyNodes = list.size();
            if (checkAll) {
                ClickHouseNodes.pickNodes(this.nodes, this.selector, list, this.groupSize, currentTime);
            }
        }
        finally {
            this.checking.set(false);
            this.lock.readLock().unlock();
        }
        boolean hasFaultyNode = false;
        int count = 0;
        try {
            for (ClickHouseNode node : list) {
                boolean wasFaultyBefore;
                ClickHouseNode n = node.probe();
                boolean isAlive = false;
                try (ClickHouseClient client2 = ClickHouseClient.builder().agent(false).config(n.config).nodeSelector(ClickHouseNodeSelector.of(n.getProtocol(), new ClickHouseProtocol[0])).build();){
                    isAlive = client2.ping(n, n.config.getConnectionTimeout());
                }
                catch (Exception client2) {
                    // empty catch block
                }
                if (!n.equals(node)) {
                    this.update(n, ClickHouseNode.Status.MANAGED);
                    this.update(node, ClickHouseNode.Status.STANDALONE);
                }
                boolean bl = wasFaultyBefore = numberOfFaultyNodes == -1 || count < numberOfFaultyNodes;
                if (isAlive) {
                    if (wasFaultyBefore) {
                        this.update(n, ClickHouseNode.Status.HEALTHY);
                    }
                } else {
                    hasFaultyNode = true;
                    if (!wasFaultyBefore) {
                        this.update(n, ClickHouseNode.Status.FAULTY);
                    }
                }
                ++count;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected error occurred when checking node status", (Throwable)e);
        }
        finally {
            if (checkAll || hasFaultyNode) {
                this.scheduleHealthCheck();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discover() {
        LinkedHashSet<ClickHouseNode> allNodes = new LinkedHashSet<ClickHouseNode>();
        LinkedHashSet<ClickHouseNode> seeds = new LinkedHashSet<ClickHouseNode>();
        this.lock.readLock().lock();
        try {
            for (ClickHouseNode node : this.nodes) {
                if (node.config.isAutoDiscovery()) {
                    seeds.add(node);
                    continue;
                }
                allNodes.add(node);
            }
            for (ClickHouseNode node : this.faultyNodes) {
                if (node.config.isAutoDiscovery()) {
                    seeds.add(node);
                    continue;
                }
                allNodes.add(node);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (seeds.isEmpty()) {
            return;
        }
        LinkedHashSet<ClickHouseNode> newHealthyNodes = new LinkedHashSet<ClickHouseNode>();
        LinkedHashSet<ClickHouseNode> newFaultyNodes = new LinkedHashSet<ClickHouseNode>();
        LinkedHashSet<ClickHouseNode> useless = new LinkedHashSet<ClickHouseNode>();
        this.queryClusterNodes(seeds, allNodes, newHealthyNodes, newFaultyNodes, useless);
        this.lock.readLock().lock();
        try {
            for (ClickHouseNode n : this.nodes) {
                if (!allNodes.remove(n)) {
                    useless.add(n);
                }
                newHealthyNodes.remove(n);
            }
            for (ClickHouseNode n : this.faultyNodes) {
                if (!allNodes.remove(n)) {
                    useless.add(n);
                }
                newFaultyNodes.remove(n);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        boolean noUselessNode = useless.isEmpty();
        if (allNodes.isEmpty() && noUselessNode) {
            return;
        }
        for (ClickHouseNode n : allNodes) {
            this.update(n, ClickHouseNode.Status.MANAGED);
        }
        for (ClickHouseNode n : newHealthyNodes) {
            this.update(n, ClickHouseNode.Status.HEALTHY);
        }
        for (ClickHouseNode n : newFaultyNodes) {
            this.update(n, ClickHouseNode.Status.FAULTY);
        }
        for (ClickHouseNode n : useless) {
            this.update(n, ClickHouseNode.Status.STANDALONE);
        }
        if (!noUselessNode) {
            this.scheduleHealthCheck();
        }
    }

    public ClickHouseNode getTemplate() {
        return this.template;
    }

    @Override
    public final List<ClickHouseNode> getNodes() {
        return this.getNodes(this.selector, this.groupSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClickHouseNode> getNodes(ClickHouseNodeSelector selector, int groupSize) {
        this.lock.readLock().lock();
        try {
            List<ClickHouseNode> list = ClickHouseNodes.pickNodes(this.nodes, selector, groupSize);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public final List<ClickHouseNode> getFaultyNodes() {
        return this.getFaultyNodes(this.selector, this.groupSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClickHouseNode> getFaultyNodes(ClickHouseNodeSelector selector, int groupSize) {
        this.lock.readLock().lock();
        try {
            List<ClickHouseNode> list = ClickHouseNodes.pickNodes(this.faultyNodes, selector, groupSize);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ClickHouseLoadBalancingPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public ClickHouseNodeSelector getNodeSelector() {
        return this.selector;
    }

    @Override
    public Optional<ScheduledFuture<?>> scheduleDiscovery() {
        return Optional.ofNullable(this.discoveryFuture.getAndUpdate(current -> this.policy.schedule((ScheduledFuture<?>)current, this::discover, 0L)));
    }

    @Override
    public Optional<ScheduledFuture<?>> scheduleHealthCheck() {
        return Optional.ofNullable(this.healthCheckFuture.getAndUpdate(current -> this.policy.schedule((ScheduledFuture<?>)current, this::check, 0L)));
    }

    @Override
    public void shutdown() {
        for (ScheduledFuture future : new ScheduledFuture[]{this.discoveryFuture.get(), this.healthCheckFuture.get()}) {
            if (future == null || future.isDone() || future.isCancelled()) continue;
            future.cancel(true);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.checking.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.policy.hashCode();
        result = 31 * result + this.selector.hashCode();
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.faultyNodes.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseNodes other = (ClickHouseNodes)obj;
        return this.policy.equals(other.policy) && this.selector.equals(other.selector) && this.nodes.equals(other.nodes) && this.faultyNodes.equals(other.faultyNodes);
    }

    public String toString() {
        return "ClickHouseNodes [checking=" + this.checking.get() + ", index=" + this.index.get() + ", lock=r" + this.lock.getReadHoldCount() + 'w' + this.lock.getWriteHoldCount() + ", nodes=" + this.nodes.size() + ", faulty=" + this.faultyNodes.size() + ", policy=" + this.policy.getClass().getSimpleName() + ", tags=" + this.selector.getPreferredTags() + "]@" + this.hashCode();
    }
}

