/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.config;

import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseHealthCheckMethod;
import com.clickhouse.client.config.ClickHouseProxyType;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataConfig;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ClickHouseClientOption
extends Enum<ClickHouseClientOption>
implements ClickHouseOption {
    public static final /* enum */ ClickHouseClientOption ASYNC;
    public static final /* enum */ ClickHouseClientOption AUTO_DISCOVERY;
    public static final /* enum */ ClickHouseClientOption CUSTOM_SETTINGS;
    public static final /* enum */ ClickHouseClientOption CUSTOM_SOCKET_FACTORY;
    public static final /* enum */ ClickHouseClientOption CUSTOM_SOCKET_FACTORY_OPTIONS;
    public static final /* enum */ ClickHouseClientOption LOAD_BALANCING_POLICY;
    public static final /* enum */ ClickHouseClientOption LOAD_BALANCING_TAGS;
    public static final /* enum */ ClickHouseClientOption HEALTH_CHECK_INTERVAL;
    public static final /* enum */ ClickHouseClientOption HEALTH_CHECK_METHOD;
    public static final /* enum */ ClickHouseClientOption NODE_DISCOVERY_INTERVAL;
    public static final /* enum */ ClickHouseClientOption NODE_DISCOVERY_LIMIT;
    public static final /* enum */ ClickHouseClientOption NODE_CHECK_INTERVAL;
    public static final /* enum */ ClickHouseClientOption NODE_GROUP_SIZE;
    public static final /* enum */ ClickHouseClientOption CHECK_ALL_NODES;
    public static final /* enum */ ClickHouseClientOption BUFFER_SIZE;
    public static final /* enum */ ClickHouseClientOption BUFFER_QUEUE_VARIATION;
    public static final /* enum */ ClickHouseClientOption READ_BUFFER_SIZE;
    public static final /* enum */ ClickHouseClientOption WRITE_BUFFER_SIZE;
    public static final /* enum */ ClickHouseClientOption REQUEST_CHUNK_SIZE;
    public static final /* enum */ ClickHouseClientOption REQUEST_BUFFERING;
    public static final /* enum */ ClickHouseClientOption RESPONSE_BUFFERING;
    public static final /* enum */ ClickHouseClientOption CLIENT_NAME;
    public static final /* enum */ ClickHouseClientOption COMPRESS;
    public static final /* enum */ ClickHouseClientOption DECOMPRESS;
    public static final /* enum */ ClickHouseClientOption COMPRESS_ALGORITHM;
    public static final /* enum */ ClickHouseClientOption DECOMPRESS_ALGORITHM;
    public static final /* enum */ ClickHouseClientOption COMPRESS_LEVEL;
    public static final /* enum */ ClickHouseClientOption DECOMPRESS_LEVEL;
    public static final /* enum */ ClickHouseClientOption CONNECTION_TIMEOUT;
    public static final /* enum */ ClickHouseClientOption DATABASE;
    public static final /* enum */ ClickHouseClientOption FAILOVER;
    public static final /* enum */ ClickHouseClientOption FORMAT;
    public static final /* enum */ ClickHouseClientOption LOG_LEADING_COMMENT;
    public static final /* enum */ ClickHouseClientOption MAX_BUFFER_SIZE;
    public static final /* enum */ ClickHouseClientOption MAX_MAPPER_CACHE;
    public static final /* enum */ ClickHouseClientOption MAX_EXECUTION_TIME;
    public static final /* enum */ ClickHouseClientOption MAX_QUEUED_BUFFERS;
    public static final /* enum */ ClickHouseClientOption MAX_QUEUED_REQUESTS;
    public static final /* enum */ ClickHouseClientOption MAX_RESULT_ROWS;
    public static final /* enum */ ClickHouseClientOption MAX_THREADS_PER_CLIENT;
    public static final /* enum */ ClickHouseClientOption PRODUCT_NAME;
    public static final /* enum */ ClickHouseClientOption RENAME_RESPONSE_COLUMN;
    public static final /* enum */ ClickHouseClientOption RETRY;
    public static final /* enum */ ClickHouseClientOption REPEAT_ON_SESSION_LOCK;
    public static final /* enum */ ClickHouseClientOption REUSE_VALUE_WRAPPER;
    public static final /* enum */ ClickHouseClientOption SERVER_REVISION;
    public static final /* enum */ ClickHouseClientOption SERVER_TIME_ZONE;
    public static final /* enum */ ClickHouseClientOption SERVER_VERSION;
    public static final /* enum */ ClickHouseClientOption SESSION_ID;
    public static final /* enum */ ClickHouseClientOption SESSION_CHECK;
    public static final /* enum */ ClickHouseClientOption SESSION_TIMEOUT;
    public static final /* enum */ ClickHouseClientOption SOCKET_TIMEOUT;
    public static final /* enum */ ClickHouseClientOption SOCKET_REUSEADDR;
    public static final /* enum */ ClickHouseClientOption SOCKET_KEEPALIVE;
    public static final /* enum */ ClickHouseClientOption SOCKET_LINGER;
    public static final /* enum */ ClickHouseClientOption SOCKET_IP_TOS;
    public static final /* enum */ ClickHouseClientOption SOCKET_TCP_NODELAY;
    public static final /* enum */ ClickHouseClientOption SOCKET_RCVBUF;
    public static final /* enum */ ClickHouseClientOption SOCKET_SNDBUF;
    public static final /* enum */ ClickHouseClientOption SSL;
    public static final /* enum */ ClickHouseClientOption SSL_MODE;
    public static final /* enum */ ClickHouseClientOption SSL_ROOT_CERTIFICATE;
    public static final /* enum */ ClickHouseClientOption SSL_CERTIFICATE;
    public static final /* enum */ ClickHouseClientOption SSL_KEY;
    public static final /* enum */ ClickHouseClientOption KEY_STORE_TYPE;
    public static final /* enum */ ClickHouseClientOption TRUST_STORE;
    public static final /* enum */ ClickHouseClientOption KEY_STORE_PASSWORD;
    public static final /* enum */ ClickHouseClientOption TRANSACTION_TIMEOUT;
    public static final /* enum */ ClickHouseClientOption WIDEN_UNSIGNED_TYPES;
    public static final /* enum */ ClickHouseClientOption USE_BINARY_STRING;
    public static final /* enum */ ClickHouseClientOption USE_BLOCKING_QUEUE;
    public static final /* enum */ ClickHouseClientOption USE_COMPILATION;
    public static final /* enum */ ClickHouseClientOption USE_OBJECTS_IN_ARRAYS;
    public static final /* enum */ ClickHouseClientOption PROXY_TYPE;
    public static final /* enum */ ClickHouseClientOption PROXY_HOST;
    public static final /* enum */ ClickHouseClientOption PROXY_PORT;
    public static final /* enum */ ClickHouseClientOption USE_SERVER_TIME_ZONE;
    public static final /* enum */ ClickHouseClientOption USE_SERVER_TIME_ZONE_FOR_DATES;
    public static final /* enum */ ClickHouseClientOption USE_TIME_ZONE;
    public static final /* enum */ ClickHouseClientOption QUERY_ID;
    private final String key;
    private final Serializable defaultValue;
    private final Class<? extends Serializable> clazz;
    private final String description;
    private final boolean sensitive;
    private static final Map<String, ClickHouseClientOption> options;
    static final String UNKNOWN = "unknown";
    public static final String LATEST_KNOWN_VERSION = "0.6.3";
    public static final String PRODUCT_VERSION;
    public static final String PRODUCT_REVISION;
    public static final String CLIENT_OS_INFO;
    public static final String CLIENT_JVM_INFO;
    public static final String CLIENT_USER;
    public static final String CLIENT_HOST;
    private static final /* synthetic */ ClickHouseClientOption[] $VALUES;

    public static ClickHouseClientOption[] values() {
        return (ClickHouseClientOption[])$VALUES.clone();
    }

    public static ClickHouseClientOption valueOf(String name) {
        return Enum.valueOf(ClickHouseClientOption.class, name);
    }

    public static String buildUserAgent(String productName, String additionalProperty) {
        productName = productName == null || productName.isEmpty() ? (String)((Object)PRODUCT_NAME.getEffectiveDefaultValue()) : productName.trim();
        StringBuilder builder = new StringBuilder(productName).append(PRODUCT_VERSION.isEmpty() ? "" : "/" + PRODUCT_VERSION);
        if (!String.valueOf(PRODUCT_NAME.getDefaultValue()).equals(productName)) {
            builder.append(" ").append(PRODUCT_NAME.getDefaultValue()).append(LATEST_KNOWN_VERSION);
        }
        builder.append(" (").append(CLIENT_JVM_INFO);
        if (additionalProperty != null && !additionalProperty.isEmpty()) {
            builder.append("; ").append(additionalProperty.trim());
        }
        return builder.append(")").toString();
    }

    public static String getSystemConfig(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (defaultValue == null) {
            return propertyValue;
        }
        return propertyValue == null || propertyValue.isEmpty() ? defaultValue : propertyValue;
    }

    public static ClickHouseClientOption fromKey(String key) {
        return options.get(key);
    }

    private <T extends Serializable> ClickHouseClientOption(String key, T defaultValue, String description) {
        this(key, defaultValue, description, false);
    }

    private <T extends Serializable> ClickHouseClientOption(String key, T defaultValue, String description, boolean sensitive) {
        this.key = (String)ClickHouseChecker.nonNull((Object)key, (String)"key");
        this.defaultValue = (Serializable)ClickHouseChecker.nonNull(defaultValue, (String)"defaultValue");
        this.clazz = defaultValue.getClass();
        this.description = (String)ClickHouseChecker.nonNull((Object)description, (String)"description");
        this.sensitive = sensitive;
    }

    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKey() {
        return this.key;
    }

    public Class<? extends Serializable> getValueType() {
        return this.clazz;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    private static /* synthetic */ ClickHouseClientOption[] $values() {
        return new ClickHouseClientOption[]{ASYNC, AUTO_DISCOVERY, CUSTOM_SETTINGS, CUSTOM_SOCKET_FACTORY, CUSTOM_SOCKET_FACTORY_OPTIONS, LOAD_BALANCING_POLICY, LOAD_BALANCING_TAGS, HEALTH_CHECK_INTERVAL, HEALTH_CHECK_METHOD, NODE_DISCOVERY_INTERVAL, NODE_DISCOVERY_LIMIT, NODE_CHECK_INTERVAL, NODE_GROUP_SIZE, CHECK_ALL_NODES, BUFFER_SIZE, BUFFER_QUEUE_VARIATION, READ_BUFFER_SIZE, WRITE_BUFFER_SIZE, REQUEST_CHUNK_SIZE, REQUEST_BUFFERING, RESPONSE_BUFFERING, CLIENT_NAME, COMPRESS, DECOMPRESS, COMPRESS_ALGORITHM, DECOMPRESS_ALGORITHM, COMPRESS_LEVEL, DECOMPRESS_LEVEL, CONNECTION_TIMEOUT, DATABASE, FAILOVER, FORMAT, LOG_LEADING_COMMENT, MAX_BUFFER_SIZE, MAX_MAPPER_CACHE, MAX_EXECUTION_TIME, MAX_QUEUED_BUFFERS, MAX_QUEUED_REQUESTS, MAX_RESULT_ROWS, MAX_THREADS_PER_CLIENT, PRODUCT_NAME, RENAME_RESPONSE_COLUMN, RETRY, REPEAT_ON_SESSION_LOCK, REUSE_VALUE_WRAPPER, SERVER_REVISION, SERVER_TIME_ZONE, SERVER_VERSION, SESSION_ID, SESSION_CHECK, SESSION_TIMEOUT, SOCKET_TIMEOUT, SOCKET_REUSEADDR, SOCKET_KEEPALIVE, SOCKET_LINGER, SOCKET_IP_TOS, SOCKET_TCP_NODELAY, SOCKET_RCVBUF, SOCKET_SNDBUF, SSL, SSL_MODE, SSL_ROOT_CERTIFICATE, SSL_CERTIFICATE, SSL_KEY, KEY_STORE_TYPE, TRUST_STORE, KEY_STORE_PASSWORD, TRANSACTION_TIMEOUT, WIDEN_UNSIGNED_TYPES, USE_BINARY_STRING, USE_BLOCKING_QUEUE, USE_COMPILATION, USE_OBJECTS_IN_ARRAYS, PROXY_TYPE, PROXY_HOST, PROXY_PORT, USE_SERVER_TIME_ZONE, USE_SERVER_TIME_ZONE_FOR_DATES, USE_TIME_ZONE, QUERY_ID};
    }

    static {
        String[] parts;
        ASYNC = new ClickHouseClientOption("async", true, "Whether the client should run in async mode.");
        AUTO_DISCOVERY = new ClickHouseClientOption("auto_discovery", false, "Whether the client should discover more nodes from system tables and/or clickhouse-keeper/zookeeper.");
        CUSTOM_SETTINGS = new ClickHouseClientOption("custom_settings", "", "Comma separated custom server settings for all queries.");
        CUSTOM_SOCKET_FACTORY = new ClickHouseClientOption("custom_socket_factory", "", "Full qualified class name of custom socket factory. This is only supported by TCP client and Apache Http Client.");
        CUSTOM_SOCKET_FACTORY_OPTIONS = new ClickHouseClientOption("custom_socket_factory_options", "", "Comma separated options for custom socket factory.");
        LOAD_BALANCING_POLICY = new ClickHouseClientOption("load_balancing_policy", "", "Load balancing policy, can be one of '', 'firstAlive', 'random', 'roundRobin', or full qualified class name implementing ClickHouseLoadBalancingPolicy.");
        LOAD_BALANCING_TAGS = new ClickHouseClientOption("load_balancing_tags", "", "Load balancing tags for filtering out nodes.");
        HEALTH_CHECK_INTERVAL = new ClickHouseClientOption("health_check_interval", 0, "Health check interval in milliseconds, zero or negative value means one-time.");
        HEALTH_CHECK_METHOD = new ClickHouseClientOption("health_check_method", ClickHouseHealthCheckMethod.SELECT_ONE, "Health check method.");
        NODE_DISCOVERY_INTERVAL = new ClickHouseClientOption("node_discovery_interval", 0, "Node discovery interval in milliseconds, zero or negative value means one-time discovery.");
        NODE_DISCOVERY_LIMIT = new ClickHouseClientOption("node_discovery_limit", 100, "Maximum number of nodes can be discovered at a time, zero or negative value means no limit.");
        NODE_CHECK_INTERVAL = new ClickHouseClientOption("node_check_interval", 0, "Node check interval in milliseconds, negative number is treated as zero.");
        NODE_GROUP_SIZE = new ClickHouseClientOption("node_group_size", 50, "Maximum number of nodes can be used for operation at a time, zero or negative value means all.");
        CHECK_ALL_NODES = new ClickHouseClientOption("check_all_nodes", false, "Whether to perform health check against all nodes or just faulty ones.");
        BUFFER_SIZE = new ClickHouseClientOption("buffer_size", 8192, "Default buffer size in byte for both request and response.");
        BUFFER_QUEUE_VARIATION = new ClickHouseClientOption("buffer_queue_variation", 100, "Number of times the buffer queue is filled up before increasing capacity of buffer queue. Zero or negative value means the queue length is fixed.");
        READ_BUFFER_SIZE = new ClickHouseClientOption("read_buffer_size", 0, "Read buffer size in byte, zero or negative value means same as buffer_size");
        WRITE_BUFFER_SIZE = new ClickHouseClientOption("write_buffer_size", 0, "Write buffer size in byte, zero or negative value means same as buffer_size");
        REQUEST_CHUNK_SIZE = new ClickHouseClientOption("request_chunk_size", 0, "Maximum request chunk size in byte, zero or negative value means same as write_buffer_size");
        REQUEST_BUFFERING = new ClickHouseClientOption("request_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Request buffering mode");
        RESPONSE_BUFFERING = new ClickHouseClientOption("response_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Response buffering mode.");
        CLIENT_NAME = new ClickHouseClientOption("client_name", "ClickHouse Java Client", "Client name, which is either 'client_name' or 'http_user_agent' shows up in system.query_log table.");
        COMPRESS = new ClickHouseClientOption("compress", true, "Whether the server will compress response it sends to client.");
        DECOMPRESS = new ClickHouseClientOption("decompress", false, "Whether the server will decompress request from client.");
        COMPRESS_ALGORITHM = new ClickHouseClientOption("compress_algorithm", ClickHouseCompression.LZ4, "Algorithm used for server to compress response.");
        DECOMPRESS_ALGORITHM = new ClickHouseClientOption("decompress_algorithm", ClickHouseCompression.LZ4, "Algorithm for server to decompress request.");
        COMPRESS_LEVEL = new ClickHouseClientOption("compress_level", -1, "Compression level for response, -1 standards for default");
        DECOMPRESS_LEVEL = new ClickHouseClientOption("decompress_level", -1, "Compression level for request, -1 standards for default");
        CONNECTION_TIMEOUT = new ClickHouseClientOption("connect_timeout", 5000, "Connection timeout in milliseconds. It's also used for waiting a connection being closed.");
        DATABASE = new ClickHouseClientOption("database", "", "Default database.");
        FAILOVER = new ClickHouseClientOption("failover", 0, "Maximum number of times failover can happen for a request, zero or negative value means no failover.");
        FORMAT = new ClickHouseClientOption("format", ClickHouseDataConfig.DEFAULT_FORMAT, "Default format.");
        LOG_LEADING_COMMENT = new ClickHouseClientOption("log_leading_comment", false, "Whether to log leading comment(as log_comment in system.query_log) of the query.");
        MAX_BUFFER_SIZE = new ClickHouseClientOption("max_buffer_size", 0x100000, "Maximum buffer size in byte can be used for streaming.");
        MAX_MAPPER_CACHE = new ClickHouseClientOption("max_mapper_cache", 100, "Maximum number of mappers can be cached.");
        MAX_EXECUTION_TIME = new ClickHouseClientOption("max_execution_time", 0, "Maximum query execution time in seconds, 0 means no limit.");
        MAX_QUEUED_BUFFERS = new ClickHouseClientOption("max_queued_buffers", 512, "Maximum queued in-memory buffers, 0 or negative number means no limit.");
        MAX_QUEUED_REQUESTS = new ClickHouseClientOption("max_queued_requests", 0, "Maximum queued requests, 0 or negative number means no limit.");
        MAX_RESULT_ROWS = new ClickHouseClientOption("max_result_rows", 0L, "Limit on the number of rows in the result. Also checked for subqueries, and on remote servers when running parts of a distributed query.");
        MAX_THREADS_PER_CLIENT = new ClickHouseClientOption("max_threads_per_client", 0, "Size of thread pool for each client instance, 0 or negative number means the client will use shared thread pool.");
        PRODUCT_NAME = new ClickHouseClientOption("product_name", "ClickHouse-JavaClient", "Product name used in user agent.");
        RENAME_RESPONSE_COLUMN = new ClickHouseClientOption("rename_response_column", ClickHouseDataConfig.DEFAULT_COLUMN_RENAME_METHOD, "Method to rename response columns.");
        RETRY = new ClickHouseClientOption("retry", 0, "Maximum number of times retry can happen for a request, zero or negative value means no retry.");
        REPEAT_ON_SESSION_LOCK = new ClickHouseClientOption("repeat_on_session_lock", true, "Whether to repeat execution when session is locked, until timed out(according to 'session_timeout' or 'connect_timeout').");
        REUSE_VALUE_WRAPPER = new ClickHouseClientOption("reuse_value_wrapper", true, "Whether to reuse wrapper of value(e.g. ClickHouseValue or ClickHouseRecord) for memory efficiency.");
        SERVER_REVISION = new ClickHouseClientOption("server_revision", 54442, "Server revision.");
        SERVER_TIME_ZONE = new ClickHouseClientOption("server_time_zone", "", "Server timezone.");
        SERVER_VERSION = new ClickHouseClientOption("server_version", "", "Server version.");
        SESSION_ID = new ClickHouseClientOption("session_id", "", "Session id");
        SESSION_CHECK = new ClickHouseClientOption("session_check", false, "Whether to check if existence of session id.");
        SESSION_TIMEOUT = new ClickHouseClientOption("session_timeout", 0, "Session timeout in seconds. 0 or negative number means same as server default.");
        SOCKET_TIMEOUT = new ClickHouseClientOption("socket_timeout", 30000, "Socket timeout in milliseconds.");
        SOCKET_REUSEADDR = new ClickHouseClientOption("socket_reuseaddr", false, "Whether allows for the reuse of local addresses and ports. Only works for client using custom Socket(e.g. TCP client or HTTP provider with custom SocketFactory etc.).");
        SOCKET_KEEPALIVE = new ClickHouseClientOption("socket_keepalive", false, "Whether to enable keep-alive packets for a socket connection. Only works for client using custom Socket.");
        SOCKET_LINGER = new ClickHouseClientOption("socket_linger", -1, "Seconds to wait while data is being transmitted before closing the socket. Use negative number to disable the option. Only works for client using custom Socket(e.g. TCP client or HTTP provider with custom SocketFactory etc.).");
        SOCKET_IP_TOS = new ClickHouseClientOption("socket_ip_tos", 0, "Socket IP_TOS option which indicates IP package priority. Only works for client using custom Socket.");
        SOCKET_TCP_NODELAY = new ClickHouseClientOption("socket_tcp_nodelay", false, "");
        SOCKET_RCVBUF = new ClickHouseClientOption("socket_rcvbuf", 0, "Size of the socket receive buffer in bytes. Only works for client using custom Socket.");
        SOCKET_SNDBUF = new ClickHouseClientOption("socket_sndbuf", 0, "Size of the socket send buffer in bytes. Only works for client using custom Socket.");
        SSL = new ClickHouseClientOption("ssl", false, "Whether to enable SSL/TLS for the connection.");
        SSL_MODE = new ClickHouseClientOption("sslmode", ClickHouseSslMode.STRICT, "verify or not certificate: none (don't verify), strict (verify)");
        SSL_ROOT_CERTIFICATE = new ClickHouseClientOption("sslrootcert", "", "SSL/TLS root certificates.");
        SSL_CERTIFICATE = new ClickHouseClientOption("sslcert", "", "SSL/TLS certificate.");
        SSL_KEY = new ClickHouseClientOption("sslkey", "", "RSA key in PKCS#8 format.", true);
        KEY_STORE_TYPE = new ClickHouseClientOption("key_store_type", "", "Specifies the type or format of the keystore/truststore file used for SSL/TLS configuration, such as \"JKS\" (Java KeyStore) or \"PKCS12.\"", true);
        TRUST_STORE = new ClickHouseClientOption("trust_store", "", "Path to the truststore file", true);
        KEY_STORE_PASSWORD = new ClickHouseClientOption("key_store_password", "", "Password needed to access the keystore file specified in the keystore config", true);
        TRANSACTION_TIMEOUT = new ClickHouseClientOption("transaction_timeout", 0, "Transaction timeout in seconds. 0 or negative number means same as session_timeout.");
        WIDEN_UNSIGNED_TYPES = new ClickHouseClientOption("widen_unsigned_types", false, "Whether to convert unsigned types to the next widest type(e.g. use short for UInt8 instead of byte, and UnsignedLong for UInt64).");
        USE_BINARY_STRING = new ClickHouseClientOption("use_binary_string", false, "Whether to support binary string. Enable this option to treat FixedString and String as byte array.");
        USE_BLOCKING_QUEUE = new ClickHouseClientOption("use_blocking_queue", false, "Whether to use blocking queue for buffering.");
        USE_COMPILATION = new ClickHouseClientOption("use_compilation", false, "Whether to use compilation(generated byte code) in object mapping and serialization.");
        USE_OBJECTS_IN_ARRAYS = new ClickHouseClientOption("use_objects_in_arrays", false, "Whether Object[] should be used instead of primitive arrays.");
        PROXY_TYPE = new ClickHouseClientOption("proxy_type", ClickHouseProxyType.IGNORE, "Type of proxy can be used to access ClickHouse server. To use an HTTP/SOCKS proxy, you must specify proxy_host and proxy_port.");
        PROXY_HOST = new ClickHouseClientOption("proxy_host", "", "Set ClickHouse server proxy hostname.");
        PROXY_PORT = new ClickHouseClientOption("proxy_port", -1, "Set ClickHouse server proxy hostname.");
        USE_SERVER_TIME_ZONE = new ClickHouseClientOption("use_server_time_zone", true, "Whether to use server time zone. On connection init select timezone() will be executed");
        USE_SERVER_TIME_ZONE_FOR_DATES = new ClickHouseClientOption("use_server_time_zone_for_dates", false, "Whether to use timezone from server on Date parsing in getDate(). If false, Date returned is a wrapper of a timestamp at start of the day in client timezone. If true - at start of the day in server or use_time_zone timezone.");
        USE_TIME_ZONE = new ClickHouseClientOption("use_time_zone", "", "Time zone of all DateTime* values. Only used when use_server_time_zone is false. Empty value means client time zone.");
        QUERY_ID = new ClickHouseClientOption("query_id", "", "Query id");
        $VALUES = ClickHouseClientOption.$values();
        HashMap<String, ClickHouseClientOption> map = new HashMap<String, ClickHouseClientOption>();
        for (ClickHouseClientOption o : ClickHouseClientOption.values()) {
            if (map.put(o.getKey(), o) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + o.getKey());
        }
        options = Collections.unmodifiableMap(map);
        String ver = ClickHouseClientOption.class.getPackage().getImplementationVersion();
        String[] stringArray = parts = ver == null || ver.isEmpty() ? null : ver.split("\\s");
        if (parts != null && parts.length == 4 && parts[1].length() > 0 && parts[3].length() > 1 && ver.charAt(ver.length() - 1) == ')') {
            PRODUCT_VERSION = parts[1];
            ver = parts[3];
            PRODUCT_REVISION = ver.substring(0, ver.length() - 1);
        } else {
            PRODUCT_VERSION = LATEST_KNOWN_VERSION;
            PRODUCT_REVISION = UNKNOWN;
        }
        CLIENT_OS_INFO = ClickHouseClientOption.getSystemConfig("os.name", "O/S") + '/' + ClickHouseClientOption.getSystemConfig("os.version", UNKNOWN);
        String javaVersion = System.getProperty("java.vendor.version");
        if (javaVersion == null || javaVersion.isEmpty() || javaVersion.indexOf(32) >= 0) {
            javaVersion = ClickHouseClientOption.getSystemConfig("java.vm.version", ClickHouseClientOption.getSystemConfig("java.version", UNKNOWN));
        }
        CLIENT_JVM_INFO = ClickHouseClientOption.getSystemConfig("java.vm.name", "Java") + '/' + javaVersion;
        CLIENT_USER = ClickHouseClientOption.getSystemConfig("user.name", UNKNOWN);
        try {
            ver = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        CLIENT_HOST = ver == null || ver.isEmpty() ? UNKNOWN : ver;
    }
}

