/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseFile;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class AbstractSocketClient
implements AutoCloseable {
    public static final String ERROR_INVALID_INPUT_STREAM = "Non-null unclosed input stream is required";
    public static final String ERROR_INVALID_OUTPUT_STREAM = "Non-null unclosed out stream is required";
    public static final String ERROR_READ_TIMEOUT = "Read timed out after waiting for more than %d ms";
    public static final String ERROR_WRITE_TIMEOUT = "Write timed out after waiting for more than %d ms";
    private static final Logger log = LoggerFactory.getLogger(AbstractSocketClient.class);
    private final AtomicReference<SocketRequest> request;
    private final SelectionKey selectionKey;
    private final AtomicReference<CompletableFuture<Boolean>> completed;

    public static Socket setSocketOptions(ClickHouseConfig config, Socket socket) throws SocketException {
        int bufferSize;
        if (socket == null || socket.isClosed()) {
            throw new IllegalArgumentException("Cannot set option(s) on a null or closed socket");
        }
        if (config == null) {
            return socket;
        }
        if (!socket.isConnected() || !socket.isBound()) {
            socket.setSoTimeout(config.getSocketTimeout());
        } else if (config.hasOption(ClickHouseClientOption.SOCKET_TIMEOUT)) {
            socket.setSoTimeout(config.getIntOption(ClickHouseClientOption.SOCKET_TIMEOUT));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_IP_TOS)) {
            socket.setTrafficClass(config.getIntOption(ClickHouseClientOption.SOCKET_IP_TOS));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_KEEPALIVE)) {
            socket.setKeepAlive(config.getBoolOption(ClickHouseClientOption.SOCKET_KEEPALIVE));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_LINGER)) {
            int solinger = config.getIntOption(ClickHouseClientOption.SOCKET_LINGER);
            socket.setSoLinger(solinger >= 0, solinger);
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_REUSEADDR)) {
            socket.setReuseAddress(config.getBoolOption(ClickHouseClientOption.SOCKET_REUSEADDR));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_RCVBUF)) {
            bufferSize = config.getIntOption(ClickHouseClientOption.SOCKET_RCVBUF);
            socket.setReceiveBufferSize(bufferSize > 0 ? bufferSize : config.getReadBufferSize());
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_SNDBUF)) {
            bufferSize = config.getIntOption(ClickHouseClientOption.SOCKET_SNDBUF);
            socket.setSendBufferSize(bufferSize > 0 ? bufferSize : config.getWriteBufferSize());
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_TCP_NODELAY)) {
            socket.setTcpNoDelay(config.getBoolOption(ClickHouseClientOption.SOCKET_TCP_NODELAY));
        }
        return socket;
    }

    public static SocketChannel setSocketOptions(ClickHouseConfig config, SocketChannel socket) throws IOException {
        int bufferSize;
        if (socket == null || socket.socket().isClosed()) {
            throw new IllegalArgumentException("Cannot set option(s) on a null or closed socket channel");
        }
        if (config == null) {
            return socket;
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_IP_TOS)) {
            socket.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)config.getIntOption(ClickHouseClientOption.SOCKET_IP_TOS));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_KEEPALIVE)) {
            socket.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)config.getBoolOption(ClickHouseClientOption.SOCKET_KEEPALIVE));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_LINGER)) {
            socket.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)config.getIntOption(ClickHouseClientOption.SOCKET_LINGER));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_REUSEADDR)) {
            socket.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)config.getBoolOption(ClickHouseClientOption.SOCKET_REUSEADDR));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_RCVBUF)) {
            bufferSize = config.getIntOption(ClickHouseClientOption.SOCKET_RCVBUF);
            socket.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)(bufferSize > 0 ? bufferSize : config.getReadBufferSize()));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_SNDBUF)) {
            bufferSize = config.getIntOption(ClickHouseClientOption.SOCKET_SNDBUF);
            socket.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)(bufferSize > 0 ? bufferSize : config.getWriteBufferSize()));
        }
        if (config.hasOption(ClickHouseClientOption.SOCKET_TCP_NODELAY)) {
            socket.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)config.getBoolOption(ClickHouseClientOption.SOCKET_TCP_NODELAY));
        }
        return socket;
    }

    protected SocketChannel getSocketChannel() {
        return (SocketChannel)this.selectionKey.channel();
    }

    protected CompletableFuture<Boolean> processRequest(ClickHouseConfig config, ClickHouseInputStream in, ClickHouseOutputStream out) throws IOException {
        long timeout = config.getSocketTimeout();
        log.trace((Object)"About to set request: [in=%s, out=%s, timeout=%d]", new Object[]{in, out, timeout});
        long startTime = 0L;
        SocketRequest req = new SocketRequest(config, in, out);
        while (!this.request.compareAndSet(null, req)) {
            if (timeout <= 0L) continue;
            if (startTime == 0L) {
                startTime = System.currentTimeMillis();
                continue;
            }
            if (System.currentTimeMillis() - startTime <= timeout) continue;
            throw new SocketTimeoutException(ClickHouseUtils.format((String)ERROR_WRITE_TIMEOUT, (Object[])new Object[]{timeout}));
        }
        this.setInterestOp(4);
        return ClickHouseClient.submit(() -> {
            while (req != this.request.get() || !req.isDone()) {
            }
            return req.hasError();
        });
    }

    protected final void setInterestOp(int op) {
        SelectionKey key = this.selectionKey;
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & op) == 0) {
            key.interestOps(interestOps | op);
        }
    }

    protected final void removeInterestOp(int op) {
        SelectionKey key = this.selectionKey;
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & op) != 0) {
            key.interestOps(interestOps & ~op);
        }
    }

    protected void onConnect(ClickHouseConfig config, SocketChannel channel) throws IOException {
        if (!channel.finishConnect()) {
            throw new ConnectException(ClickHouseUtils.format((String)"Failed to connect to [%s]", (Object[])new Object[]{this.remoteAddress()}));
        }
        log.debug((Object)"Connection established: [%s] <-> [%s]", new Object[]{this.localAddress(), this.remoteAddress()});
        this.setInterestOp(1);
    }

    protected boolean onRead(ClickHouseConfig config, SocketChannel sc, ClickHouseOutputStream out) throws IOException {
        long socketTimeout = config.getSocketTimeout();
        long startTime = socketTimeout > 0L ? System.currentTimeMillis() : 0L;
        ByteBuffer buffer = ByteBuffer.allocate(config.getWriteBufferSize());
        byte[] bytes = buffer.array();
        int len = 0;
        while ((len = sc.read(buffer)) > 0) {
            log.trace((Object)"Receive from [%s]: [%s]", new Object[]{out, new String(bytes, 0, len)});
            out.write(bytes, 0, len);
            buffer.clear();
            if (startTime <= 0L || System.currentTimeMillis() - startTime <= socketTimeout) continue;
            throw new SocketTimeoutException(ClickHouseUtils.format((String)ERROR_READ_TIMEOUT, (Object[])new Object[]{socketTimeout}));
        }
        return len != -1;
    }

    protected long onWrite(ClickHouseConfig config, SocketChannel sc, ClickHouseInputStream in, long startPosition) throws IOException {
        long socketTimeout = config.getSocketTimeout();
        long startTime = socketTimeout > 0L ? System.currentTimeMillis() : 0L;
        ClickHousePassThruStream s = in.getUnderlyingStream();
        if (s.hasInput() && s instanceof ClickHouseFile) {
            try (FileChannel fc = FileChannel.open(((ClickHouseFile)s).getFile().toPath(), new OpenOption[0]);){
                long size = fc.size();
                long chunkSize = config.getRequestChunkSize();
                long offset = startPosition;
                while (size > 0L) {
                    long transferred = fc.transferTo(offset, size >= chunkSize ? chunkSize : size, sc);
                    if (transferred == 0L) {
                        long l = offset;
                        return l;
                    }
                    size -= transferred;
                    offset += transferred;
                }
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(config.getReadBufferSize());
            byte[] bytes = buffer.array();
            int len = 0;
            while ((len = in.read(bytes)) > 0) {
                buffer.limit(len);
                log.trace((Object)"Send to [%s]: [%s]", new Object[]{in, new String(bytes, 0, len)});
                while (buffer.hasRemaining()) {
                    if (sc.write(buffer) == 0) {
                        return 1L;
                    }
                    if (startTime <= 0L || System.currentTimeMillis() - startTime <= socketTimeout) continue;
                    throw new SocketTimeoutException(ClickHouseUtils.format((String)ERROR_WRITE_TIMEOUT, (Object[])new Object[]{socketTimeout}));
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean start() throws IOException {
        ClickHouseConfig f = (ClickHouseConfig)this.selectionKey.attachment();
        long socketTimeout = f.getSocketTimeout();
        try (SocketChannel c = this.getSocketChannel();
             Selector s = this.selectionKey.selector();){
            while (c.isOpen()) {
                if (s.select(c.isConnected() ? socketTimeout : (long)f.getConnectionTimeout()) < 1) {
                    LockSupport.parkNanos(1L);
                }
                Iterator<SelectionKey> keysIterator = s.selectedKeys().iterator();
                while (keysIterator.hasNext()) {
                    SocketRequest req;
                    SelectionKey key = keysIterator.next();
                    keysIterator.remove();
                    SocketChannel sc = (SocketChannel)key.channel();
                    if (key.isValid() && key.isConnectable()) {
                        this.onConnect(f, sc);
                    }
                    if ((req = this.request.get()) == null) continue;
                    if (key.isValid() && key.isWritable()) {
                        ClickHouseInputStream in = req.in;
                        long offset = (Long)in.getUserData("offset", (Object)0L);
                        if ((offset = this.onWrite(req.config, sc, in, offset)) <= 0L || in.available() <= 0) {
                            in.close();
                            this.removeInterestOp(4);
                        }
                        in.setUserData("offset", (Object)offset);
                    }
                    if (!key.isValid() || !key.isReadable()) continue;
                    ClickHouseOutputStream out = req.out;
                    if (this.onRead(req.config, sc, out)) {
                        log.trace((Object)"Reset request holder: %s", new Object[]{this.request.compareAndSet(req, null)});
                        out.close();
                        continue;
                    }
                    throw new ConnectException("Failed to read");
                }
            }
        }
        catch (Throwable t) {
            SocketRequest req = this.request.get();
            if (req != null && !req.isDone()) {
                req.error.compareAndSet(null, t);
                throw t;
            }
            if (t instanceof ClosedSelectorException) {
                log.info((Object)"Socket channel between [%s] and [%s] was closed", new Object[]{this.localAddress(), this.remoteAddress()});
            }
        }
        finally {
            this.close();
        }
        return true;
    }

    public AbstractSocketClient() throws IOException {
        this(new ClickHouseConfig(new ClickHouseConfig[0]));
    }

    public AbstractSocketClient(ClickHouseNode server) throws IOException {
        this(server.config);
        this.connect(server);
    }

    public AbstractSocketClient(ClickHouseConfig config) throws IOException {
        if (config == null) {
            config = new ClickHouseConfig(new ClickHouseConfig[0]);
        }
        this.request = new AtomicReference<Object>(null);
        SocketChannel channel = AbstractSocketClient.setSocketOptions(config, SocketChannel.open());
        channel.configureBlocking(false);
        this.selectionKey = channel.register(Selector.open(), 0, config);
        this.completed = new AtomicReference<Object>(null);
    }

    public CompletableFuture<Boolean> connect(ClickHouseNode server) throws IOException {
        return this.connect(new InetSocketAddress(server.getHost(), server.getPort()));
    }

    public CompletableFuture<Boolean> connect(InetSocketAddress address) throws IOException {
        log.trace((Object)"Connecting to [%s]", new Object[]{address});
        SocketChannel channel = (SocketChannel)this.selectionKey.channel();
        if (!channel.connect((SocketAddress)ClickHouseChecker.nonNull((Object)address, (String)InetSocketAddress.class.getSimpleName()))) {
            this.setInterestOp(8);
        }
        return ClickHouseClient.submit(this::start);
    }

    public boolean isActive() {
        SocketChannel channel = this.getSocketChannel();
        return channel.isOpen() && channel.isConnected();
    }

    public boolean isShutdown() {
        Socket s = this.getSocketChannel().socket();
        return s.isInputShutdown() && s.isOutputShutdown() || !this.isActive();
    }

    public InetSocketAddress localAddress() throws IOException {
        return (InetSocketAddress)this.getSocketChannel().getLocalAddress();
    }

    public InetSocketAddress remoteAddress() throws IOException {
        return (InetSocketAddress)this.getSocketChannel().getRemoteAddress();
    }

    public ClickHouseInputStream send(ClickHouseConfig config, ClickHouseInputStream rawRequest) throws IOException {
        if (rawRequest == null || rawRequest.isClosed()) {
            throw new IllegalArgumentException(ERROR_INVALID_INPUT_STREAM);
        }
        ClickHousePipedOutputStream responeStream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)ClickHouseChecker.nonNull((Object)config, (String)"Config"));
        this.processRequest(config, rawRequest, (ClickHouseOutputStream)responeStream);
        return responeStream.getInputStream();
    }

    public void send(ClickHouseConfig config, ClickHouseInputStream rawRequest, ClickHouseOutputStream responseStream) throws IOException {
        if (rawRequest == null || rawRequest.isClosed()) {
            throw new IllegalArgumentException(ERROR_INVALID_INPUT_STREAM);
        }
        if (responseStream == null || responseStream.isClosed()) {
            throw new IllegalArgumentException(ERROR_INVALID_OUTPUT_STREAM);
        }
        this.processRequest(config, rawRequest, responseStream);
    }

    @Override
    public void close() throws IOException {
        SelectionKey key;
        block5: {
            key = this.selectionKey;
            if (!key.isValid()) {
                return;
            }
            try {
                log.trace((Object)"Closing selector...", new Object[0]);
                if (!key.selector().isOpen()) break block5;
                key.selector().close();
            }
            catch (Throwable throwable) {
                log.trace((Object)"Closing channel...", new Object[0]);
                if (key.channel().isOpen()) {
                    key.channel().close();
                }
                log.trace((Object)"Closing selection key...", new Object[0]);
                log.trace((Object)"Release attached object: [%s]", new Object[]{key.attach(null)});
                key.cancel();
                throw throwable;
            }
        }
        log.trace((Object)"Closing channel...", new Object[0]);
        if (key.channel().isOpen()) {
            key.channel().close();
        }
        log.trace((Object)"Closing selection key...", new Object[0]);
        log.trace((Object)"Release attached object: [%s]", new Object[]{key.attach(null)});
        key.cancel();
    }

    static class SocketRequest {
        final ClickHouseConfig config;
        final ClickHouseInputStream in;
        final ClickHouseOutputStream out;
        final AtomicReference<Throwable> error;

        SocketRequest(ClickHouseConfig config, ClickHouseInputStream in, ClickHouseOutputStream out) {
            this.config = config;
            this.in = in;
            this.out = out;
            this.error = new AtomicReference<Object>(null);
        }

        boolean hasError() {
            return this.error.get() != null;
        }

        boolean isDone() {
            return this.hasError() || this.out.isClosed() && this.in.isClosed();
        }
    }
}

