/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class ClickHouseClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseClientBuilder.class);
    protected boolean agent = true;
    protected ClickHouseConfig config = null;
    protected ClickHouseCredentials credentials;
    protected Object metricRegistry = null;
    protected ClickHouseNodeSelector nodeSelector = null;
    protected final Map<ClickHouseOption, Serializable> options = new HashMap<ClickHouseOption, Serializable>();

    static ServiceLoader<ClickHouseClient> loadClients() {
        return ServiceLoader.load(ClickHouseClient.class, ClickHouseClientBuilder.class.getClassLoader());
    }

    protected ClickHouseClientBuilder() {
    }

    protected void resetConfig() {
        if (this.config != null) {
            this.config = null;
        }
    }

    public ClickHouseConfig getConfig() {
        if (this.config == null) {
            this.config = new ClickHouseConfig(this.options, this.credentials, this.nodeSelector, this.metricRegistry);
        }
        return this.config;
    }

    public ClickHouseClient build() {
        ClickHouseClient client = null;
        ClickHouseConfig conf = this.getConfig();
        int counter = 0;
        if (this.nodeSelector != null) {
            for (ClickHouseClient c : ClickHouseClientBuilder.loadClients()) {
                try {
                    c.init(conf);
                    ++counter;
                    if (this.nodeSelector != ClickHouseNodeSelector.EMPTY && !this.nodeSelector.match(c)) continue;
                    client = c;
                    break;
                }
                catch (Exception e) {
                    log.warn((Object)"Skip %s due to: %s", new Object[]{c, e.getMessage()});
                }
            }
        }
        if (this.agent) {
            return new Agent(client, conf);
        }
        if (client == null) {
            throw new IllegalStateException(ClickHouseUtils.format((String)"No suitable ClickHouse client(out of %d) found in classpath for %s.", (Object[])new Object[]{counter, this.nodeSelector}));
        }
        return client;
    }

    public ClickHouseClientBuilder agent(boolean agent) {
        this.agent = agent;
        return this;
    }

    public ClickHouseClientBuilder config(ClickHouseConfig config) {
        this.config = config;
        this.credentials = config.getDefaultCredentials();
        this.metricRegistry = config.getMetricRegistry().orElse(null);
        this.nodeSelector = config.getNodeSelector();
        this.options.putAll(config.getAllOptions());
        return this;
    }

    public ClickHouseClientBuilder option(ClickHouseOption option, Serializable value) {
        if (option == null || value == null) {
            throw new IllegalArgumentException("Non-null option and value are required");
        }
        Serializable oldValue = this.options.put(option, value);
        if (oldValue == null || !value.equals(oldValue)) {
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder removeOption(ClickHouseOption option) {
        Serializable value = this.options.remove(ClickHouseChecker.nonNull((Object)option, (String)"option"));
        if (value != null) {
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder options(Map<ClickHouseOption, Serializable> options) {
        if (options != null && !options.isEmpty()) {
            this.options.putAll(options);
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder defaultCredentials(ClickHouseCredentials credentials) {
        if (!Objects.equals(this.credentials, credentials)) {
            this.credentials = credentials;
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder nodeSelector(ClickHouseNodeSelector nodeSelector) {
        if (!((ClickHouseNodeSelector)ClickHouseChecker.nonNull((Object)nodeSelector, (String)"nodeSelector")).equals(this.nodeSelector)) {
            this.nodeSelector = (nodeSelector.getPreferredProtocols().isEmpty() || nodeSelector.getPreferredProtocols().equals(Collections.singletonList(ClickHouseProtocol.ANY))) && nodeSelector.getPreferredTags().isEmpty() ? ClickHouseNodeSelector.EMPTY : nodeSelector;
            this.resetConfig();
        }
        return this;
    }

    public ClickHouseClientBuilder metricRegistry(Object metricRegistry) {
        if (!Objects.equals(this.metricRegistry, metricRegistry)) {
            this.metricRegistry = metricRegistry;
            this.resetConfig();
        }
        return this;
    }

    static final class Agent
    implements ClickHouseClient {
        private static final Logger log = LoggerFactory.getLogger(Agent.class);
        private static final long INITIAL_REPEAT_DELAY = 100L;
        private static final long MAX_REPEAT_DELAY = 1000L;
        private static final long REPEAT_DELAY_BACKOFF = 100L;
        private final AtomicReference<ClickHouseClient> client;

        Agent(ClickHouseClient client, ClickHouseConfig config) {
            this.client = new AtomicReference<ClickHouseClient>(client != null ? client : new DummyClient(config));
        }

        ClickHouseClient getClient() {
            return this.client.get();
        }

        boolean changeClient(ClickHouseClient currentClient, ClickHouseClient newClient) {
            boolean changed = this.client.compareAndSet(currentClient, newClient);
            try {
                if (changed) {
                    currentClient.close();
                } else {
                    newClient.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        ClickHouseResponse failover(ClickHouseRequest<?> sealedRequest, ClickHouseException exception, int times) {
            for (i = 1; i <= times; ++i) {
                block16: {
                    block15: {
                        Agent.log.debug((Object)"Failover %d of %d due to: %s", new Object[]{i, times, exception.getCause(), null});
                        current = sealedRequest.getServer();
                        manager = current.manager.get();
                        if (manager == null) {
                            Agent.log.debug((Object)"Cancel failover for unmanaged node: %s", new Object[]{current});
                            break;
                        }
                        next = manager.suggestNode(current, exception);
                        if (next == current) {
                            Agent.log.debug((Object)"Cancel failover for same node returned from %s", new Object[]{manager.getPolicy()});
                            break;
                        }
                        current.update(ClickHouseNode.Status.FAULTY);
                        if (sealedRequest.isTransactional()) {
                            Agent.log.debug((Object)"Cancel failover for transactional context: %s", new Object[]{sealedRequest.getTransaction()});
                            break;
                        }
                        if ((next = sealedRequest.changeServer(current, next)) == current) {
                            Agent.log.debug((Object)"Cancel failover for no alternative of %s", new Object[]{current});
                            break;
                        }
                        Agent.log.info((Object)"Switching node from %s to %s due to: %s", new Object[]{current, next, exception.getCause(), null});
                        protocol = next.getProtocol();
                        currentClient = this.client.get();
                        if (currentClient.accept(protocol)) break block16;
                        newClient = null;
                        try {
                            newClient = ClickHouseClient.builder().agent(false).config(new ClickHouseConfig(new ClickHouseConfig[]{currentClient.getConfig(), next.config})).nodeSelector(ClickHouseNodeSelector.of(protocol, new ClickHouseProtocol[0])).build();
                            if (newClient == null) break block15;
                            changed = this.changeClient(currentClient, newClient);
                        }
                        catch (Exception e) {
                            try {
                                exception = ClickHouseException.of(new ConnectException("No client available for " + next), sealedRequest.getServer());
                                if (newClient == null) break block15;
                                changed = this.changeClient(currentClient, newClient);
                            }
                            catch (Throwable var12_15) {
                                if (newClient != null) {
                                    changed = this.changeClient(currentClient, newClient);
                                    Agent.log.info((Object)"Switching client from %s to %s: %s", new Object[]{currentClient, newClient, changed});
                                    if (changed) {
                                        sealedRequest.resetCache();
                                    }
                                }
                                throw var12_15;
                            }
                            Agent.log.info((Object)"Switching client from %s to %s: %s", new Object[]{currentClient, newClient, changed});
                            if (changed) {
                                sealedRequest.resetCache();
                            } else {
                                ** GOTO lbl48
                            }
                        }
                        Agent.log.info((Object)"Switching client from %s to %s: %s", new Object[]{currentClient, newClient, changed});
                        if (changed) {
                            sealedRequest.resetCache();
                        }
                    }
                    if (newClient == null) continue;
                }
                try {
                    return this.sendOnce(sealedRequest);
                }
                catch (Exception exp) {
                    exception = ClickHouseException.of(exp.getCause() != null ? exp.getCause() : exp, sealedRequest.getServer());
                }
            }
            throw new CompletionException(exception);
        }

        ClickHouseResponse repeat(ClickHouseRequest<?> sealedRequest, ClickHouseException exception, long timeout) {
            if (timeout > 0L) {
                int errorCode = exception.getErrorCode();
                long startTime = System.currentTimeMillis();
                long delay = 100L;
                long elapsed = 0L;
                int count = 1;
                while (true) {
                    log.info((Object)"Repeating #%d (delay=%d, elapsed=%d, timeout=%d) due to: %s", new Object[]{count++, delay, elapsed, timeout, exception.getMessage()});
                    try {
                        return this.sendOnce(sealedRequest);
                    }
                    catch (Exception exp) {
                        exception = ClickHouseException.of(exp.getCause() != null ? exp.getCause() : exp, sealedRequest.getServer());
                        elapsed = System.currentTimeMillis() - startTime;
                        if (exception.getErrorCode() != errorCode || elapsed + delay >= timeout) {
                            log.warn((Object)"Stopped repeating(delay=%d, elapsed=%d, timeout=%d) for %s", new Object[]{delay, elapsed, timeout, exception.getMessage()});
                            break;
                        }
                        try {
                            Thread.sleep(delay);
                            elapsed += delay;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        if (delay >= 1000L) {
                            delay = 1000L;
                            continue;
                        }
                        delay += 100L;
                        continue;
                    }
                    break;
                }
            }
            throw new CompletionException(exception);
        }

        ClickHouseResponse retry(ClickHouseRequest<?> sealedRequest, ClickHouseException exception, int times) {
            for (int i = 1; i <= times; ++i) {
                log.debug((Object)"Retry %d of %d due to: %s", new Object[]{i, times, exception.getMessage()});
                if (exception.getErrorCode() != 210) continue;
                log.info((Object)"Retry request on %s due to connection issue", new Object[]{sealedRequest.getServer()});
                try {
                    return this.sendOnce(sealedRequest);
                }
                catch (Exception exp) {
                    exception = ClickHouseException.of(exp.getCause() != null ? exp.getCause() : exp, sealedRequest.getServer());
                }
            }
            throw new CompletionException(exception);
        }

        ClickHouseResponse handle(ClickHouseRequest<?> sealedRequest, Throwable cause) {
            if (cause instanceof UncheckedIOException && cause.getCause() != null) {
                cause = ((UncheckedIOException)cause).getCause();
            }
            ClickHouseConfig config = sealedRequest.getConfig();
            log.debug((Object)"Handling %s(failover=%d, retry=%d)", new Object[]{cause, config.getFailover(), config.getRetry()});
            ClickHouseException ex = ClickHouseException.of(cause, sealedRequest.getServer());
            try {
                if (config.isRepeatOnSessionLock() && ex.getErrorCode() == 373) {
                    return this.repeat(sealedRequest, ex, config.getSessionTimeout() <= 0 ? (long)config.getConnectionTimeout() : TimeUnit.SECONDS.toMillis(config.getSessionTimeout()));
                }
                int times = sealedRequest.getConfig().getFailover();
                if (times > 0) {
                    return this.failover(sealedRequest, ex, times);
                }
                times = sealedRequest.getConfig().getRetry();
                if (times > 0) {
                    return this.retry(sealedRequest, ex, times);
                }
                throw new CompletionException(cause);
            }
            catch (CompletionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }

        ClickHouseResponse sendOnce(ClickHouseRequest<?> sealedRequest) {
            try {
                return this.getClient().execute(sealedRequest).get(sealedRequest.getConfig().getSocketTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CancellationException("Execution was interrupted");
            }
            catch (ExecutionException | TimeoutException e) {
                throw new CompletionException(e.getCause());
            }
        }

        ClickHouseResponse send(ClickHouseRequest<?> sealedRequest) {
            try {
                return this.sendOnce(sealedRequest);
            }
            catch (Exception e) {
                return this.handle(sealedRequest, e.getCause() != null ? e.getCause() : e);
            }
        }

        @Override
        public boolean accept(ClickHouseProtocol protocol) {
            return this.client.get().accept(protocol);
        }

        @Override
        public Class<? extends ClickHouseOption> getOptionClass() {
            return this.client.get().getOptionClass();
        }

        @Override
        public void init(ClickHouseConfig config) {
            this.client.get().init(config);
        }

        @Override
        public boolean ping(ClickHouseNode server, int timeout) {
            return this.client.get().ping(server, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
            ClickHouseRequest<?> sealedRequest = request.seal();
            ClickHouseNode server = sealedRequest.getServer();
            ClickHouseProtocol protocol = server.getProtocol();
            ClickHouseClient currentClient = this.client.get();
            if (currentClient.accept(protocol)) return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause() != null ? t.getCause() : t)) : CompletableFuture.completedFuture(this.send(sealedRequest));
            ClickHouseClient newClient = null;
            try {
                newClient = ClickHouseClient.builder().agent(false).config(new ClickHouseConfig(currentClient.getConfig(), server.config)).nodeSelector(ClickHouseNodeSelector.of(protocol, new ClickHouseProtocol[0])).build();
                if (newClient == null) return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause() != null ? t.getCause() : t)) : CompletableFuture.completedFuture(this.send(sealedRequest));
            }
            catch (IllegalStateException e) {
                boolean changed;
                try {
                    log.debug((Object)"Failed to find client for %s", new Object[]{server});
                    if (newClient == null) return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause() != null ? t.getCause() : t)) : CompletableFuture.completedFuture(this.send(sealedRequest));
                    changed = this.changeClient(currentClient, newClient);
                }
                catch (Throwable throwable) {
                    if (newClient == null) throw throwable;
                    boolean changed2 = this.changeClient(currentClient, newClient);
                    log.debug((Object)"Switching client from %s to %s: %s", new Object[]{currentClient, newClient, changed2});
                    if (!changed2) throw throwable;
                    sealedRequest.resetCache();
                    throw throwable;
                }
                log.debug((Object)"Switching client from %s to %s: %s", new Object[]{currentClient, newClient, changed});
                if (!changed) return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause() != null ? t.getCause() : t)) : CompletableFuture.completedFuture(this.send(sealedRequest));
                sealedRequest.resetCache();
                return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause() != null ? t.getCause() : t)) : CompletableFuture.completedFuture(this.send(sealedRequest));
            }
            boolean changed = this.changeClient(currentClient, newClient);
            log.debug((Object)"Switching client from %s to %s: %s", new Object[]{currentClient, newClient, changed});
            if (!changed) return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause() != null ? t.getCause() : t)) : CompletableFuture.completedFuture(this.send(sealedRequest));
            sealedRequest.resetCache();
            return sealedRequest.getConfig().isAsync() ? this.getClient().execute(sealedRequest).handle((r, t) -> t == null ? r : this.handle(sealedRequest, t.getCause() != null ? t.getCause() : t)) : CompletableFuture.completedFuture(this.send(sealedRequest));
        }

        @Override
        public ClickHouseConfig getConfig() {
            return this.client.get().getConfig();
        }

        @Override
        public void close() {
            this.client.get().close();
        }
    }

    static class DummyClient
    implements ClickHouseClient {
        static final ClickHouseConfig DEFAULT_CONFIG = new ClickHouseConfig(new ClickHouseConfig[0]);
        private final ClickHouseConfig config;

        DummyClient() {
            this(null);
        }

        DummyClient(ClickHouseConfig config) {
            this.config = config != null ? config : DEFAULT_CONFIG;
        }

        @Override
        public boolean accept(ClickHouseProtocol protocol) {
            return false;
        }

        @Override
        public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
            CompletableFuture<ClickHouseResponse> future = new CompletableFuture<ClickHouseResponse>();
            future.completeExceptionally(new ConnectException("No client available"));
            return future;
        }

        @Override
        public ClickHouseConfig getConfig() {
            return this.config;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean ping(ClickHouseNode server, int timeout) {
            return false;
        }
    }
}

