/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ClickHouseResponse
extends AutoCloseable,
Serializable {
    public static final ClickHouseResponse EMPTY = new ClickHouseResponse(){

        @Override
        public List<ClickHouseColumn> getColumns() {
            return Collections.emptyList();
        }

        @Override
        public ClickHouseResponseSummary getSummary() {
            return ClickHouseResponseSummary.EMPTY;
        }

        @Override
        public ClickHouseInputStream getInputStream() {
            return null;
        }

        @Override
        public Iterable<ClickHouseRecord> records() {
            return Collections.emptyList();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isClosed() {
            return false;
        }
    };

    public List<ClickHouseColumn> getColumns();

    public ClickHouseResponseSummary getSummary();

    public ClickHouseInputStream getInputStream();

    default public ClickHouseRecord firstRecord() {
        return this.records().iterator().next();
    }

    public Iterable<ClickHouseRecord> records();

    default public void pipe(OutputStream output, int bufferSize) throws IOException {
        ClickHouseInputStream.pipe((InputStream)this.getInputStream(), (OutputStream)((OutputStream)ClickHouseChecker.nonNull((Object)output, (String)"output")), (int)ClickHouseDataConfig.getBufferSize((int)bufferSize, (int)((Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue()), (int)((Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue())));
    }

    default public Stream<ClickHouseRecord> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.records().iterator(), 1296), false);
    }

    @Override
    public void close();

    public boolean isClosed();
}

