/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ClickHouseByteBuffer
implements Serializable {
    private static final long serialVersionUID = -8178041799873465082L;
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY_BYTES).asReadOnlyBuffer();
    protected byte[] array;
    protected int position;
    protected int length;

    public static ClickHouseByteBuffer newInstance() {
        return new ClickHouseByteBuffer(EMPTY_BYTES, 0, 0);
    }

    public static ClickHouseByteBuffer of(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? ClickHouseByteBuffer.newInstance() : new ClickHouseByteBuffer(bytes, 0, bytes.length);
    }

    public static ClickHouseByteBuffer of(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return ClickHouseByteBuffer.newInstance();
        }
        ClickHouseByteBuffer.validate(bytes, offset, length);
        return new ClickHouseByteBuffer(bytes, offset, length);
    }

    static void validate(byte[] bytes, int offset, int length) {
        int len = ClickHouseChecker.nonNull(bytes, "Byte array").length;
        if (ClickHouseChecker.between(offset, "Offset", 0, len) + ClickHouseChecker.between(length, "Length", 0, len) > len) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Offset(%d) plus length(%d) should not greater than %d", offset, length, len));
        }
    }

    protected ClickHouseByteBuffer(byte[] bytes, int offset, int length) {
        this.array = bytes;
        this.position = offset;
        this.length = length;
    }

    public boolean isEmpty() {
        return this.length < 1;
    }

    public ClickHouseByteBuffer reset() {
        this.array = EMPTY_BYTES;
        this.position = 0;
        this.length = 0;
        return this;
    }

    public ClickHouseByteBuffer update(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.reset();
        } else {
            this.array = bytes;
            this.position = 0;
            this.length = bytes.length;
        }
        return this;
    }

    public ClickHouseByteBuffer update(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return this.reset();
        }
        ClickHouseByteBuffer.validate(bytes, offset, length);
        this.array = bytes;
        this.position = offset;
        this.length = length;
        return this;
    }

    public byte[] array() {
        return this.array;
    }

    public int position() {
        return this.position;
    }

    public int length() {
        return this.length;
    }

    public int limit() {
        return this.position + this.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.array);
        result = 31 * result + this.position;
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseByteBuffer other = (ClickHouseByteBuffer)obj;
        return Arrays.equals(this.array, other.array) && this.position == other.position && this.length == other.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "array=" + this.array + ", position=" + this.position + ", length=" + this.length + ')';
    }
}

