/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data.array;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ClickHouseShortArrayValue
extends ClickHouseObjectValue<short[]> {
    private static final String TYPE_NAME = "short[]";

    public static ClickHouseShortArrayValue ofEmpty() {
        return ClickHouseShortArrayValue.of(ClickHouseValues.EMPTY_SHORT_ARRAY);
    }

    public static ClickHouseShortArrayValue of(short[] value) {
        return ClickHouseShortArrayValue.of(null, value);
    }

    public static ClickHouseShortArrayValue of(ClickHouseValue ref, short[] value) {
        return ref instanceof ClickHouseShortArrayValue ? ((ClickHouseShortArrayValue)ref).set(value) : new ClickHouseShortArrayValue(value);
    }

    protected ClickHouseShortArrayValue(short[] value) {
        super(value);
    }

    protected ClickHouseShortArrayValue set(short[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        short[] v = (short[])this.getValue();
        int len = v.length;
        Object[] array = new Short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = v[i];
        }
        return array;
    }

    public <E> E[] asArray(Class<E> clazz) {
        short[] v = (short[])this.getValue();
        int len = v.length;
        E[] array = ClickHouseValues.createObjectArray(clazz, len, 1);
        for (int i = 0; i < len; ++i) {
            array[i] = clazz.cast(v[i]);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        short[] v = (short[])this.getValue();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < v.length; ++i) {
            map.put(keyClass.cast(i + 1), valueClass.cast(v[i]));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        String str = Arrays.toString((short[])this.getValue());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseShortArrayValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseShortArrayValue((short[])this.getValue());
        }
        short[] value = (short[])this.getValue();
        return new ClickHouseShortArrayValue(Arrays.copyOf(value, value.length));
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((short[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseShortArrayValue resetToNullOrEmpty() {
        this.set(ClickHouseValues.EMPTY_SHORT_ARRAY);
        return this;
    }

    @Override
    public String toSqlExpression() {
        int len;
        short[] value = (short[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (int i = 0; i < len; ++i) {
            builder.append(value[i]).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseShortArrayValue update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] ? (short)1 : 0;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (short)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(byte value) {
        return this.set(new short[]{value});
    }

    @Override
    public ClickHouseShortArrayValue update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(short value) {
        return this.set(new short[]{value});
    }

    @Override
    public ClickHouseShortArrayValue update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Arrays.copyOf(value, len));
    }

    @Override
    public ClickHouseShortArrayValue update(int value) {
        return this.set(new short[]{(short)value});
    }

    @Override
    public ClickHouseShortArrayValue update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (short)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(long value) {
        return this.set(new short[]{(short)value});
    }

    @Override
    public ClickHouseShortArrayValue update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (short)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(float value) {
        return this.set(new short[]{(short)value});
    }

    @Override
    public ClickHouseShortArrayValue update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (short)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(double value) {
        return this.set(new short[]{(short)value});
    }

    @Override
    public ClickHouseShortArrayValue update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (short)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(BigInteger value) {
        short[] sArray;
        if (value == null) {
            sArray = ClickHouseValues.EMPTY_SHORT_ARRAY;
        } else {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = value.shortValue();
        }
        return this.set(sArray);
    }

    @Override
    public ClickHouseShortArrayValue update(BigDecimal value) {
        short[] sArray;
        if (value == null) {
            sArray = ClickHouseValues.EMPTY_SHORT_ARRAY;
        } else {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = value.shortValue();
        }
        return this.set(sArray);
    }

    @Override
    public ClickHouseShortArrayValue update(Enum<?> value) {
        short[] sArray;
        if (value == null) {
            sArray = ClickHouseValues.EMPTY_SHORT_ARRAY;
        } else {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = (short)value.ordinal();
        }
        return this.set(sArray);
    }

    @Override
    public ClickHouseShortArrayValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet4Address", TYPE_NAME);
    }

    @Override
    public ClickHouseShortArrayValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet6Address", TYPE_NAME);
    }

    @Override
    public ClickHouseShortArrayValue update(LocalDate value) {
        short[] sArray;
        if (value == null) {
            sArray = ClickHouseValues.EMPTY_SHORT_ARRAY;
        } else {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = (short)value.toEpochDay();
        }
        return this.set(sArray);
    }

    @Override
    public ClickHouseShortArrayValue update(LocalTime value) {
        short[] sArray;
        if (value == null) {
            sArray = ClickHouseValues.EMPTY_SHORT_ARRAY;
        } else {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = (short)value.toSecondOfDay();
        }
        return this.set(sArray);
    }

    @Override
    public ClickHouseShortArrayValue update(LocalDateTime value) {
        short[] sArray;
        if (value == null) {
            sArray = ClickHouseValues.EMPTY_SHORT_ARRAY;
        } else {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = (short)value.toEpochSecond(ZoneOffset.UTC);
        }
        return this.set(sArray);
    }

    @Override
    public ClickHouseShortArrayValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o == null ? (short)0 : ((Number)o).shortValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList<Number> v = new LinkedList<Number>();
        while (value.hasMoreElements()) {
            v.add((Number)value.nextElement());
        }
        short[] values = new short[v.size()];
        int index = 0;
        for (Number n : v) {
            values[index++] = n == null ? (short)0 : n.shortValue();
        }
        return this.set(values);
    }

    @Override
    public ClickHouseShortArrayValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] v = new short[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object o = e.getValue();
            v[index++] = o == null ? (short)0 : ((Number)e.getValue()).shortValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseShortArrayValue update(String value) {
        if (ClickHouseChecker.isNullOrBlank(value)) {
            this.set(ClickHouseValues.EMPTY_SHORT_ARRAY);
        } else {
            List<String> list = ClickHouseUtils.readValueArray(value, 0, value.length());
            if (list.isEmpty()) {
                this.set(ClickHouseValues.EMPTY_SHORT_ARRAY);
            } else {
                short[] arr = new short[list.size()];
                int index = 0;
                for (String v : list) {
                    arr[index++] = Short.parseShort(v);
                }
                this.set(arr);
            }
        }
        return this;
    }

    @Override
    public ClickHouseShortArrayValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("UUID", TYPE_NAME);
    }

    @Override
    public ClickHouseShortArrayValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseShortArrayValue) {
            this.set((short[])((ClickHouseShortArrayValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseShortArrayValue update(Object[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        short[] values = new short[len];
        for (int i = 0; i < len; ++i) {
            Object o = value[i];
            values[i] = o == null ? (short)0 : ((Number)o).shortValue();
        }
        this.set(values);
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Number) {
            return this.set(new short[]{((Number)value).shortValue()});
        }
        throw this.newUnsupportedException(value.getClass().getName(), TYPE_NAME);
    }

    @Override
    public ClickHouseShortArrayValue update(Object value) {
        if (value instanceof short[]) {
            this.set((short[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals((short[])this.getValue(), (short[])((ClickHouseShortArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((short[])this.getValue());
    }
}

