/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseAggregateFunction;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataProcessor;
import com.clickhouse.client.ClickHouseDataType;
import com.clickhouse.client.ClickHouseDeserializer;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseSerializer;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseBigDecimalValue;
import com.clickhouse.client.data.ClickHouseBigIntegerValue;
import com.clickhouse.client.data.ClickHouseBitmap;
import com.clickhouse.client.data.ClickHouseBitmapValue;
import com.clickhouse.client.data.ClickHouseBoolValue;
import com.clickhouse.client.data.ClickHouseByteValue;
import com.clickhouse.client.data.ClickHouseDateTimeValue;
import com.clickhouse.client.data.ClickHouseDateValue;
import com.clickhouse.client.data.ClickHouseDoubleValue;
import com.clickhouse.client.data.ClickHouseEnumValue;
import com.clickhouse.client.data.ClickHouseFloatValue;
import com.clickhouse.client.data.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.client.data.ClickHouseGeoPointValue;
import com.clickhouse.client.data.ClickHouseGeoPolygonValue;
import com.clickhouse.client.data.ClickHouseGeoRingValue;
import com.clickhouse.client.data.ClickHouseIntegerValue;
import com.clickhouse.client.data.ClickHouseIpv4Value;
import com.clickhouse.client.data.ClickHouseIpv6Value;
import com.clickhouse.client.data.ClickHouseLongValue;
import com.clickhouse.client.data.ClickHouseMapValue;
import com.clickhouse.client.data.ClickHouseNestedValue;
import com.clickhouse.client.data.ClickHouseOffsetDateTimeValue;
import com.clickhouse.client.data.ClickHouseShortValue;
import com.clickhouse.client.data.ClickHouseSimpleRecord;
import com.clickhouse.client.data.ClickHouseStringValue;
import com.clickhouse.client.data.ClickHouseTupleValue;
import com.clickhouse.client.data.ClickHouseUuidValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class ClickHouseRowBinaryProcessor
extends ClickHouseDataProcessor {
    public static MappedFunctions getMappedFunctions() {
        return MappedFunctions.instance;
    }

    @Override
    protected List<ClickHouseColumn> readColumns() throws IOException {
        if (!this.config.getFormat().hasHeader()) {
            return Collections.emptyList();
        }
        int size = 0;
        try {
            size = this.input.readVarInt();
        }
        catch (EOFException e) {
            return Collections.emptyList();
        }
        String[] names = new String[ClickHouseChecker.between(size, "size", 0, Integer.MAX_VALUE)];
        for (int i = 0; i < size; ++i) {
            names[i] = this.input.readUnicodeString();
        }
        ArrayList<ClickHouseColumn> columns = new ArrayList<ClickHouseColumn>(size);
        for (int i = 0; i < size; ++i) {
            columns.add(ClickHouseColumn.of(names[i], this.input.readAsciiString()));
        }
        return columns;
    }

    public ClickHouseRowBinaryProcessor(ClickHouseConfig config, ClickHouseInputStream input, OutputStream output, List<ClickHouseColumn> columns, Map<String, Object> settings) throws IOException {
        super(config, input, output, columns, settings);
    }

    @Override
    public Iterable<ClickHouseRecord> records() {
        return this.columns.isEmpty() ? Collections.emptyList() : new Iterable<ClickHouseRecord>(){

            @Override
            public Iterator<ClickHouseRecord> iterator() {
                return new Records();
            }
        };
    }

    private class Records
    implements Iterator<ClickHouseRecord> {
        private final Supplier<ClickHouseSimpleRecord> factory;
        private ClickHouseSimpleRecord record;

        Records() {
            int size = ClickHouseRowBinaryProcessor.this.columns.size();
            if (ClickHouseRowBinaryProcessor.this.config.isReuseValueWrapper()) {
                ClickHouseValue[] values = new ClickHouseValue[size];
                this.record = new ClickHouseSimpleRecord(ClickHouseRowBinaryProcessor.this.columns, values);
                this.factory = () -> this.record;
            } else {
                this.factory = () -> new ClickHouseSimpleRecord(ClickHouseRowBinaryProcessor.this.columns, new ClickHouseValue[size]);
            }
        }

        ClickHouseRecord readNextRow() {
            int index;
            int size = ClickHouseRowBinaryProcessor.this.columns.size();
            ClickHouseSimpleRecord currentRow = this.factory.get();
            ClickHouseValue[] values = currentRow.getValues();
            ClickHouseColumn column = null;
            try {
                MappedFunctions m = ClickHouseRowBinaryProcessor.getMappedFunctions();
                for (index = 0; index < size; ++index) {
                    column = (ClickHouseColumn)ClickHouseRowBinaryProcessor.this.columns.get(index);
                    values[index] = m.deserialize(values[index], ClickHouseRowBinaryProcessor.this.config, column, ClickHouseRowBinaryProcessor.this.input);
                }
            }
            catch (EOFException e) {
                if (index == 0) {
                    values = null;
                }
                throw new UncheckedIOException(ClickHouseUtils.format("Reached end of the stream when reading column #%d(total %d): %s", index + 1, size, column), e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(ClickHouseUtils.format("Failed to read column #%d(total %d): %s", index + 1, size, column), e);
            }
            return currentRow;
        }

        @Override
        public boolean hasNext() {
            try {
                return ClickHouseRowBinaryProcessor.this.input.available() > 0;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public ClickHouseRecord next() {
            ClickHouseRecord r = this.readNextRow();
            if (r == null) {
                throw new NoSuchElementException("No more record");
            }
            return r;
        }
    }

    public static class MappedFunctions {
        private static final MappedFunctions instance = new MappedFunctions();
        private final Map<ClickHouseAggregateFunction, ClickHouseDeserializer<ClickHouseValue>> aggDeserializers = new EnumMap<ClickHouseAggregateFunction, ClickHouseDeserializer<ClickHouseValue>>(ClickHouseAggregateFunction.class);
        private final Map<ClickHouseAggregateFunction, ClickHouseSerializer<ClickHouseValue>> aggSerializers = new EnumMap<ClickHouseAggregateFunction, ClickHouseSerializer<ClickHouseValue>>(ClickHouseAggregateFunction.class);
        private final Map<ClickHouseDataType, ClickHouseDeserializer<? extends ClickHouseValue>> deserializers = new EnumMap<ClickHouseDataType, ClickHouseDeserializer<? extends ClickHouseValue>>(ClickHouseDataType.class);
        private final Map<ClickHouseDataType, ClickHouseSerializer<? extends ClickHouseValue>> serializers = new EnumMap<ClickHouseDataType, ClickHouseSerializer<? extends ClickHouseValue>>(ClickHouseDataType.class);

        private void writeArray(ClickHouseValue value, ClickHouseConfig config, ClickHouseColumn column, OutputStream output) throws IOException {
            ClickHouseColumn nestedColumn = column.getNestedColumns().get(0);
            ClickHouseColumn baseColumn = column.getArrayBaseColumn();
            int level = column.getArrayNestedLevel();
            Class<?> javaClass = baseColumn.getDataType().getPrimitiveClass();
            if (level > 1 || !javaClass.isPrimitive()) {
                Object[] array = value.asArray();
                ClickHouseValue v = ClickHouseValues.newValue(config, nestedColumn);
                int length = array.length;
                BinaryStreamUtils.writeVarInt(output, (long)length);
                for (int i = 0; i < length; ++i) {
                    this.serialize(v.update(array[i]), config, nestedColumn, output);
                }
            } else {
                ClickHouseValue v = ClickHouseValues.newValue(config, baseColumn);
                if (Byte.TYPE == javaClass) {
                    byte[] array = (byte[])value.asObject();
                    int length = array.length;
                    BinaryStreamUtils.writeVarInt(output, (long)length);
                    for (int i = 0; i < length; ++i) {
                        this.serialize(v.update(array[i]), config, baseColumn, output);
                    }
                } else if (Short.TYPE == javaClass) {
                    short[] array = (short[])value.asObject();
                    int length = array.length;
                    BinaryStreamUtils.writeVarInt(output, (long)length);
                    for (int i = 0; i < length; ++i) {
                        this.serialize(v.update(array[i]), config, baseColumn, output);
                    }
                } else if (Integer.TYPE == javaClass) {
                    int[] array = (int[])value.asObject();
                    int length = array.length;
                    BinaryStreamUtils.writeVarInt(output, (long)length);
                    for (int i = 0; i < length; ++i) {
                        this.serialize(v.update(array[i]), config, baseColumn, output);
                    }
                } else if (Long.TYPE == javaClass) {
                    long[] array = (long[])value.asObject();
                    int length = array.length;
                    BinaryStreamUtils.writeVarInt(output, (long)length);
                    for (int i = 0; i < length; ++i) {
                        this.serialize(v.update(array[i]), config, baseColumn, output);
                    }
                } else if (Float.TYPE == javaClass) {
                    float[] array = (float[])value.asObject();
                    int length = array.length;
                    BinaryStreamUtils.writeVarInt(output, (long)length);
                    for (int i = 0; i < length; ++i) {
                        this.serialize(v.update(array[i]), config, baseColumn, output);
                    }
                } else if (Double.TYPE == javaClass) {
                    double[] array = (double[])value.asObject();
                    int length = array.length;
                    BinaryStreamUtils.writeVarInt(output, (long)length);
                    for (int i = 0; i < length; ++i) {
                        this.serialize(v.update(array[i]), config, baseColumn, output);
                    }
                } else {
                    throw new IllegalArgumentException("Unsupported primitive type: " + javaClass);
                }
            }
        }

        private ClickHouseValue readArray(ClickHouseValue ref, ClickHouseConfig config, ClickHouseColumn nestedColumn, ClickHouseColumn baseColumn, ClickHouseInputStream input, int length, int level) throws IOException {
            Class<?> javaClass = baseColumn.getDataType().getPrimitiveClass();
            if (level > 1 || !javaClass.isPrimitive()) {
                Object[] array = (Object[])ClickHouseValues.createPrimitiveArray(javaClass, length, level);
                for (int i = 0; i < length; ++i) {
                    array[i] = this.deserialize(null, config, nestedColumn, input).asObject();
                }
                ref.update(array);
            } else if (Byte.TYPE == javaClass) {
                byte[] array = new byte[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = this.deserialize(null, config, baseColumn, input).asByte();
                }
                ref.update(array);
            } else if (Short.TYPE == javaClass) {
                short[] array = new short[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = this.deserialize(null, config, baseColumn, input).asShort();
                }
                ref.update(array);
            } else if (Integer.TYPE == javaClass) {
                int[] array = new int[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = this.deserialize(null, config, baseColumn, input).asInteger();
                }
                ref.update(array);
            } else if (Long.TYPE == javaClass) {
                long[] array = new long[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = this.deserialize(null, config, baseColumn, input).asLong();
                }
                ref.update(array);
            } else if (Float.TYPE == javaClass) {
                float[] array = new float[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = this.deserialize(null, config, baseColumn, input).asFloat();
                }
                ref.update(array);
            } else if (Double.TYPE == javaClass) {
                double[] array = new double[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = this.deserialize(null, config, baseColumn, input).asDouble();
                }
                ref.update(array);
            } else {
                throw new IllegalArgumentException("Unsupported primitive type: " + javaClass);
            }
            return ref;
        }

        private void buildMappingsForAggregateFunctions() {
            ClickHouseRowBinaryProcessor.buildAggMappings(this.aggDeserializers, this.aggSerializers, (r, f, c, i) -> ClickHouseBitmapValue.of(BinaryStreamUtils.readBitmap(i, c.getNestedColumns().get(0).getDataType())), (v, f, c, o) -> BinaryStreamUtils.writeBitmap(o, v.asObject(ClickHouseBitmap.class)), new ClickHouseAggregateFunction[]{ClickHouseAggregateFunction.groupBitmap});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> this.aggDeserializers.getOrDefault((Object)c.getAggregateFunction(), ClickHouseDeserializer.NOT_SUPPORTED).deserialize(r, f, c, i), (ClickHouseSerializer)(v, f, c, o) -> this.aggSerializers.getOrDefault((Object)c.getAggregateFunction(), ClickHouseSerializer.NOT_SUPPORTED).serialize(v, f, c, o), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.AggregateFunction});
        }

        private void buildMappingsForDataTypes() {
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseEnumValue.of(r, c.getEnumConstants(), BinaryStreamUtils.readInt8(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt8(o, v.asByte()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Enum, ClickHouseDataType.Enum8});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseEnumValue.of(r, c.getEnumConstants(), BinaryStreamUtils.readInt16(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt16(o, v.asShort()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Enum16});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBoolValue.of(r, BinaryStreamUtils.readBoolean(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeBoolean(o, v.asBoolean()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Bool});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseByteValue.of(r, BinaryStreamUtils.readInt8(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt8(o, v.asByte()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Int8});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseShortValue.of(r, BinaryStreamUtils.readUnsignedInt8(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeUnsignedInt8(o, v.asInteger()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.UInt8});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseShortValue.of(r, BinaryStreamUtils.readInt16(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt16(o, v.asShort()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Int16});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseIntegerValue.of(r, BinaryStreamUtils.readUnsignedInt16(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeUnsignedInt16(o, v.asInteger()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.UInt16});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseIntegerValue.of(r, BinaryStreamUtils.readInt32(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt32(o, v.asInteger()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Int32});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseLongValue.of(r, false, BinaryStreamUtils.readUnsignedInt32(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeUnsignedInt32(o, v.asLong()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.UInt32});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseLongValue.of(r, false, BinaryStreamUtils.readInt64(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt64(o, v.asLong()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.IntervalYear, ClickHouseDataType.IntervalQuarter, ClickHouseDataType.IntervalMonth, ClickHouseDataType.IntervalWeek, ClickHouseDataType.IntervalDay, ClickHouseDataType.IntervalHour, ClickHouseDataType.IntervalMinute, ClickHouseDataType.IntervalSecond, ClickHouseDataType.Int64});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseLongValue.of(r, true, BinaryStreamUtils.readInt64(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt64(o, v.asLong()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.UInt64});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigIntegerValue.of(r, BinaryStreamUtils.readInt128(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt128(o, v.asBigInteger()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Int128});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigIntegerValue.of(r, BinaryStreamUtils.readUnsignedInt128(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeUnsignedInt128(o, v.asBigInteger()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.UInt128});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigIntegerValue.of(r, BinaryStreamUtils.readInt256(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInt256(o, v.asBigInteger()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Int256});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigIntegerValue.of(r, BinaryStreamUtils.readUnsignedInt256(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeUnsignedInt256(o, v.asBigInteger()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.UInt256});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseFloatValue.of(r, BinaryStreamUtils.readFloat32(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeFloat32(o, v.asFloat()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Float32});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseDoubleValue.of(r, BinaryStreamUtils.readFloat64(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeFloat64(o, v.asDouble()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Float64});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigDecimalValue.of(r, BinaryStreamUtils.readDecimal(i, c.getPrecision(), c.getScale())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDecimal(o, v.asBigDecimal(c.getScale()), c.getPrecision(), c.getScale()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Decimal});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigDecimalValue.of(r, BinaryStreamUtils.readDecimal32(i, c.getScale())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDecimal32(o, v.asBigDecimal(c.getScale()), c.getScale()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Decimal32});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigDecimalValue.of(r, BinaryStreamUtils.readDecimal64(i, c.getScale())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDecimal64(o, v.asBigDecimal(c.getScale()), c.getScale()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Decimal64});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigDecimalValue.of(r, BinaryStreamUtils.readDecimal128(i, c.getScale())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDecimal128(o, v.asBigDecimal(c.getScale()), c.getScale()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Decimal128});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseBigDecimalValue.of(r, BinaryStreamUtils.readDecimal256(i, c.getScale())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDecimal256(o, v.asBigDecimal(c.getScale()), c.getScale()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Decimal256});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseDateValue.of(r, BinaryStreamUtils.readDate(i, f.getTimeZoneForDate())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDate(o, v.asDate(), f.getTimeZoneForDate()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Date});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseDateValue.of(r, BinaryStreamUtils.readDate32(i, f.getTimeZoneForDate())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDate(o, v.asDate(), f.getTimeZoneForDate()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Date32});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> c.getTimeZone() == null ? ClickHouseDateTimeValue.of(r, c.getScale() > 0 ? BinaryStreamUtils.readDateTime64(i, c.getScale(), f.getUseTimeZone()) : BinaryStreamUtils.readDateTime(i, f.getUseTimeZone()), c.getScale(), f.getUseTimeZone()) : ClickHouseOffsetDateTimeValue.of(r, c.getScale() > 0 ? BinaryStreamUtils.readDateTime64(i, c.getScale(), c.getTimeZone()) : BinaryStreamUtils.readDateTime(i, c.getTimeZone()), c.getScale(), c.getTimeZone()), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDateTime(o, v.asDateTime(), c.getScale(), c.getTimeZoneOrDefault(f.getUseTimeZone())), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.DateTime});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> c.getTimeZone() == null ? ClickHouseDateTimeValue.of(r, BinaryStreamUtils.readDateTime(i, f.getUseTimeZone()), 0, f.getUseTimeZone()) : ClickHouseOffsetDateTimeValue.of(r, BinaryStreamUtils.readDateTime(i, c.getTimeZone()), 0, c.getTimeZone()), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDateTime32(o, v.asDateTime(), c.getTimeZoneOrDefault(f.getUseTimeZone())), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.DateTime32});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> c.getTimeZone() == null ? ClickHouseDateTimeValue.of(r, BinaryStreamUtils.readDateTime64(i, c.getScale(), f.getUseTimeZone()), c.getScale(), f.getUseTimeZone()) : ClickHouseOffsetDateTimeValue.of(r, BinaryStreamUtils.readDateTime64(i, c.getScale(), c.getTimeZone()), c.getScale(), c.getTimeZone()), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeDateTime64(o, v.asDateTime(), c.getScale(), c.getTimeZoneOrDefault(f.getUseTimeZone())), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.DateTime64});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseIpv4Value.of(r, BinaryStreamUtils.readInet4Address(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInet4Address(o, v.asInet4Address()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.IPv4});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseIpv6Value.of(r, BinaryStreamUtils.readInet6Address(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeInet6Address(o, v.asInet6Address()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.IPv6});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseStringValue.of(r, i.readBytes(c.getPrecision())), (ClickHouseSerializer)(v, f, c, o) -> o.write(v.asBinary(c.getPrecision())), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.FixedString});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseStringValue.of(r, i.readBytes(i.readVarInt())), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeString(o, v.asBinary()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.String});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseUuidValue.of(r, BinaryStreamUtils.readUuid(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeUuid(o, v.asUuid()), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.UUID});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseGeoPointValue.of(r, BinaryStreamUtils.readGeoPoint(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeGeoPoint(o, v.asObject(double[].class)), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Point});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseGeoRingValue.of(r, BinaryStreamUtils.readGeoRing(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeGeoRing(o, v.asObject(double[][].class)), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Ring});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseGeoPolygonValue.of(r, BinaryStreamUtils.readGeoPolygon(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeGeoPolygon(o, v.asObject(double[][][].class)), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Polygon});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> ClickHouseGeoMultiPolygonValue.of(r, BinaryStreamUtils.readGeoMultiPolygon(i)), (ClickHouseSerializer)(v, f, c, o) -> BinaryStreamUtils.writeGeoMultiPolygon(o, v.asObject(double[][][][].class)), (Enum[])new ClickHouseDataType[]{ClickHouseDataType.MultiPolygon});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> {
                int length = BinaryStreamUtils.readVarInt(i);
                if (r == null) {
                    r = ClickHouseValues.newValue(f, c);
                }
                return this.readArray(r, f, c.getNestedColumns().get(0), c.getArrayBaseColumn(), i, length, c.getArrayNestedLevel());
            }, (ClickHouseSerializer)this::writeArray, (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Array});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> {
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                ClickHouseColumn keyCol = c.getKeyInfo();
                ClickHouseColumn valCol = c.getValueInfo();
                int len = BinaryStreamUtils.readVarInt(i);
                for (int k = 0; k < len; ++k) {
                    map.put(this.deserialize(null, f, keyCol, i).asObject(), this.deserialize(null, f, valCol, i).asObject());
                }
                return ClickHouseMapValue.of(map, valCol.getDataType().getObjectClass(), valCol.getDataType().getObjectClass());
            }, (ClickHouseSerializer)(v, f, c, o) -> {
                Map<Object, Object> map = v.asMap();
                BinaryStreamUtils.writeVarInt(o, (long)map.size());
                if (!map.isEmpty()) {
                    ClickHouseColumn keyCol = c.getKeyInfo();
                    ClickHouseColumn valCol = c.getValueInfo();
                    ClickHouseValue kVal = ClickHouseValues.newValue(f, keyCol);
                    ClickHouseValue vVal = ClickHouseValues.newValue(f, valCol);
                    for (Map.Entry<Object, Object> e : map.entrySet()) {
                        this.serialize(kVal.update(e.getKey()), f, keyCol, o);
                        this.serialize(vVal.update(e.getValue()), f, valCol, o);
                    }
                }
            }, (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Map});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> {
                int count = c.getNestedColumns().size();
                String[] names = new String[count];
                Object[][] values = new Object[count][];
                int l = 0;
                for (ClickHouseColumn col : c.getNestedColumns()) {
                    names[l] = col.getColumnName();
                    int k = BinaryStreamUtils.readVarInt(i);
                    Object[] nvalues = new Object[k];
                    for (int j = 0; j < k; ++j) {
                        nvalues[j] = this.deserialize(null, f, col, i).asObject();
                    }
                    values[l++] = nvalues;
                }
                return ClickHouseNestedValue.of(r, c.getNestedColumns(), values);
            }, (ClickHouseSerializer)(v, f, c, o) -> {
                Object[][] values = (Object[][])v.asObject();
                int l = 0;
                for (ClickHouseColumn col : c.getNestedColumns()) {
                    Object[] nvalues = values[l++];
                    int k = nvalues.length;
                    ClickHouseValue nv = ClickHouseValues.newValue(f, col);
                    BinaryStreamUtils.writeVarInt(o, (long)k);
                    for (int j = 0; j < k; ++j) {
                        this.serialize(nv.update(nvalues[j]), f, col, o);
                    }
                }
            }, (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Nested});
            ClickHouseRowBinaryProcessor.buildMappings((Map)this.deserializers, (Map)this.serializers, (ClickHouseDeserializer)(r, f, c, i) -> {
                ArrayList<Object> tupleValues = new ArrayList<Object>(c.getNestedColumns().size());
                for (ClickHouseColumn col : c.getNestedColumns()) {
                    tupleValues.add(this.deserialize(null, f, col, i).asObject());
                }
                return ClickHouseTupleValue.of(r, tupleValues);
            }, (ClickHouseSerializer)(v, f, c, o) -> {
                List<Object> tupleValues = v.asTuple();
                Iterator<Object> tupleIterator = tupleValues.iterator();
                for (ClickHouseColumn col : c.getNestedColumns()) {
                    ClickHouseValue tv = ClickHouseValues.newValue(f, col);
                    if (tupleIterator.hasNext()) {
                        this.serialize(tv.update(tupleIterator.next()), f, col, o);
                        continue;
                    }
                    this.serialize(tv, f, col, o);
                }
            }, (Enum[])new ClickHouseDataType[]{ClickHouseDataType.Tuple});
        }

        private MappedFunctions() {
            this.buildMappingsForAggregateFunctions();
            this.buildMappingsForDataTypes();
        }

        public ClickHouseValue deserialize(ClickHouseValue ref, ClickHouseConfig config, ClickHouseColumn column, ClickHouseInputStream input) throws IOException {
            if (column.isNullable() && BinaryStreamUtils.readNull(input)) {
                return ref == null ? ClickHouseValues.newValue(config, column) : ref.resetToNullOrEmpty();
            }
            ClickHouseDeserializer<? extends ClickHouseValue> func = this.deserializers.get((Object)column.getDataType());
            if (func == null) {
                throw new IllegalArgumentException("Unsupported data type: " + column.getDataType().name());
            }
            return func.deserialize(ref, config, column, input);
        }

        public void serialize(ClickHouseValue value, ClickHouseConfig config, ClickHouseColumn column, OutputStream output) throws IOException {
            ClickHouseSerializer<? extends ClickHouseValue> func;
            if (column.isNullable()) {
                if (value.isNullOrEmpty()) {
                    BinaryStreamUtils.writeNull(output);
                    return;
                }
                BinaryStreamUtils.writeNonNull(output);
            }
            if ((func = this.serializers.get((Object)column.getDataType())) == null) {
                throw new IllegalArgumentException("Unsupported data type: " + column.getDataType().name());
            }
            func.serialize(value, config, column, output);
        }
    }
}

