/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseAggregateFunction;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDeserializer;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseSerializer;
import com.clickhouse.client.ClickHouseValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ClickHouseDataProcessor {
    public static final List<ClickHouseColumn> DEFAULT_COLUMNS = Collections.singletonList(ClickHouseColumn.of("results", "Nullable(String)"));
    protected static final String ERROR_UNKNOWN_DATA_TYPE = "Unsupported data type: ";
    protected final ClickHouseConfig config;
    protected final ClickHouseInputStream input;
    protected final OutputStream output;
    protected final List<ClickHouseColumn> columns;
    protected final Map<String, Object> settings;

    protected static void buildAggMappings(Map<ClickHouseAggregateFunction, ClickHouseDeserializer<ClickHouseValue>> deserializers, Map<ClickHouseAggregateFunction, ClickHouseSerializer<ClickHouseValue>> serializers, ClickHouseDeserializer<ClickHouseValue> d, ClickHouseSerializer<ClickHouseValue> s, ClickHouseAggregateFunction ... types) {
        for (ClickHouseAggregateFunction t : types) {
            if (deserializers.put(t, d) != null) {
                throw new IllegalArgumentException("Duplicated deserializer of AggregateFunction - " + t.name());
            }
            if (serializers.put(t, s) == null) continue;
            throw new IllegalArgumentException("Duplicated serializer of AggregateFunction - " + t.name());
        }
    }

    protected static <E extends Enum<E>, T extends ClickHouseValue> void buildMappings(Map<E, ClickHouseDeserializer<? extends ClickHouseValue>> deserializers, Map<E, ClickHouseSerializer<? extends ClickHouseValue>> serializers, ClickHouseDeserializer<T> d, ClickHouseSerializer<T> s, E ... types) {
        for (E t : types) {
            if (deserializers.put(t, d) != null) {
                throw new IllegalArgumentException("Duplicated deserializer of: " + ((Enum)t).name());
            }
            if (serializers.put(t, s) == null) continue;
            throw new IllegalArgumentException("Duplicated serializer of: " + ((Enum)t).name());
        }
    }

    protected abstract List<ClickHouseColumn> readColumns() throws IOException;

    protected ClickHouseDataProcessor(ClickHouseConfig config, ClickHouseInputStream input, OutputStream output, List<ClickHouseColumn> columns, Map<String, Object> settings) throws IOException {
        this.config = ClickHouseChecker.nonNull(config, "config");
        if (input == null && output == null) {
            throw new IllegalArgumentException("One of input and output stream must be non-null");
        }
        this.input = input;
        this.output = output;
        if (settings == null || settings.isEmpty()) {
            this.settings = Collections.emptyMap();
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(settings);
            this.settings = Collections.unmodifiableMap(map);
        }
        if (columns == null && input != null) {
            columns = this.readColumns();
        }
        if (columns == null || columns.isEmpty()) {
            this.columns = Collections.emptyList();
        } else {
            ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(columns.size());
            list.addAll(columns);
            this.columns = Collections.unmodifiableList(list);
        }
    }

    public final List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    public abstract Iterable<ClickHouseRecord> records();
}

