/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public class ClickHouseStringValue
implements ClickHouseValue {
    private boolean binary;
    private byte[] bytes;
    private String value;

    public static ClickHouseStringValue ofNull() {
        return ClickHouseStringValue.ofNull(null);
    }

    public static ClickHouseStringValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseStringValue ? ((ClickHouseStringValue)ref).set((String)null) : new ClickHouseStringValue((String)null);
    }

    public static ClickHouseStringValue of(String value) {
        return ClickHouseStringValue.of(null, value);
    }

    public static ClickHouseStringValue of(byte[] bytes) {
        return ClickHouseStringValue.of(null, bytes);
    }

    public static ClickHouseStringValue of(ClickHouseValue ref, String value) {
        return ref instanceof ClickHouseStringValue ? ((ClickHouseStringValue)ref).set(value) : new ClickHouseStringValue(value);
    }

    public static ClickHouseStringValue of(ClickHouseValue ref, byte[] bytes) {
        return ref instanceof ClickHouseStringValue ? ((ClickHouseStringValue)ref).set(bytes) : new ClickHouseStringValue(bytes);
    }

    protected ClickHouseStringValue(String value) {
        this.update(value);
    }

    protected ClickHouseStringValue(byte[] bytes) {
        this.update(bytes);
    }

    protected ClickHouseStringValue set(String value) {
        this.binary = false;
        this.bytes = null;
        this.value = value;
        return this;
    }

    protected ClickHouseStringValue set(byte[] bytes) {
        this.binary = true;
        this.bytes = bytes;
        this.value = null;
        return this;
    }

    @Override
    public ClickHouseStringValue copy(boolean deep) {
        if (this.bytes == null || !this.binary) {
            return new ClickHouseStringValue(this.value);
        }
        byte[] b = this.bytes;
        if (deep) {
            b = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, b, 0, this.bytes.length);
        }
        return new ClickHouseStringValue(b);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.bytes == null && this.value == null;
    }

    @Override
    public boolean asBoolean() {
        return !this.isNullOrEmpty() && Boolean.parseBoolean(this.asString());
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : Byte.parseByte(this.asString());
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : Short.parseShort(this.asString());
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : Integer.parseInt(this.asString());
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : Long.parseLong(this.asString());
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : new BigInteger(this.asString());
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : Float.parseFloat(this.asString());
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : Double.parseDouble(this.asString());
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNullOrEmpty() ? null : new BigDecimal(this.asBigInteger(), scale);
    }

    @Override
    public LocalDate asDate() {
        return this.isNullOrEmpty() ? null : LocalDate.parse(this.asString(), ClickHouseValues.DATE_FORMATTER);
    }

    @Override
    public LocalTime asTime() {
        return this.isNullOrEmpty() ? null : LocalTime.parse(this.asString(), ClickHouseValues.TIME_FORMATTER);
    }

    @Override
    public LocalDateTime asDateTime(int scale) {
        return this.isNullOrEmpty() ? null : LocalDateTime.parse(this.asString(), ClickHouseValues.DATETIME_FORMATTER);
    }

    @Override
    public <T extends Enum<T>> T asEnum(Class<T> enumType) {
        return this.isNullOrEmpty() ? null : (T)Enum.valueOf(enumType, this.asString());
    }

    @Override
    public Inet4Address asInet4Address() {
        return ClickHouseValues.convertToIpv4(this.asString());
    }

    @Override
    public Inet6Address asInet6Address() {
        return ClickHouseValues.convertToIpv6(this.asString());
    }

    @Override
    public Object asObject() {
        return this.asString();
    }

    @Override
    public byte[] asBinary() {
        if (this.value != null && this.bytes == null) {
            this.bytes = this.value.getBytes(StandardCharsets.UTF_8);
        }
        return this.bytes;
    }

    @Override
    public byte[] asBinary(int length, Charset charset) {
        if (this.value != null && this.bytes == null) {
            this.bytes = this.value.getBytes(charset == null ? StandardCharsets.UTF_8 : charset);
        }
        if (this.bytes != null && length > 0) {
            return ClickHouseChecker.notWithDifferentLength(this.bytes, length);
        }
        return this.bytes;
    }

    @Override
    public String asString() {
        if (this.bytes != null && this.value == null) {
            this.value = new String(this.bytes, StandardCharsets.UTF_8);
        }
        return this.value;
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.value != null && length > 0) {
            if (this.bytes == null) {
                this.bytes = this.value.getBytes(charset == null ? StandardCharsets.UTF_8 : charset);
            }
            ClickHouseChecker.notWithDifferentLength(this.bytes, length);
        }
        return this.value;
    }

    @Override
    public UUID asUuid() {
        return this.isNullOrEmpty() ? null : UUID.fromString(this.asString());
    }

    @Override
    public ClickHouseStringValue resetToNullOrEmpty() {
        return this.set((String)null);
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        if (this.binary) {
            return ClickHouseValues.convertToUnhexExpression(this.bytes);
        }
        return ClickHouseValues.convertToQuotedString(this.asString());
    }

    @Override
    public ClickHouseStringValue update(boolean value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(char value) {
        return this.set(String.valueOf((int)value));
    }

    @Override
    public ClickHouseStringValue update(byte value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(byte[] value) {
        return this.set(value);
    }

    @Override
    public ClickHouseStringValue update(short value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(int value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(long value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(float value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(double value) {
        return this.set(String.valueOf(value));
    }

    @Override
    public ClickHouseValue update(BigInteger value) {
        return this.set(value == null ? null : String.valueOf(value));
    }

    @Override
    public ClickHouseValue update(BigDecimal value) {
        return this.set(value == null ? null : String.valueOf(value));
    }

    @Override
    public ClickHouseStringValue update(Enum<?> value) {
        return this.set(value == null ? null : value.name());
    }

    @Override
    public ClickHouseStringValue update(Inet4Address value) {
        return this.set(value == null ? null : value.getHostAddress());
    }

    @Override
    public ClickHouseStringValue update(Inet6Address value) {
        return this.set(value == null ? null : value.getHostAddress());
    }

    @Override
    public ClickHouseStringValue update(LocalDate value) {
        return this.set(value == null ? null : value.format(ClickHouseValues.DATE_FORMATTER));
    }

    @Override
    public ClickHouseStringValue update(LocalTime value) {
        return this.set(value == null ? null : value.format(ClickHouseValues.TIME_FORMATTER));
    }

    @Override
    public ClickHouseStringValue update(LocalDateTime value) {
        return this.set(value == null ? null : value.format(ClickHouseValues.DATETIME_FORMATTER));
    }

    @Override
    public ClickHouseStringValue update(String value) {
        return this.set(value);
    }

    @Override
    public ClickHouseStringValue update(UUID value) {
        return this.set(value == null ? null : value.toString());
    }

    @Override
    public ClickHouseStringValue update(ClickHouseValue value) {
        return this.set(value == null ? null : value.asString());
    }

    @Override
    public ClickHouseStringValue update(Object value) {
        return this.update(value == null ? null : value.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.binary ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseStringValue v = (ClickHouseStringValue)obj;
        return this.binary == v.binary && Objects.equals(this.bytes, v.bytes) && Objects.equals(this.value, v.value);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

