/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark.misc;

import com.clickhouse.benchmark.BaseState;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.config.ClickHouseBufferingMode;
import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.format.BinaryStreamUtils;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Measurement(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Fork(value=2)
@Threads(value=-1)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class QueueBenchmark {
    @Benchmark
    public void ideal(CompareState state, Blackhole consumer) {
        long range = state.samples;
        byte[] bytes = new byte[8];
        ClickHouseByteBuffer buffer = ClickHouseByteBuffer.of((byte[])bytes);
        for (long i = 0L; i < range; ++i) {
            BinaryStreamUtils.setInt64((byte[])bytes, (int)0, (long)i);
            consumer.consume(buffer.asLong());
            buffer.update(bytes);
        }
    }

    @Benchmark
    public void blocking(CompareState state, Blackhole consumer) throws Exception {
        HashMap<ClickHouseClientOption, Boolean> options = new HashMap<ClickHouseClientOption, Boolean>();
        options.put(ClickHouseClientOption.USE_BLOCKING_QUEUE, false);
        ClickHouseConfig config = new ClickHouseConfig(options);
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)config, null);
        CompletableFuture future = ClickHouseClient.submit(() -> {
            long range = state.samples;
            try (ClickHousePipedOutputStream out = stream;){
                for (long i = 0L; i < range; ++i) {
                    BinaryStreamUtils.writeInt64((OutputStream)out, (long)i);
                }
            }
            return range;
        });
        try (ClickHouseInputStream input = stream.getInputStream();){
            consumer.consume(BinaryStreamUtils.readInt64((ClickHouseInputStream)input));
        }
        consumer.consume(future.get());
    }

    @Benchmark
    public void nonBlocking(CompareState state, Blackhole consumer) throws Exception {
        ClickHouseConfig config = new ClickHouseConfig(Collections.singletonMap(ClickHouseClientOption.RESPONSE_BUFFERING, ClickHouseBufferingMode.PERFORMANCE));
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream((ClickHouseDataConfig)config, null);
        CompletableFuture future = ClickHouseClient.submit(() -> {
            long range = state.samples;
            try (ClickHousePipedOutputStream out = stream;){
                for (long i = 0L; i < range; ++i) {
                    BinaryStreamUtils.writeInt64((OutputStream)out, (long)i);
                }
            }
            return range;
        });
        try (ClickHouseInputStream input = stream.getInputStream();){
            consumer.consume(BinaryStreamUtils.readInt64((ClickHouseInputStream)input));
        }
        consumer.consume(future.get());
    }

    @State(value=Scope.Thread)
    public static class CompareState
    extends BaseState {
        public long samples;

        @Setup(value=Level.Trial)
        public void setupSamples() {
            this.samples = 5000000L;
        }

        @Setup(value=Level.Iteration)
        public void initValueClass() {
        }
    }
}

