/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark.jdbc;

import com.clickhouse.benchmark.jdbc.DriverState;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Measurement(iterations=10, timeUnit=TimeUnit.SECONDS, time=1)
@Fork(value=2)
@Threads(value=-1)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public abstract class DriverBenchmark {
    private final int BATCH_SIZE = Integer.parseInt(System.getProperty("batchSize", "5000"));
    private final int FETCH_SIZE = Integer.parseInt(System.getProperty("fetchSize", "1000"));

    protected PreparedStatement setParameters(PreparedStatement s, Object ... values) throws SQLException {
        if (values != null && values.length > 0) {
            int index = 1;
            for (Object v : values) {
                s.setObject(index++, v);
            }
        }
        return s;
    }

    protected String replaceParameters(String sql, Object ... values) {
        if (values != null && values.length > 0) {
            for (Object v : values) {
                int index = sql.indexOf(63);
                if (index == -1) break;
                String expr = null;
                expr = v instanceof Number ? String.valueOf(v) : "'" + v + "'";
                sql = sql.substring(0, index) + expr + sql.substring(index + 1);
            }
        }
        return sql;
    }

    private int processBatch(Statement s, String sql, Enumeration<Object[]> generator) throws SQLException {
        PreparedStatement ps;
        int rows = 0;
        int counter = 0;
        PreparedStatement preparedStatement = ps = s instanceof PreparedStatement ? (PreparedStatement)s : null;
        while (generator.hasMoreElements()) {
            Object[] values = generator.nextElement();
            if (ps != null) {
                this.setParameters(ps, values);
                if (this.BATCH_SIZE > 0) {
                    ps.addBatch();
                } else {
                    ps.execute();
                    ++rows;
                }
            } else {
                sql = this.replaceParameters(sql, values);
                if (this.BATCH_SIZE > 0) {
                    s.addBatch(sql);
                } else {
                    s.execute(sql);
                    ++rows;
                }
            }
            if (this.BATCH_SIZE <= 0 || ++counter % this.BATCH_SIZE != 0) continue;
            rows += s.executeBatch().length;
        }
        if (this.BATCH_SIZE > 0 && counter % this.BATCH_SIZE != 0) {
            rows += s.executeBatch().length;
        }
        return rows;
    }

    protected int executeInsert(DriverState state, String sql, Enumeration<Object[]> generator) throws SQLException {
        Objects.requireNonNull(generator);
        Connection conn = state.getConnection();
        int rows = 0;
        if (state.usePreparedStatement()) {
            try (PreparedStatement s = conn.prepareStatement(sql);){
                rows = this.processBatch(s, sql, generator);
            }
        }
        try (Statement s = conn.createStatement();){
            rows = this.processBatch(s, sql, generator);
        }
        return rows;
    }

    protected Statement executeQuery(DriverState state, String sql, Object ... values) throws SQLException {
        Statement stmt;
        Connection conn = state.getConnection();
        if (state.usePreparedStatement()) {
            PreparedStatement s = conn.prepareStatement(sql);
            stmt = s;
            s.setFetchSize(this.FETCH_SIZE);
            this.setParameters(s, values).executeQuery();
        } else {
            stmt = conn.createStatement();
            stmt.setFetchSize(this.FETCH_SIZE);
            stmt.executeQuery(this.replaceParameters(sql, values));
        }
        return stmt;
    }
}

