/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.benchmark.client;

import com.clickhouse.benchmark.BaseState;
import com.clickhouse.benchmark.Constants;
import com.clickhouse.benchmark.ServerState;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import java.io.Serializable;
import java.util.concurrent.Future;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class ClientState
extends BaseState {
    @Param(value={"GRPC"})
    private String protocol;
    @Param(value={"reuse", "new"})
    private String connection;
    @Param(value={"RowBinaryWithNamesAndTypes", "TabSeparatedWithNamesAndTypes"})
    private String format;
    @Param(value={"async", "sync"})
    private String mode;
    @Param(value={"netty", "okhttp"})
    private String transport;
    private ClickHouseNode server;
    private ClickHouseClient client;
    private int randomSample;
    private int randomNum;

    private ClickHouseClient createClient() {
        String bufferSize = System.getProperty("bufferSize");
        String compression = System.getProperty("compression");
        String threads = System.getProperty("threads");
        String window = System.getProperty("window");
        ClickHouseClientBuilder builder = ClickHouseClient.builder();
        if (bufferSize != null && !bufferSize.isEmpty()) {
            builder.option((ClickHouseOption)ClickHouseClientOption.BUFFER_SIZE, (Serializable)Integer.valueOf(Integer.parseInt(bufferSize)));
        }
        if (compression != null && !compression.isEmpty() && ClickHouseCompression.NONE.name().equalsIgnoreCase(compression)) {
            builder.option((ClickHouseOption)ClickHouseGrpcOption.USE_FULL_STREAM_DECOMPRESSION, (Serializable)Boolean.valueOf(true));
        }
        if (threads != null && !threads.isEmpty()) {
            builder.option((ClickHouseOption)ClickHouseClientOption.MAX_THREADS_PER_CLIENT, (Serializable)Integer.valueOf(Integer.parseInt(threads)));
        }
        if (window != null && !window.isEmpty()) {
            builder.option((ClickHouseOption)ClickHouseGrpcOption.FLOW_CONTROL_WINDOW, (Serializable)Integer.valueOf(Integer.parseInt(window)));
        }
        return builder.option((ClickHouseOption)ClickHouseClientOption.ASYNC, (Serializable)Boolean.valueOf("async".equals(this.mode))).option((ClickHouseOption)ClickHouseGrpcOption.USE_OKHTTP, (Serializable)Boolean.valueOf("okhttp".equals(this.transport))).build();
    }

    @Setup(value=Level.Trial)
    public void doSetup(ServerState serverState) throws ClickHouseException {
        String[] sqls;
        this.server = ClickHouseNode.builder().host(serverState.getHost()).port(ClickHouseProtocol.valueOf((String)this.protocol)).database(serverState.getDatabase()).credentials(ClickHouseCredentials.fromUserAndPassword((String)serverState.getUser(), (String)serverState.getPassword())).build();
        this.client = this.createClient();
        for (String sql : sqls = new String[]{"drop table if exists system.test_insert", "create table if not exists system.test_insert(id String, i Nullable(UInt64), s Nullable(String), t Nullable(DateTime))engine=Memory"}) {
            ClickHouseResponse resp = this.client.connect(this.server).query(sql).executeAndWait();
            if (resp == null) continue;
            resp.close();
        }
    }

    @TearDown(value=Level.Trial)
    public void doTearDown(ServerState serverState) throws ClickHouseException {
        this.dispose();
        try {
            ClickHouseResponse resp = this.client.connect(this.server).query("truncate table system.test_insert").executeAndWait();
            if (resp != null) {
                resp.close();
            }
        }
        finally {
            try {
                this.client.close();
            }
            catch (Exception exception) {}
        }
    }

    @Setup(value=Level.Iteration)
    public void prepare() {
        if (!"reuse".equalsIgnoreCase(this.connection)) {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.client = this.createClient();
        }
        this.randomSample = this.getRandomNumber(Constants.SAMPLE_SIZE);
        this.randomNum = this.getRandomNumber(Constants.FLOATING_RANGE);
    }

    @TearDown(value=Level.Iteration)
    public void shutdown() {
        if (!"reuse".equalsIgnoreCase(this.connection)) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.client = null;
            }
        }
    }

    public ClickHouseFormat getFormat() {
        return ClickHouseFormat.valueOf((String)this.format);
    }

    public int getSampleSize() {
        return Constants.SAMPLE_SIZE;
    }

    public int getRandomSample() {
        return this.randomSample;
    }

    public int getRandomNumber() {
        return this.randomNum;
    }

    public ClickHouseRequest<?> newRequest() {
        return this.client.connect(this.server);
    }

    public void consume(Blackhole blackhole, Future<ClickHouseResponse> future) throws InterruptedException {
        this.consume(blackhole, () -> {
            ClickHouseResponseSummary clickHouseResponseSummary;
            block10: {
                ClickHouseResponse resp = (ClickHouseResponse)future.get();
                try {
                    for (ClickHouseRecord rec : resp.records()) {
                        for (ClickHouseValue val : rec) {
                            blackhole.consume(val.asObject());
                        }
                    }
                    blackhole.consume((Object)resp.getSummary());
                    clickHouseResponseSummary = resp.getSummary();
                    if (resp == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (resp != null) {
                            try {
                                resp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                resp.close();
            }
            return clickHouseResponseSummary;
        });
    }
}

