/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.pushtemplates.styles;

import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import com.clevertap.android.pushtemplates.PTLog;
import com.clevertap.android.pushtemplates.TemplateRenderer;
import com.clevertap.android.pushtemplates.Utils;
import com.clevertap.android.pushtemplates.content.PendingIntentFactory;
import com.clevertap.android.pushtemplates.styles.Style;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J(\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J*\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0007H\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\"\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/clevertap/android/pushtemplates/styles/InputBoxStyle;", "Lcom/clevertap/android/pushtemplates/styles/Style;", "renderer", "Lcom/clevertap/android/pushtemplates/TemplateRenderer;", "<init>", "(Lcom/clevertap/android/pushtemplates/TemplateRenderer;)V", "setNotificationBuilderBasics", "Landroidx/core/app/NotificationCompat$Builder;", "notificationBuilder", "contentViewSmall", "Landroid/widget/RemoteViews;", "contentViewBig", "pt_title", "", "pIntent", "Landroid/app/PendingIntent;", "dIntent", "makeSmallContentRemoteView", "context", "Landroid/content/Context;", "makeBigContentRemoteView", "builderFromStyle", "extras", "Landroid/os/Bundle;", "notificationId", "", "nb", "setStandardViewBigImageStyle", "pt_big_img", "makePendingIntent", "makeDismissIntent", "clevertap-pushtemplates_release"})
public final class InputBoxStyle
extends Style {
    @NotNull
    private TemplateRenderer renderer;

    public InputBoxStyle(@NotNull TemplateRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        super(renderer);
        this.renderer = renderer;
    }

    @Override
    @NotNull
    protected NotificationCompat.Builder setNotificationBuilderBasics(@NotNull NotificationCompat.Builder notificationBuilder, @Nullable RemoteViews contentViewSmall, @Nullable RemoteViews contentViewBig, @Nullable String pt_title, @Nullable PendingIntent pIntent, @Nullable PendingIntent dIntent) {
        Intrinsics.checkNotNullParameter((Object)notificationBuilder, (String)"notificationBuilder");
        NotificationCompat.Builder builder = super.setNotificationBuilderBasics(notificationBuilder, contentViewSmall, contentViewBig, pt_title, pIntent, dIntent).setContentText((CharSequence)this.renderer.getPt_msg$clevertap_pushtemplates_release());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setContentText(...)");
        return builder;
    }

    @Override
    @Nullable
    protected RemoteViews makeSmallContentRemoteView(@NotNull Context context, @NotNull TemplateRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        return null;
    }

    @Override
    @Nullable
    protected RemoteViews makeBigContentRemoteView(@NotNull Context context, @NotNull TemplateRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        return null;
    }

    @Override
    @NotNull
    public NotificationCompat.Builder builderFromStyle(@NotNull Context context, @NotNull Bundle extras, int notificationId, @NotNull NotificationCompat.Builder nb) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        Intrinsics.checkNotNullParameter((Object)nb, (String)"nb");
        NotificationCompat.Builder inputBoxNotificationBuilder = super.builderFromStyle(context, extras, notificationId, nb);
        inputBoxNotificationBuilder = this.setStandardViewBigImageStyle(this.renderer.getPt_big_img$clevertap_pushtemplates_release(), extras, context, inputBoxNotificationBuilder);
        if (this.renderer.getPt_input_label$clevertap_pushtemplates_release() != null) {
            String string = this.renderer.getPt_input_label$clevertap_pushtemplates_release();
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                RemoteInput remoteInput = new RemoteInput.Builder("pt_input_reply").setLabel((CharSequence)this.renderer.getPt_input_label$clevertap_pushtemplates_release()).build();
                Intrinsics.checkNotNullExpressionValue((Object)remoteInput, (String)"build(...)");
                RemoteInput remoteInput2 = remoteInput;
                PendingIntent replyIntent = null;
                PendingIntent pendingIntent = PendingIntentFactory.getPendingIntent(context, notificationId, extras, false, 32, this.renderer);
                Intrinsics.checkNotNull((Object)pendingIntent);
                replyIntent = pendingIntent;
                NotificationCompat.Action action = new NotificationCompat.Action.Builder(17301646, (CharSequence)this.renderer.getPt_input_label$clevertap_pushtemplates_release(), replyIntent).addRemoteInput(remoteInput2).setAllowGeneratedReplies(true).build();
                Intrinsics.checkNotNullExpressionValue((Object)action, (String)"build(...)");
                NotificationCompat.Action replyAction = action;
                inputBoxNotificationBuilder.addAction(replyAction);
            }
        }
        if (this.renderer.getPt_dismiss_on_click$clevertap_pushtemplates_release() != null) {
            String string = this.renderer.getPt_dismiss_on_click$clevertap_pushtemplates_release();
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() > 0) {
                extras.putString("pt_dismiss_on_click", this.renderer.getPt_dismiss_on_click$clevertap_pushtemplates_release());
            }
        }
        this.renderer.setActionButtons(context, extras, notificationId, inputBoxNotificationBuilder, this.renderer.getActions());
        return inputBoxNotificationBuilder;
    }

    private final NotificationCompat.Builder setStandardViewBigImageStyle(String pt_big_img, Bundle extras, Context context, NotificationCompat.Builder notificationBuilder) {
        NotificationCompat.Style bigPictureStyle = null;
        if (pt_big_img != null && StringsKt.startsWith$default((String)pt_big_img, (String)"http", (boolean)false, (int)2, null)) {
            try {
                NotificationCompat.Style style;
                Bitmap bitmap = Utils.getNotificationBitmap(pt_big_img, false, context);
                if (bitmap == null) {
                    throw new Exception("Failed to fetch big picture!");
                }
                Bitmap bpMap = bitmap;
                if (extras.containsKey("pt_msg_summary")) {
                    String summaryText = this.renderer.getPt_msg_summary$clevertap_pushtemplates_release();
                    style = (NotificationCompat.Style)new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)summaryText).bigPicture(bpMap);
                } else {
                    style = (NotificationCompat.Style)new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)this.renderer.getPt_msg$clevertap_pushtemplates_release()).bigPicture(bpMap);
                }
                bigPictureStyle = style;
            }
            catch (Throwable t) {
                bigPictureStyle = (NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)this.renderer.getPt_msg$clevertap_pushtemplates_release());
                PTLog.verbose("Falling back to big text notification, couldn't fetch big picture", t);
            }
        } else {
            bigPictureStyle = (NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)this.renderer.getPt_msg$clevertap_pushtemplates_release());
        }
        notificationBuilder.setStyle(bigPictureStyle);
        return notificationBuilder;
    }

    @Override
    @Nullable
    protected PendingIntent makePendingIntent(@NotNull Context context, @NotNull Bundle extras, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        return PendingIntentFactory.getPendingIntent(context, notificationId, extras, true, 31, this.renderer);
    }

    @Override
    @Nullable
    protected PendingIntent makeDismissIntent(@NotNull Context context, @NotNull Bundle extras, int notificationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        return null;
    }
}

